/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.command.booster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.GeneralCommand;
import su.nexmedia.engine.api.lang.LangMessage;
import su.nexmedia.engine.command.list.HelpSubCommand;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.booster.IBooster;
import su.nightexpress.moneyhunters.basic.config.Lang;
import su.nightexpress.moneyhunters.basic.manager.booster.object.GlobalBooster;

public class BoosterGlobalCommand
extends GeneralCommand<MoneyHunters> {
    public BoosterGlobalCommand(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin, new String[]{"global"}, "moneyhunters.command.booster");
        this.addDefaultCommand((AbstractCommand)new HelpSubCommand((NexPlugin)plugin));
        this.addChildren(new GiveSubCommand(plugin));
        this.addChildren(new RemoveSubCommand(plugin));
    }

    @NotNull
    public String getUsage() {
        return "";
    }

    @NotNull
    public String getDescription() {
        return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_BOOSTER_GLOBAL_DESC).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    protected void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
    }

    static class GiveSubCommand
    extends AbstractCommand<MoneyHunters> {
        public GiveSubCommand(@NotNull MoneyHunters plugin) {
            super((NexPlugin)plugin, new String[]{"create"}, "moneyhunters.command.booster");
        }

        @NotNull
        public String getUsage() {
            return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_BOOSTER_GLOBAL_CREATE_USAGE).getLocalized();
        }

        @NotNull
        public String getDescription() {
            return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_BOOSTER_GLOBAL_CREATE_DESC).getLocalized();
        }

        public boolean isPlayerOnly() {
            return false;
        }

        @NotNull
        public List<String> getTab(@NotNull Player player, int arg, @NotNull String[] args) {
            if (arg == 3) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("<booster_id>");
                list.addAll(((MoneyHunters)this.plugin).getBoosterManager().getBoostersGlobal().stream().map(IBooster::getId).toList());
                return list;
            }
            if (arg == 4) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("<jobId>");
                list.add("<job1,job2>");
                list.add("*");
                list.addAll(((MoneyHunters)this.plugin).getJobManager().getJobIds());
                return list;
            }
            if (arg == 5) {
                return Arrays.asList("<money>", "1.5", "2.0", "3.0");
            }
            if (arg == 6) {
                return Arrays.asList("<exp>", "1.5", "2.0", "3.0");
            }
            if (arg == 7) {
                return Arrays.asList("<minutes>", "30", "60", "1440");
            }
            return super.getTab(player, arg, args);
        }

        protected void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
            if (args.length != 8) {
                this.printUsage(sender);
                return;
            }
            String boosterId = args[3];
            String jobsRaw = args[4];
            Set<String> jobIds = jobsRaw.equalsIgnoreCase("*") ? new HashSet<String>(((MoneyHunters)this.plugin).getJobManager().getJobIds()) : Stream.of(jobsRaw.split(",")).filter(jobId -> ((MoneyHunters)this.plugin).getJobManager().getJobById((String)jobId) != null).collect(Collectors.toSet());
            if (jobIds.isEmpty()) {
                ((MoneyHunters)this.plugin).getMessage(Lang.JOB_ERROR_INVALID_JOB).send(sender);
                return;
            }
            double modMoney = StringUtil.getDouble((String)args[5], (double)1.0);
            double modExp = StringUtil.getDouble((String)args[6], (double)1.0);
            if (modMoney == 1.0 && modExp == 1.0) {
                this.errorNumber(sender, args[5] + "/" + args[6]);
                return;
            }
            int duration = StringUtil.getInteger((String)args[7], (int)0);
            if (duration == 0) {
                this.errorNumber(sender, args[7]);
                return;
            }
            GlobalBooster booster = new GlobalBooster(boosterId, jobIds, modMoney, modExp, duration);
            ((MoneyHunters)this.plugin).getBoosterManager().getBoostersGlobal().removeIf(boosterHas -> boosterHas.getId().equalsIgnoreCase(boosterId));
            ((MoneyHunters)this.plugin).getBoosterManager().getBoostersGlobal().add(booster);
            ((MoneyHunters)this.plugin).getBoosterManager().updateBoosters();
            ((MoneyHunters)this.plugin).getBoosterManager().notifyBooster();
            ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_BOOSTER_GLOBAL_CREATE_DONE).replace(booster.replacePlaceholders()).send(sender);
        }
    }

    static class RemoveSubCommand
    extends AbstractCommand<MoneyHunters> {
        public RemoveSubCommand(@NotNull MoneyHunters plugin) {
            super((NexPlugin)plugin, new String[]{"remove"}, "moneyhunters.command.booster");
        }

        @NotNull
        public String getUsage() {
            return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_BOOSTER_GLOBAL_REMOVE_USAGE).getLocalized();
        }

        @NotNull
        public String getDescription() {
            return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_BOOSTER_GLOBAL_REMOVE_DESC).getLocalized();
        }

        public boolean isPlayerOnly() {
            return false;
        }

        @NotNull
        public List<String> getTab(@NotNull Player player, int arg, @NotNull String[] args) {
            if (arg == 3) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("*");
                list.addAll(((MoneyHunters)this.plugin).getBoosterManager().getBoostersGlobal().stream().map(IBooster::getId).toList());
                return list;
            }
            return super.getTab(player, arg, args);
        }

        protected void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
            if (args.length != 4) {
                this.printUsage(sender);
                return;
            }
            String id = args[3];
            boolean removed = ((MoneyHunters)this.plugin).getBoosterManager().getBoostersGlobal().removeIf(boosterHas -> boosterHas.getId().equalsIgnoreCase(id) || id.equalsIgnoreCase("*"));
            LangMessage msgNotify = removed ? ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_BOOSTER_GLOBAL_REMOVE_DONE) : ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_BOOSTER_GLOBAL_REMOVE_ERROR_NOTHING);
            msgNotify.replace("%booster_id%", (Object)id).send(sender);
            ((MoneyHunters)this.plugin).getBoosterManager().updateBoosters();
        }
    }
}

