/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.command.base;

import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.utils.PlayerUtil;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.config.Lang;
import su.nightexpress.moneyhunters.basic.data.object.MoneyUser;
import su.nightexpress.moneyhunters.basic.data.object.UserJobData;

public class ResetCommand
extends AbstractCommand<MoneyHunters> {
    public ResetCommand(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin, new String[]{"reset"}, "moneyhunters.command.reset");
    }

    @NotNull
    public String getUsage() {
        return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_RESET_USAGE).getLocalized();
    }

    @NotNull
    public String getDescription() {
        return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_RESET_DESC).getLocalized();
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int arg, @NotNull String[] args) {
        if (arg == 1) {
            return ((MoneyHunters)this.plugin).getJobManager().getJobIds();
        }
        if (arg == 2 && player.hasPermission("moneyhunters.command.reset.others")) {
            return PlayerUtil.getPlayerNames();
        }
        return super.getTab(player, arg, args);
    }

    public boolean isPlayerOnly() {
        return false;
    }

    public void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        Player target;
        if (args.length < 2) {
            this.printUsage(sender);
            return;
        }
        if (args.length >= 3 && !sender.hasPermission("moneyhunters.command.reset.others")) {
            this.errorPermission(sender);
            return;
        }
        IJob<?> job = ((MoneyHunters)this.plugin).getJobManager().getJobById(args[1]);
        if (job == null) {
            ((MoneyHunters)this.plugin).getMessage(Lang.JOB_ERROR_INVALID_JOB).send(sender);
            return;
        }
        String pName = args.length >= 3 ? args[2] : sender.getName();
        MoneyUser user = (MoneyUser)((MoneyHunters)this.plugin).getUserManager().getUserData(pName);
        if (user == null) {
            this.errorPlayer(sender);
            return;
        }
        UserJobData data = user.getJobData(job);
        data.reset();
        if (!sender.getName().equalsIgnoreCase(user.getName())) {
            ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_RESET_DONE).replace(data.replacePlaceholders()).replace("%player%", (Object)user.getName()).send(sender);
        }
        if ((target = user.getPlayer()) != null) {
            ((MoneyHunters)this.plugin).getMessage(Lang.JOBS_RESET_SUCCESS).replace(data.replacePlaceholders()).send((CommandSender)target);
        }
    }
}

