/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.command.base;

import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.utils.MessageUtil;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.booster.IBooster;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.config.Lang;
import su.nightexpress.moneyhunters.basic.data.object.MoneyUser;
import su.nightexpress.moneyhunters.basic.data.object.UserJobData;

public class InfoCommand
extends AbstractCommand<MoneyHunters> {
    public InfoCommand(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin, new String[]{"info"}, (String)null);
    }

    @NotNull
    public String getUsage() {
        return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_INFO_USAGE).getLocalized();
    }

    @NotNull
    public String getDescription() {
        return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_INFO_DESC).getLocalized();
    }

    public boolean isPlayerOnly() {
        return true;
    }

    @NotNull
    public @NotNull List<@NotNull String> getTab(@NotNull Player player, int arg, @NotNull String[] args) {
        if (arg == 1) {
            return ((MoneyHunters)this.plugin).getJobManager().getJobIds();
        }
        return super.getTab(player, arg, args);
    }

    protected void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        if (args.length < 2) {
            this.printUsage(sender);
            return;
        }
        IJob<?> job = ((MoneyHunters)this.plugin).getJobManager().getJobById(args[1]);
        if (job == null) {
            ((MoneyHunters)this.plugin).getMessage(Lang.JOB_ERROR_INVALID_JOB).send(sender);
            return;
        }
        Player player = (Player)sender;
        MoneyUser user = (MoneyUser)((MoneyHunters)this.plugin).getUserManager().getUserData(player);
        UserJobData progress = user.getJobData(job);
        ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_INFO_DISPLAY).asList().forEach(line -> {
            line = (String)progress.replacePlaceholders().apply((String)line);
            if (line.contains("%booster_")) {
                for (IBooster booster : user.getBoosters(job)) {
                    MessageUtil.sendWithJSON((CommandSender)player, (String)((String)booster.replacePlaceholders().apply(line)));
                }
                return;
            }
            MessageUtil.sendWithJSON((CommandSender)player, (String)line);
        });
    }
}

