/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.command.base;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.GeneralCommand;
import su.nexmedia.engine.api.lang.LangMessage;
import su.nexmedia.engine.command.list.HelpSubCommand;
import su.nexmedia.engine.utils.PlayerUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.config.Lang;
import su.nightexpress.moneyhunters.basic.data.object.MoneyUser;
import su.nightexpress.moneyhunters.basic.data.object.UserJobData;

public class ExpCommand
extends GeneralCommand<MoneyHunters> {
    public ExpCommand(@NotNull MoneyHunters plugin) {
        super((NexPlugin)plugin, new String[]{"exp"}, "moneyhunters.command.exp");
        this.addDefaultCommand((AbstractCommand)new HelpSubCommand((NexPlugin)plugin));
        this.addChildren(new SubCommand(plugin, new String[]{"add"}, Mode.ADD));
        this.addChildren(new SubCommand(plugin, new String[]{"take"}, Mode.TAKE));
        this.addChildren(new SubCommand(plugin, new String[]{"set"}, Mode.SET));
    }

    @NotNull
    public String getUsage() {
        return "";
    }

    @NotNull
    public String getDescription() {
        return ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_DESC).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    protected void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
    }

    private static class SubCommand
    extends AbstractCommand<MoneyHunters> {
        private final Mode mode;

        public SubCommand(@NotNull MoneyHunters plugin, @NotNull String[] aliases, @NotNull Mode mode) {
            super((NexPlugin)plugin, aliases, "moneyhunters.command.exp");
            this.mode = mode;
        }

        @NotNull
        public String getUsage() {
            return switch (this.mode) {
                case Mode.ADD -> ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_ADD_USAGE).getLocalized();
                case Mode.TAKE -> ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_TAKE_USAGE).getLocalized();
                case Mode.SET -> ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_SET_USAGE).getLocalized();
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @NotNull
        public String getDescription() {
            return switch (this.mode) {
                case Mode.ADD -> ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_ADD_DESC).getLocalized();
                case Mode.TAKE -> ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_TAKE_DESC).getLocalized();
                case Mode.SET -> ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_SET_DESC).getLocalized();
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @NotNull
        public List<String> getTab(@NotNull Player player, int arg, @NotNull String[] args) {
            if (arg == 2) {
                return PlayerUtil.getPlayerNames();
            }
            if (arg == 3) {
                return ((MoneyHunters)this.plugin).getJobManager().getJobIds();
            }
            if (arg == 4) {
                return this.mode == Mode.SET ? Collections.singletonList("0") : Arrays.asList("50", "100");
            }
            if (arg == 5 && this.mode == Mode.ADD) {
                return Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString());
            }
            return super.getTab(player, arg, args);
        }

        public boolean isPlayerOnly() {
            return false;
        }

        public void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
            if (args.length < 5) {
                this.printUsage(sender);
                return;
            }
            IJob<?> job = ((MoneyHunters)this.plugin).getJobManager().getJobById(args[3]);
            if (job == null) {
                ((MoneyHunters)this.plugin).getMessage(Lang.JOB_ERROR_INVALID_JOB).send(sender);
                return;
            }
            int exp = Math.abs(StringUtil.getInteger((String)args[4], (int)0, (boolean)true));
            if (exp == 0) {
                this.errorNumber(sender, args[4]);
                return;
            }
            MoneyUser user = (MoneyUser)((MoneyHunters)this.plugin).getUserManager().getUserData(args[2]);
            if (user == null) {
                this.errorPlayer(sender);
                return;
            }
            boolean allowBooster = this.mode == Mode.ADD && args.length >= 6 && Boolean.parseBoolean(args[5]);
            UserJobData jobData = user.getJobData(job);
            LangMessage message = switch (this.mode) {
                case Mode.ADD -> {
                    user.addJobExp(job, exp, allowBooster);
                    yield ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_ADD_DONE);
                }
                case Mode.TAKE -> {
                    user.addJobExp(job, -exp, false);
                    yield ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_TAKE_DONE);
                }
                case Mode.SET -> {
                    jobData.setJobExp(exp);
                    yield ((MoneyHunters)this.plugin).getMessage(Lang.COMMAND_EXP_SET_DONE);
                }
                default -> throw new IncompatibleClassChangeError();
            };
            jobData.update();
            message.replace(jobData.replacePlaceholders()).replace("%player%", (Object)user.getName()).replace("%amount%", (Object)exp).send(sender);
        }
    }

    private static enum Mode {
        ADD,
        TAKE,
        SET;

    }
}

