/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.api.money;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexEngine;
import su.nexmedia.engine.hooks.Hooks;
import su.nexmedia.engine.hooks.external.MythicMobsHook;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.Scaler;
import su.nightexpress.moneyhunters.basic.api.currency.ICurrency;
import su.nightexpress.moneyhunters.basic.api.money.IMoneyObjective;
import su.nightexpress.moneyhunters.basic.api.money.ObjectiveLimitType;

public abstract class AbstractMoneyObjective
implements IMoneyObjective {
    protected String type;
    protected double chance;
    protected double moneyMin;
    protected double moneyMax;
    protected int expMin;
    protected int expMax;
    protected int unlockLevel;
    protected Map<ObjectiveLimitType, Scaler> limit;

    public AbstractMoneyObjective(@NotNull String type, double chance, double moneyMin, double moneyMax, int expMin, int expMax, int unlockLevel, @NotNull Map<ObjectiveLimitType, Scaler> limit) {
        this.setType(type);
        this.setChance(chance);
        this.setMoneyMin(moneyMin);
        this.setMoneyMax(moneyMax);
        this.setExpMin(expMin);
        this.setExpMax(expMax);
        this.setUnlockLevel(unlockLevel);
        this.limit = new HashMap<ObjectiveLimitType, Scaler>();
        this.limit.putAll(limit);
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return str -> str.replace("%objective_name%", this.getName()).replace("%objective_chance%", NumberUtil.format((double)this.getChance())).replace("%objective_exp_min%", NumberUtil.format((double)this.getExpMin())).replace("%objective_exp_max%", NumberUtil.format((double)this.getExpMax())).replace("%objective_unlock_level%", String.valueOf(this.getUnlockLevel()));
    }

    @Override
    @NotNull
    public UnaryOperator<String> replacePlaceholders(@NotNull ICurrency currency, int jobLevel) {
        return str -> (String)this.replacePlaceholders().apply(str.replace("%objective_money_min%", currency.format(this.getMoneyMin())).replace("%objective_money_max%", currency.format(this.getMoneyMax())).replace("%objective_limit_money%", currency.format(this.getDailyLimit(ObjectiveLimitType.MONEY, jobLevel))).replace("%objective_limit_exp%", NumberUtil.format((double)this.getDailyLimit(ObjectiveLimitType.EXP, jobLevel))));
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        String typeRaw = this.getType().toUpperCase();
        Material material = Material.getMaterial((String)typeRaw);
        if (material != null) {
            return NexEngine.get().getLangManager().getEnum((Enum)material);
        }
        if (Hooks.hasMythicMobs() && MythicMobsHook.getMobConfig((String)typeRaw) != null) {
            return MythicMobsHook.getMobDisplayName((String)typeRaw);
        }
        EntityType entityType = (EntityType)CollectionsUtil.getEnum((String)typeRaw, EntityType.class);
        if (entityType != null) {
            return NexEngine.get().getLangManager().getEnum((Enum)entityType);
        }
        return this.getType();
    }

    @Override
    public void setType(@NotNull String type) {
        this.type = type.toLowerCase();
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public void setChance(double chance) {
        this.chance = chance;
    }

    @Override
    public double getMoneyMin() {
        return this.moneyMin;
    }

    @Override
    public void setMoneyMin(double moneyMin) {
        this.moneyMin = moneyMin;
    }

    @Override
    public double getMoneyMax() {
        return this.moneyMax;
    }

    @Override
    public void setMoneyMax(double moneyMax) {
        this.moneyMax = moneyMax;
    }

    @Override
    public int getExpMin() {
        return this.expMin;
    }

    @Override
    public void setExpMin(int expMin) {
        this.expMin = expMin;
    }

    @Override
    public int getExpMax() {
        return this.expMax;
    }

    @Override
    public void setExpMax(int expMax) {
        this.expMax = expMax;
    }

    @Override
    public int getUnlockLevel() {
        return this.unlockLevel;
    }

    @Override
    public void setUnlockLevel(int unlockLevel) {
        this.unlockLevel = unlockLevel;
    }

    @Override
    public double getDailyLimit(@NotNull ObjectiveLimitType type, int level) {
        Scaler scaler = this.limit.get((Object)type);
        return scaler == null ? 0.0 : scaler.getValue(level);
    }

    @Override
    public void setDailyLimit(@NotNull ObjectiveLimitType type, @NotNull Scaler scaler) {
        this.limit.put(type, scaler);
    }
}

