/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.api.job;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractLoadableItem;
import su.nexmedia.engine.utils.Evaluator;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.Scaler;
import su.nexmedia.engine.utils.StringUtil;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.currency.ICurrency;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.job.JobScaler;
import su.nightexpress.moneyhunters.basic.api.job.JobState;
import su.nightexpress.moneyhunters.basic.api.job.JobType;
import su.nightexpress.moneyhunters.basic.api.money.IMoneyObjective;
import su.nightexpress.moneyhunters.basic.api.money.ObjectiveLimitType;
import su.nightexpress.moneyhunters.basic.config.Config;
import su.nightexpress.moneyhunters.basic.data.object.MoneyUser;
import su.nightexpress.moneyhunters.basic.data.object.UserJobData;
import su.nightexpress.moneyhunters.basic.manager.money.MoneyManager;
import su.nightexpress.moneyhunters.basic.manager.money.object.MoneyObjective;

public abstract class AbstractJob<E extends Event>
extends AbstractLoadableItem<MoneyHunters>
implements IJob<E> {
    protected JobType type;
    protected ICurrency currency;
    protected String name;
    protected boolean isPermissionRequired;
    protected List<String> description;
    protected ItemStack icon;
    protected JobState stateDefault;
    protected Set<JobState> stateAllowed;
    protected int levelStart;
    protected Map<JobState, Integer> levelMax;
    protected int levelExpStart;
    protected TreeMap<Integer, Integer> levelExpMap;
    protected Map<JobState, JobScaler> moneyMultiplier;
    protected Map<String, IMoneyObjective> objectives;

    public AbstractJob(@NotNull MoneyHunters plugin, @NotNull JYML cfg, @NotNull JobType jobType) {
        super((NexPlugin)plugin, cfg);
        if (!cfg.isConfigurationSection("Leveling.Money_Multiplier")) {
            int oldLevelMax = cfg.getInt("Leveling.Max_Level", -1);
            String oldMoneyMultiplier = cfg.getString("Leveling.Money_Multiplier", "1");
            for (JobState state : JobState.values()) {
                cfg.addMissing("Leveling.Max_Level." + state.name(), (Object)oldLevelMax);
                cfg.addMissing("Leveling.Money_Multiplier." + state.name(), (Object)oldMoneyMultiplier);
            }
            if (oldLevelMax != -1) {
                cfg.remove("Leveling.Max_Level");
                cfg.remove("Leveling.Money_Multiplier");
            }
        }
        cfg.saveChanges();
        this.type = jobType;
        this.name = StringUtil.color((String)cfg.getString("Name", this.getId()));
        this.currency = plugin.getCurrencyManager().getCurrency(cfg.getString("Currency", "vault"));
        if (this.currency == null) {
            throw new IllegalArgumentException("Invalid currency provided!");
        }
        this.isPermissionRequired = cfg.getBoolean("Permission_Required");
        this.description = StringUtil.color((List)cfg.getStringList("Description"));
        this.icon = cfg.getItem("Icon");
        ItemUtil.replace((ItemStack)this.icon, this.replacePlaceholders());
        this.stateDefault = JobState.PRIMARY;
        this.stateAllowed = Sets.newHashSet((Object[])new JobState[]{JobState.PRIMARY});
        this.levelStart = 1;
        this.levelMax = new HashMap<JobState, Integer>();
        for (JobState state : JobState.values()) {
            this.levelMax.put(state, cfg.getInt("Leveling.Max_Level." + state.name()));
        }
        this.levelExpStart = cfg.getInt("Leveling.Start_Exp");
        this.levelExpMap = new TreeMap();
        if (Config.LEVELING_ENABLED) {
            String expFormula = cfg.getString("Leveling.Exp_Formula", "");
            for (int level = this.getLevelStart(); level < this.getLevelMax(JobState.PRIMARY) + 1; ++level) {
                int expPrev = this.levelExpMap.getOrDefault(level - 1, this.getLevelExpStart());
                String toCalc = expFormula.replace("%exp%", String.valueOf(expPrev));
                int expToLevel = level == this.getLevelStart() ? expPrev : (int)Evaluator.evaluate((String)toCalc);
                this.levelExpMap.put(level, expToLevel);
            }
            this.moneyMultiplier = new HashMap<JobState, JobScaler>();
            for (JobState state : JobState.values()) {
                this.moneyMultiplier.put(state, new JobScaler(cfg, "Leveling.Money_Multiplier." + state.name(), this));
            }
            if (this.levelExpMap.isEmpty()) {
                throw new IllegalStateException("Empty level exp table!");
            }
        }
        this.objectives = new TreeMap<String, IMoneyObjective>();
        for (JYML configObjective : JYML.loadAll((String)(cfg.getFile().getParentFile().getAbsolutePath() + "/objectives/"), (boolean)true)) {
            for (String objType : configObjective.getSection("")) {
                String path = objType + ".";
                boolean mEnabled = configObjective.getBoolean(path + "Enabled", true);
                if (!mEnabled) continue;
                double moChance = configObjective.getDouble(path + "Chance");
                double mMoneyMin = configObjective.getDouble(path + "Money.Min");
                double mMoneyMax = configObjective.getDouble(path + "Money.Max");
                int mExpMin = configObjective.getInt(path + "Exp.Min");
                int mExpMax = configObjective.getInt(path + "Exp.Max");
                MoneyObjective objective = new MoneyObjective(objType, moChance, mMoneyMin, mMoneyMax, mExpMin, mExpMax);
                this.objectives.put(objective.getType(), objective);
            }
            configObjective.saveChanges();
        }
    }

    public void onSave() {
    }

    public void clear() {
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return str -> str.replace("%job_id%", this.getId()).replace("%job_name%", this.getName()).replace("%job_description%", String.join((CharSequence)"\n", this.getDescription())).replace("%job_icon_name%", ItemUtil.getItemName((ItemStack)this.getIcon())).replace("%job_icon_lore%", String.join((CharSequence)"\n", ItemUtil.getLore((ItemStack)this.getIcon())));
    }

    @Override
    public void onJobEvent(@NotNull E event, @NotNull Player player, @NotNull String object) {
        if (!this.hasPermission(player)) {
            return;
        }
        if (!MoneyManager.isMoneyAvailable(player)) {
            return;
        }
        IMoneyObjective moneyObjective = this.getObjective(object);
        if (moneyObjective == null) {
            return;
        }
        MoneyUser user = (MoneyUser)((MoneyHunters)this.plugin).getUserManager().getUserData(player);
        UserJobData jobData = user.getJobData(this);
        if (!this.hasObjectiveUnlockLevelBypass(player) && moneyObjective.getUnlockLevel() > jobData.getJobLevel()) {
            return;
        }
        if (!Rnd.chance((double)moneyObjective.getChance())) {
            return;
        }
        ICurrency currency = this.getCurrency();
        double moneyRoll = moneyObjective.getMoney();
        double expRoll = moneyObjective.getExp();
        if (moneyRoll > 0.0) {
            if (jobData.isObjectWasted(moneyObjective, ObjectiveLimitType.MONEY) && !this.hasObjectiveLimitBypass(player, ObjectiveLimitType.MONEY)) {
                moneyRoll = 0.0;
            } else {
                moneyRoll *= user.getBoosterMoney(this);
                moneyRoll *= jobData.getMoneyModifier();
            }
        }
        if (expRoll > 0.0) {
            expRoll = jobData.isObjectWasted(moneyObjective, ObjectiveLimitType.EXP) && !this.hasObjectiveLimitBypass(player, ObjectiveLimitType.EXP) ? 0.0 : (expRoll *= user.getBoosterExp(this));
        }
        user.addJobExp(this, moneyObjective.getType(), expRoll, false);
        if (moneyRoll == 0.0 || moneyRoll < 1.0 && moneyRoll > 0.0 && currency.isIntegerOnly()) {
            return;
        }
        ItemStack moneyItem = currency.createMoney(moneyRoll, player, this, moneyObjective);
        if (moneyRoll <= 0.0 || currency.isDirectToBalance()) {
            ((MoneyHunters)this.plugin).getMoneyManager().pickupMoney(player, moneyItem);
            return;
        }
        this.handleEvent(event, player, moneyObjective, moneyItem);
    }

    protected abstract void handleEvent(@NotNull E var1, @NotNull Player var2, @NotNull IMoneyObjective var3, @NotNull ItemStack var4);

    @Override
    public boolean hasPermission(@NotNull Player player) {
        return !this.isPermissionRequired() || player.hasPermission("moneyhunters.job." + this.getId());
    }

    @Override
    public boolean hasObjectiveUnlockLevelBypass(@NotNull Player player) {
        return true;
    }

    @Override
    public boolean hasObjectiveLimitBypass(@NotNull Player player, ObjectiveLimitType limitType) {
        return true;
    }

    @Override
    @NotNull
    public JobType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ICurrency getCurrency() {
        return this.currency;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPermissionRequired() {
        return this.isPermissionRequired;
    }

    @Override
    @NotNull
    public List<String> getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public ItemStack getIcon() {
        return new ItemStack(this.icon);
    }

    @Override
    @NotNull
    public JobState getStateDefault() {
        return this.stateDefault;
    }

    @Override
    @NotNull
    public Set<JobState> getStateAllowed() {
        return this.stateAllowed;
    }

    @Override
    public int getLevelExpStart() {
        return this.levelExpStart;
    }

    @Override
    public int getExpForLevel(int jobLevel) {
        Map.Entry<Integer, Integer> entry = this.levelExpMap.floorEntry(jobLevel);
        return entry != null ? entry.getValue().intValue() : this.getLevelExpStart();
    }

    @Override
    public int getLevelStart() {
        return this.levelStart;
    }

    @Override
    public int getLevelMax(@NotNull JobState state) {
        return this.levelMax.getOrDefault((Object)state, 0);
    }

    @Override
    public double getMoneyMultiplier(@NotNull JobState state, int jobLevel) {
        Scaler scaler = this.moneyMultiplier.get((Object)state);
        return scaler == null ? 1.0 : scaler.getValue(jobLevel);
    }

    @Override
    @NotNull
    public Collection<IMoneyObjective> getObjectives() {
        return this.objectives.values();
    }

    @Override
    @Nullable
    public IMoneyObjective getObjective(@NotNull String id) {
        return this.objectives.get(id.toLowerCase());
    }
}

