/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.api.currency;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.utils.EffectUtil;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.PDCUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.moneyhunters.basic.Keys;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.api.currency.ICurrency;
import su.nightexpress.moneyhunters.basic.api.job.IJob;
import su.nightexpress.moneyhunters.basic.api.money.IMoneyObjective;
import su.nightexpress.moneyhunters.basic.config.Config;

public abstract class AbstractCurrency
implements ICurrency {
    protected String id;
    protected String name;
    protected String formatDisplay;
    protected NumberFormat formatAmount;
    protected boolean isDirectToBalance;
    protected boolean isIntegerOnly;
    protected Particle dropEffectParticle;
    protected String dropEffectParticleData;
    protected Sound pickupEffectSound;
    protected boolean isDeathPenaltyEnabled;
    protected boolean isDeathPenaltyDropItem;
    protected double deathPenaltyChance;
    protected double[] deathPenaltyAmount;
    protected TreeMap<Integer, ItemStack> itemStyle;

    public AbstractCurrency(@NotNull MoneyHunters plugin, @NotNull JYML cfg) {
        String oldParticle = cfg.getString("Visual_Effects.Particle_Drop", "");
        String oldSound = cfg.getString("Visual_Effects.Sound_Pickup", "");
        cfg.addMissing("Visual_Effects.Drop.Particle.Name", (Object)oldParticle);
        cfg.addMissing("Visual_Effects.Drop.Particle.Data", (Object)"");
        cfg.addMissing("Visual_Effects.Pickup.Sound", (Object)oldSound);
        cfg.remove("Visual_Effects.Particle_Drop");
        cfg.remove("Visual_Effects.Sound_Pickup");
        cfg.saveChanges();
        this.id = cfg.getFile().getName().replace(".yml", "");
        this.name = StringUtil.color((String)cfg.getString("Name", this.id));
        this.formatDisplay = StringUtil.color((String)cfg.getString("Format_Display", "%currency_name%%amount%"));
        this.formatAmount = new DecimalFormat(cfg.getString("Format_Amount", "###,###.##"), new DecimalFormatSymbols(Locale.ENGLISH));
        this.isDirectToBalance = cfg.getBoolean("Direct_To_Balance");
        this.isIntegerOnly = cfg.getBoolean("Integer_Only");
        this.dropEffectParticle = (Particle)cfg.getEnum("Visual_Effects.Drop.Particle.Name", Particle.class);
        this.dropEffectParticleData = cfg.getString("Visual_Effects.Drop.Particle.Data", "");
        this.pickupEffectSound = (Sound)cfg.getEnum("Visual_Effects.Pickup.Sound", Sound.class);
        Object path = "Death_Penalty.";
        this.isDeathPenaltyEnabled = cfg.getBoolean((String)path + "Enabled");
        this.isDeathPenaltyDropItem = !cfg.getBoolean((String)path + "Do_Not_Drop_Item");
        this.deathPenaltyChance = cfg.getDouble((String)path + "Chance");
        this.deathPenaltyAmount = new double[2];
        this.deathPenaltyAmount[0] = cfg.getDouble((String)path + "Percent_Of_Balance.Minimal");
        this.deathPenaltyAmount[1] = cfg.getDouble((String)path + "Percent_Of_Balance.Maximal");
        this.itemStyle = new TreeMap();
        for (String sVal : cfg.getSection("Item_Style_By_Amount")) {
            int amount = StringUtil.getInteger((String)sVal, (int)0);
            path = "Item_Style_By_Amount." + sVal + ".";
            ItemStack moneyItem = cfg.getItem((String)path);
            if (moneyItem.getType().isAir()) {
                plugin.error(this.id + "Currency: Invalid item for '" + sVal + "' money amount!");
                continue;
            }
            this.itemStyle.put(amount, moneyItem);
        }
        if (this.itemStyle.isEmpty()) {
            this.isDirectToBalance = true;
            plugin.warn(this.id + "Currency: No money items are defined, money will be given directly to player balance.");
        }
    }

    public AbstractCurrency(@NotNull String id, @NotNull String name, @NotNull String formatDisplay, @NotNull NumberFormat formatAmount, boolean isDirectToBalance, boolean isIntegerOnly, @NotNull Particle dropEffectParticle, @NotNull String dropEffectParticleData, @Nullable Sound pickupEffectSound, boolean isDeathPenaltyEnabled, boolean isDeathPenaltyDropItem, double deathPenaltyChance, double[] deathPenaltyAmount, @NotNull TreeMap<Integer, ItemStack> itemStyle) {
        this.id = id.toLowerCase();
        this.name = StringUtil.color((String)name);
        this.formatDisplay = StringUtil.color((String)formatDisplay);
        this.formatAmount = formatAmount;
        this.isDirectToBalance = isDirectToBalance;
        this.isIntegerOnly = isIntegerOnly;
        this.dropEffectParticle = dropEffectParticle;
        this.dropEffectParticleData = dropEffectParticleData;
        this.pickupEffectSound = pickupEffectSound;
        this.isDeathPenaltyEnabled = isDeathPenaltyEnabled;
        this.isDeathPenaltyDropItem = isDeathPenaltyDropItem;
        this.deathPenaltyChance = deathPenaltyChance;
        this.deathPenaltyAmount = deathPenaltyAmount;
        this.itemStyle = itemStyle;
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return str -> str.replace("%currency_name%", this.getName());
    }

    @Override
    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getFormatDisplay() {
        return this.formatDisplay;
    }

    @Override
    @NotNull
    public NumberFormat getFormatAmount() {
        return this.formatAmount;
    }

    @Override
    public boolean isDirectToBalance() {
        return this.isDirectToBalance;
    }

    @Override
    public boolean isIntegerOnly() {
        return this.isIntegerOnly;
    }

    @Override
    @Nullable
    public Particle getDropEffectParticle() {
        return this.dropEffectParticle;
    }

    @Override
    @NotNull
    public String getDropEffectParticleData() {
        return this.dropEffectParticleData;
    }

    @Override
    @Nullable
    public Sound getPickupEffectSound() {
        return this.pickupEffectSound;
    }

    @Override
    public boolean isDeathPenaltyEnabled() {
        return this.isDeathPenaltyEnabled;
    }

    @Override
    public boolean isDeathPenaltyDropItem() {
        return this.isDeathPenaltyDropItem;
    }

    @Override
    public double getDeathPenaltyChance() {
        return this.deathPenaltyChance;
    }

    @Override
    public double getDeathPenaltyAmountMin() {
        return this.deathPenaltyAmount[0];
    }

    @Override
    public double getDeathPenaltyAmountMax() {
        return this.deathPenaltyAmount[1];
    }

    @Override
    @NotNull
    public String format(double amount) {
        String sAmount = this.getFormatAmount().format(this.round(amount));
        String sDisplay = this.getFormatDisplay().replace("%amount%", sAmount);
        return (String)this.replacePlaceholders().apply(sDisplay);
    }

    @Override
    public double round(double amount) {
        return this.isIntegerOnly() ? (double)((int)amount) : NumberUtil.round((double)amount);
    }

    @Override
    public double getDeathPenaltyAmount() {
        return Rnd.getDouble((double)this.getDeathPenaltyAmountMin(), (double)this.getDeathPenaltyAmountMax());
    }

    @Override
    public void playDropParticle(@NotNull Location location) {
        if (this.getDropEffectParticle() == null) {
            return;
        }
        EffectUtil.playEffect((Location)location, (Particle)this.getDropEffectParticle(), (String)this.getDropEffectParticleData(), (double)0.35, (double)0.5, (double)0.35, (double)0.2f, (int)20);
    }

    @Override
    @NotNull
    public ItemStack getMoneyItem(double amount) {
        Map.Entry<Integer, ItemStack> e = this.itemStyle.floorEntry((int)Math.abs(amount));
        if (e == null) {
            return new ItemStack(Material.AIR);
        }
        return new ItemStack(e.getValue());
    }

    @Override
    @NotNull
    public ItemStack createMoney(double money, @Nullable Player owner, @Nullable IJob<?> job, @Nullable IMoneyObjective objective) {
        ItemMeta meta;
        if ((money = this.round(money)) == 0.0) {
            throw new IllegalArgumentException("Money amount can not be zero!");
        }
        ItemStack item = this.getMoneyItem(money);
        PDCUtil.setData((ItemStack)item, (NamespacedKey)Keys.MONEY_AMOUNT, (Object)money);
        PDCUtil.setData((ItemStack)item, (NamespacedKey)Keys.MONEY_CURRENCY, (Object)this.getId());
        PDCUtil.setData((ItemStack)item, (NamespacedKey)Keys.MONEY_ID, (Object)UUID.randomUUID().toString());
        if (job != null) {
            PDCUtil.setData((ItemStack)item, (NamespacedKey)Keys.MONEY_JOB, (Object)job.getId());
        }
        if (objective != null) {
            PDCUtil.setData((ItemStack)item, (NamespacedKey)Keys.MONEY_OBJECTIVE, (Object)objective.getType());
        }
        if (Config.MONEY_OWNER_PROTECTION_ENABLED && owner != null) {
            PDCUtil.setData((ItemStack)item, (NamespacedKey)Keys.MONEY_OWNER, (Object)owner.getName());
        }
        if ((meta = item.getItemMeta()) != null && meta.hasDisplayName()) {
            String name = StringUtil.color((String)meta.getDisplayName().replace("%money%", this.format(money)));
            meta.setDisplayName(name);
        }
        item.setItemMeta(meta);
        return item;
    }
}

