/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.api.booster;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.manager.IPlaceholder;
import su.nightexpress.moneyhunters.basic.api.booster.BoosterType;
import su.nightexpress.moneyhunters.basic.api.job.IJob;

public interface IBooster
extends IPlaceholder {
    @NotNull
    public String getId();

    @NotNull
    public Set<String> getJobs();

    default public boolean isApplicable(@NotNull IJob<?> job) {
        return this.getJobs().contains(job.getId()) || this.getJobs().contains("*");
    }

    public double getMoneyModifier();

    public double getExpModifier();

    default public double getMoneyPercent() {
        return this.getMoneyModifier() * 100.0 - 100.0;
    }

    default public double getExpPercent() {
        return this.getExpModifier() * 100.0 - 100.0;
    }

    default public boolean isActive() {
        return !this.isAwaiting() && !this.isExpired();
    }

    public boolean isExpired();

    public boolean isAwaiting();

    @NotNull
    public BoosterType getType();
}

