/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.moneyhunters.basic.api.booster;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.lang.EngineLang;
import su.nexmedia.engine.utils.NumberUtil;
import su.nightexpress.moneyhunters.basic.MoneyHunters;
import su.nightexpress.moneyhunters.basic.MoneyHuntersAPI;
import su.nightexpress.moneyhunters.basic.api.booster.IBooster;
import su.nightexpress.moneyhunters.basic.api.job.IJob;

public abstract class AbstractBooster
implements IBooster {
    protected MoneyHunters plugin = MoneyHuntersAPI.PLUGIN;
    protected String id;
    protected Set<String> jobs;
    protected double moneyModifier;
    protected double expModifier;

    public AbstractBooster(@NotNull String id, @NotNull Set<String> jobs, double moneyModifier, double expModifier) {
        this.id = id.toLowerCase();
        this.jobs = jobs.stream().map(String::toLowerCase).collect(Collectors.toCollection(HashSet::new));
        this.moneyModifier = moneyModifier;
        this.expModifier = expModifier;
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        Set<String> jobs = this.getJobs();
        if (jobs.contains("*")) {
            jobs.clear();
            jobs.addAll(MoneyHuntersAPI.getJobManager().getJobIds());
        }
        return str -> str.replace("%booster_id%", this.getId()).replace("%booster_type%", this.plugin.getLangManager().getEnum((Enum)this.getType())).replace("%booster_exp_modifier%", NumberUtil.format((double)this.getExpModifier())).replace("%booster_exp_modifier_percent%", NumberUtil.format((double)this.getExpPercent())).replace("%booster_money_modifier%", NumberUtil.format((double)this.getMoneyModifier())).replace("%booster_money_modifier_percent%", NumberUtil.format((double)this.getMoneyPercent())).replace("%booster_jobs%", jobs.stream().map(MoneyHuntersAPI::getJobById).filter(Objects::nonNull).map(IJob::getName).collect(Collectors.joining(", "))).replace("%booster_time_left%", this.plugin.getMessage(EngineLang.OTHER_INFINITY).getLocalized());
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Set<String> getJobs() {
        return this.jobs;
    }

    @Override
    public double getMoneyModifier() {
        return this.moneyModifier;
    }

    @Override
    public double getExpModifier() {
        return this.expModifier;
    }
}

