/*
 * Decompiled with CFR 0.152.
 */
package org.midnightas.midlib.plugin.customcommands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.badboy6767.midnightlibrary.Metrics;
import org.badboy6767.midnightlibrary.MidLib;
import org.badboy6767.midnightlibrary.MidnightCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomCommandsPlugin
extends JavaPlugin {
    public CustomCommandsPlugin instance = this;

    public void onEnable() {
        File configFile;
        MidLib library = (MidLib)Bukkit.getPluginManager().getPlugin("MidnightLibrary");
        if (!Bukkit.getServer().getOnlineMode()) {
            try {
                throw new ServerOfflineModeException();
            }
            catch (Exception e) {
                e.printStackTrace();
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
            }
        }
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException e) {
            System.out.println("Failed to update and send statistics about MidsCustomCommands.");
        }
        if (!new File(this.getDataFolder() + File.separator + "config.yml").exists() && !(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            configFile.getParentFile().mkdirs();
            this.copy(this.getResource("config.yml"), configFile);
        }
        this.saveConfig();
        for (final String s : this.getConfig().getStringList("commands")) {
            library.registerCommand(new MidnightCommand(){

                public Plugin getUser() {
                    return CustomCommandsPlugin.this.instance;
                }

                public String getName() {
                    return s;
                }

                public boolean onCall(CommandSender sender, String label, String[] args) {
                    if (sender.hasPermission(CustomCommandsPlugin.this.getConfig().getString("command." + s + ".permission"))) {
                        for (String cmd : CustomCommandsPlugin.this.getConfig().getStringList("command." + s + ".execute")) {
                            boolean isConsoleCommand;
                            String command = cmd.replace("%name", sender.getName()).replace("%x", String.valueOf(((Player)sender).getLocation().getBlockX())).replace("%y", String.valueOf(((Player)sender).getLocation().getBlockY())).replace("%z", String.valueOf(((Player)sender).getLocation().getBlockZ()));
                            boolean bl = isConsoleCommand = command.split(" ")[0].equalsIgnoreCase("sendmessage") || command.split(" ")[0].equalsIgnoreCase("log");
                            if (args.length == CustomCommandsPlugin.this.getConfig().getInt("command." + s + ".requiredArguments") || isConsoleCommand) {
                                int i = 1;
                                while (i < args.length + 1) {
                                    command = command.replace("%" + i, args[i - 1]);
                                    ++i;
                                }
                                if (command.split(" ")[0].equalsIgnoreCase("sendmessage")) {
                                    sender.sendMessage(command.substring(12).replace("&", "\u00a7"));
                                } else if (command.split(" ")[0].equalsIgnoreCase("log")) {
                                    Bukkit.getConsoleSender().sendMessage(command.substring(4).replace("&", "\u00a7"));
                                }
                                if (isConsoleCommand) continue;
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                                continue;
                            }
                            if (args.length > CustomCommandsPlugin.this.getConfig().getInt("command." + s + ".requiredArguments")) {
                                CustomCommandsPlugin.this.sendMessage(sender, CustomCommandsPlugin.this.getConfig().getString("message.invalidarguments.toomuch"));
                                continue;
                            }
                            if (args.length >= CustomCommandsPlugin.this.getConfig().getInt("command." + s + ".requiredArguments")) continue;
                            CustomCommandsPlugin.this.sendMessage(sender, CustomCommandsPlugin.this.getConfig().getString("message.invalidarguments.notenough"));
                        }
                    } else {
                        CustomCommandsPlugin.this.sendMessage(sender, CustomCommandsPlugin.this.getConfig().getString("message.nopermission"));
                    }
                    return true;
                }
            });
        }
    }

    private void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(CommandSender sender, String string) {
        sender.sendMessage(string.replace("&", "\u00a7"));
    }

    public class ServerOfflineModeException
    extends Exception {
        public ServerOfflineModeException() {
            super("Server is in offline/cracked mode!");
        }

        public ServerOfflineModeException(Throwable t) {
            super("Server is in offline/cracked mode!", t);
        }
    }
}

