/*
 * Decompiled with CFR 0.152.
 */
package org.obfuscatedmc.metrics.bukkit;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.bukkit.Bukkit;
import org.obfuscatedmc.metrics.DataFormat;
import org.obfuscatedmc.metrics.PacketData;

public class MetricService {
    private static NioEventLoopGroup worker;
    private static ChannelFuture future;

    public static void sendData(String ip, int port, final String pluginVersion) {
        worker = new NioEventLoopGroup();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(worker)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws Exception {
                socketChannel.pipeline().addLast(new ChannelInboundHandlerAdapter(){

                    @Override
                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        PacketData data = new PacketData(new DataFormat(Bukkit.getMotd(), Bukkit.getIp(), pluginVersion, Bukkit.getVersion()));
                        ByteBuf plain = Unpooled.buffer();
                        data.toBytes(plain);
                        ctx.writeAndFlush(plain);
                    }
                });
            }
        });
        try {
            future = bootstrap.connect(ip, port).sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void endData() {
        future.channel().closeFuture();
        worker.shutdownGracefully();
    }
}

