/*
 * Decompiled with CFR 0.152.
 */
package org.obfuscatedmc.metrics.bukkit;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.obfuscatedmc.metrics.DataFormat;
import org.obfuscatedmc.metrics.PacketData;

public class MetricPlugin
extends JavaPlugin {
    private static NioEventLoopGroup worker;
    private static ChannelFuture future;

    public void onEnable() {
        YamlConfiguration configuration = new YamlConfiguration();
        InputStream metricsYml = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("metrics.yml");
        try {
            configuration.load(metricsYml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        String serverIp = configuration.getString("server-ip");
        int port = configuration.getInt("server-port");
        worker = new NioEventLoopGroup();
        final String version = this.getDescription().getVersion();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(worker)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws Exception {
                socketChannel.pipeline().addLast(new ChannelInboundHandlerAdapter(){

                    @Override
                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        PacketData data = new PacketData(new DataFormat(Bukkit.getMotd(), Bukkit.getIp(), version, Bukkit.getVersion()));
                        ByteBuf plain = Unpooled.buffer();
                        data.toBytes(plain);
                        ctx.writeAndFlush(plain);
                    }
                });
            }
        });
        try {
            future = bootstrap.connect(serverIp, port).sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        future.channel().closeFuture();
        worker.shutdownGracefully();
    }
}

