/*
 * Decompiled with CFR 0.152.
 */
package org.obfuscatedmc.metrics;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import org.obfuscatedmc.metrics.BinaryConfig;
import org.obfuscatedmc.metrics.DataFormat;
import org.obfuscatedmc.metrics.FormatContainer;
import org.obfuscatedmc.metrics.PacketHandler;

public class Main {
    public static final File CURRENT_DIR = new File(System.getProperty("user.dir"));
    public static final File SAVE_FILE = new File(CURRENT_DIR, "data.dat");
    public static BinaryConfig<FormatContainer> CONFIGURATION;

    public static void main(String ... args) throws Exception {
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        CONFIGURATION = new BinaryConfig<FormatContainer>(SAVE_FILE, FormatContainer.class);
        NioEventLoopGroup parent = new NioEventLoopGroup();
        NioEventLoopGroup work = new NioEventLoopGroup();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).group(parent, work).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws Exception {
                socketChannel.pipeline().addLast(new PacketHandler());
            }
        });
        ChannelFuture future = bootstrap.bind(new InetSocketAddress(ip, port)).sync();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String line = bufferedReader.readLine();
        boolean run = true;
        while (run) {
            if (line == null) continue;
            if (line.equalsIgnoreCase("stop")) {
                System.out.println("Shutting down!");
                run = false;
            }
            if (line.equalsIgnoreCase("amount")) {
                FormatContainer container = CONFIGURATION.getWithoutException();
                int amount = 0;
                for (DataFormat format : container.saved) {
                    ++amount;
                }
                System.out.println("Amount: ".concat("" + amount));
            }
            if (line.equalsIgnoreCase("stop")) continue;
            line = bufferedReader.readLine();
        }
        System.exit(0);
    }
}

