/*
 * Decompiled with CFR 0.152.
 */
package org.obfuscatedmc.metrics;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class ByteBufUtils {
    public static String readUTF8(ByteBuf buf) throws IOException {
        int len = ByteBufUtils.readVarInt(buf);
        byte[] bytes = new byte[len];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeUTF8(ByteBuf buf, String value) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        if (bytes.length >= Short.MAX_VALUE) {
            throw new IOException("Attempt to write a string with a length greater than Short.MAX_VALUE to ByteBuf!");
        }
        ByteBufUtils.writeVarInt(buf, bytes.length);
        buf.writeBytes(bytes);
    }

    public static int readVarInt(ByteBuf buf) throws IOException {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            in = buf.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= 5) continue;
            throw new IOException("Attempt to read int bigger than allowed for a varint!");
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarInt(ByteBuf buf, int value) {
        do {
            byte part = (byte)(value & 0x7F);
            if ((value >>>= 7) != 0) {
                part = (byte)(part | 0x80);
            }
            buf.writeByte(part);
        } while (value != 0);
    }

    public static long readVarLong(ByteBuf buf) throws IOException {
        byte in;
        long out = 0L;
        int bytes = 0;
        do {
            in = buf.readByte();
            out |= (long)((in & 0x7F) << bytes++ * 7);
            if (bytes <= 10) continue;
            throw new IOException("Attempt to read long bigger than allowed for a varlong!");
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarLong(ByteBuf buf, long value) {
        do {
            byte part = (byte)(value & 0x7FL);
            if ((value >>>= 7) != 0L) {
                part = (byte)(part | 0x80);
            }
            buf.writeByte(part);
        } while (value != 0L);
    }
}

