/*
 * Decompiled with CFR 0.152.
 */
package org.obfuscatedmc.metrics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.obfuscatedmc.metrics.FormatContainer;

public class BinaryConfig<OBJECT> {
    private final File file;
    private final Class<OBJECT> objectClass;

    public BinaryConfig(File file, Class<OBJECT> objectClass) {
        this.file = file;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.saveWithoutException(new FormatContainer());
        }
        this.objectClass = objectClass;
    }

    public OBJECT get() throws Exception {
        FileInputStream fis = new FileInputStream(this.file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fis);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        fis.close();
        return (OBJECT)object;
    }

    public OBJECT getWithoutException() {
        try {
            return this.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void save(OBJECT object) throws Exception {
        FileOutputStream fos = new FileOutputStream(this.file);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(object);
        oos.close();
        fos.close();
    }

    public void saveWithoutException(OBJECT object) {
        try {
            this.save(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

