/*
 * Decompiled with CFR 0.152.
 */
package cn.hellp.touch.metamorph;

import io.papermc.paper.event.entity.EntityMoveEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private String prefix = "\u00a7e[MMPH]";
    private HashMap<String, EntityType> entityTypeHashMap = new HashMap();
    private HashMap<UUID, Entity> date = new HashMap();
    private FileConfiguration configuration;
    private Method spawnEntity;
    private boolean should = false;
    ArrayList<String> mobNames = new ArrayList();

    @ParametersAreNonnullByDefault
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Object object = sender;
        if (!(object instanceof Player)) {
            sender.sendMessage(this.prefix + "\u60a8\u53ea\u80fd\u5728\u6e38\u620f\u4e2d\u4f7f\u7528\u8be5\u547d\u4ee4");
            return true;
        }
        Player player = (Player)object;
        if (!player.hasPermission("metamorph.admin")) {
            sender.sendMessage(this.prefix + "\u60a8\u6ca1\u6709\u4f7f\u7528\u8be5\u6307\u4ee4\u7684\u6743\u9650.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.prefix + "\u6307\u4ee4\u5e2e\u52a9--------------------------\n1.metaMorph enable <mob> \u6253\u5f00\u6216\u5207\u6362\u60a8\u7684\u53d8\u5f62\n2.metaMorph disable \u5173\u95ed\u60a8\u7684\u53d8\u5f62\n3.metaMorph reload\u91cd\u8f7d\u63d2\u4ef6");
            return true;
        }
        switch (args[0]) {
            case "enable": {
                if (args.length < 2) {
                    sender.sendMessage(this.prefix + "\u60a8\u9700\u8981\u8f93\u5165\u60a8\u9700\u8981\u7684\u602a\u7269\u540d\u79f0.");
                    return true;
                }
                EntityType type = this.entityTypeHashMap.get(args[1]);
                if (type == null) {
                    sender.sendMessage(this.prefix + "\u6211\u6682\u65f6\u65e0\u6cd5\u627e\u5230\u8be5\u602a\u7269\uff0c\u8bf7\u60a8\u786e\u8ba4\u662f\u5426\u8f93\u5165\u6b63\u786e.");
                    return true;
                }
                try {
                    this.enable(type, player);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "disable": {
                this.disable(player);
                return true;
            }
            case "reload": {
                this.reloadConfig();
                this.configuration = this.getConfig();
                this.reload();
                sender.sendMessage("\u91cd\u8f7d\u63d2\u4ef6\u6210\u529f!");
                break;
            }
            default: {
                sender.sendMessage(this.prefix + "\u6682\u65f6\u6ca1\u6709\u8be5\u6307\u4ee4.");
            }
        }
        return true;
    }

    private void reload() {
        this.prefix = this.configuration.getString("prefix");
        for (Entity entity : this.date.values()) {
            entity.remove();
        }
        this.date.clear();
        this.initMobs();
    }

    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return List.of("enable", "disable");
        }
        if (args.length == 2) {
            return this.mobNames;
        }
        return null;
    }

    public void enable(EntityType type, Player player) throws InvocationTargetException, IllegalAccessException {
        World world = player.getWorld();
        Entity entity = this.should ? (Entity)this.spawnEntity.invoke((Object)world, player.getLocation(), type, false) : (Entity)this.spawnEntity.invoke((Object)world, player.getLocation(), type);
        this.date.put(player.getUniqueId(), entity);
    }

    public void disable(Player player) {
        if (this.date.containsKey(player.getUniqueId())) {
            this.date.get(player.getUniqueId()).remove();
            this.date.remove(player.getUniqueId());
            player.sendMessage(this.prefix + "\u5df2\u6210\u529f\u5173\u95ed!");
        } else {
            player.sendMessage(this.prefix + "\u60a8\u4f3c\u4e4e\u8fd8\u6ca1\u6709\u6253\u5f00\u53d8\u5f62\u5462.");
        }
    }

    public void onEnable() {
        this.should = Integer.parseInt(Bukkit.getMinecraftVersion().split("\\.")[1]) >= 17;
        this.getLogger().info(ChatColor.GOLD + "\u68c0\u6d4b\u5230\u7248\u672c:" + Bukkit.getMinecraftVersion());
        try {
            this.spawnEntity = this.should ? RegionAccessor.class.getDeclaredMethod("spawnEntity", Location.class, EntityType.class, Boolean.TYPE) : World.class.getDeclaredMethod("spawnEntity", Location.class, EntityType.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.getLogger().info(ChatColor.GOLD + "\u52a0\u8f7d\u5b8c\u6210!\u5236\u4f5cby Touch");
        this.saveDefaultConfig();
        this.configuration = this.getConfig();
        try {
            this.initCommand();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initMobs();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info(ChatColor.GOLD + "\u5b8c\u6210\u6ce8\u518c\u4e8b\u4ef6\u7cfb\u7edf.");
    }

    private void initCommand() throws Exception {
        Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
        c.setAccessible(true);
        String name = "metaMorph";
        PluginCommand command = (PluginCommand)c.newInstance(new Object[]{name, this});
        command.setName(name);
        command.setUsage("main command");
        command.setDescription("main command");
        command.setAliases(List.of("mmph"));
        command.setPermission("metamorph.admin");
        command.setTabCompleter((TabCompleter)this);
        command.setExecutor((CommandExecutor)this);
        Field f = SimplePluginManager.class.getDeclaredField("commandMap");
        f.setAccessible(true);
        CommandMap commandMap = (CommandMap)f.get(this.getServer().getPluginManager());
        commandMap.register(name, (Command)command);
    }

    private void initMobs() {
        this.entityTypeHashMap.clear();
        this.mobNames.clear();
        boolean enableBL = this.configuration.getBoolean("enableBlackList");
        for (EntityType type : EntityType.values()) {
            if (type == EntityType.UNKNOWN) continue;
            String name = type.getKey().asString();
            this.entityTypeHashMap.put(name, type);
        }
        if (enableBL) {
            List strings = this.configuration.getStringList("blackList");
            for (String s : strings) {
                this.entityTypeHashMap.remove(s);
            }
            this.getLogger().info(ChatColor.GOLD + "\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u5df2\u5f00\u542f.");
        }
        this.mobNames.addAll(this.entityTypeHashMap.keySet());
    }

    @EventHandler
    public void onDamage(EntityDeathEvent e) {
        if (e.getEntity().getKiller() != null && this.date.containsKey(e.getEntity().getKiller().getUniqueId())) {
            e.getEntity().setKiller(null);
        }
        if (this.date.containsValue(e.getEntity())) {
            for (UUID uuid : this.date.keySet()) {
                if (Bukkit.getPlayer((UUID)uuid) == null) {
                    this.date.remove(uuid);
                    continue;
                }
                if (this.date.get(uuid).getUniqueId() != e.getEntity().getUniqueId()) continue;
                this.date.remove(uuid);
                break;
            }
        }
    }

    @EventHandler
    public void onEntityMove(EntityMoveEvent e) {
        if (this.date.containsValue(e.getEntity()) && e.getTo().distance(e.getFrom()) > 0.0) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Entity xo;
        if (this.date.containsKey(e.getPlayer().getUniqueId()) && this.date.get(e.getPlayer().getUniqueId()) != null && (xo = this.date.get(e.getPlayer().getUniqueId())) instanceof LivingEntity) {
            ((LivingEntity)xo).getEyeLocation().setDirection(e.getPlayer().getEyeLocation().getDirection());
            xo.teleport(e.getTo());
        }
    }
}

