/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlElement;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlInvalidContentException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlNode;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class YamlWriter
implements AutoCloseable {
    @NotNull
    private final YamlNode root;
    private StringBuilder yamlBuilder;
    private String tab = "    ";
    private String footerComment = "";
    private String newLineSymbol = "\n";

    YamlWriter(@NotNull YamlNode root) {
        this.root = root;
    }

    YamlWriter(@NotNull YamlNode root, int tabSize) {
        this(root);
        StringBuilder tabBuilder = new StringBuilder();
        while (--tabSize >= 0) {
            tabBuilder.append(" ");
        }
        this.tab = tabBuilder.toString();
    }

    YamlWriter(@NotNull YamlNode root, int tabSize, @NotNull String footerComment) {
        this(root, tabSize);
        this.footerComment = footerComment;
    }

    YamlWriter(@NotNull YamlNode root, int tabSize, @NotNull String footerComment, @NotNull String newLineSymbol) {
        this(root, tabSize, footerComment);
        this.newLineSymbol = newLineSymbol;
    }

    @NotNull
    String process() throws YamlInvalidContentException {
        this.yamlBuilder = new StringBuilder();
        this.process(this.root, "");
        this.yamlBuilder.append(this.footerComment);
        return this.yamlBuilder.toString();
    }

    private boolean isRoot(@Nullable YamlNode node) {
        return node == this.root;
    }

    private void process(@NotNull YamlNode node, @NotNull String indentation) throws YamlInvalidContentException {
        String nextIndentation;
        if (!this.isRoot(node)) {
            nextIndentation = indentation + this.tab;
            this.yamlBuilder.append(node.getComment());
            this.yamlBuilder.append(indentation);
            this.yamlBuilder.append(this.quoteString(node.getName(), node.getQuoteChar(), indentation)).append(':');
        } else {
            nextIndentation = "";
        }
        if (node.isArray()) {
            this.writeArray(node, nextIndentation);
        } else if (node.isList()) {
            this.writeList(node, nextIndentation);
        } else {
            if (!node.hasValue() && !this.isRoot(node)) {
                this.yamlBuilder.append(this.newLineSymbol);
            }
            for (YamlElement child : node.getElements()) {
                if (child instanceof YamlValue) {
                    this.writeValue((YamlValue)child, nextIndentation);
                    this.yamlBuilder.append(this.newLineSymbol);
                    continue;
                }
                if (!(child instanceof YamlNode)) continue;
                this.process((YamlNode)child, nextIndentation);
                this.yamlBuilder.append(this.newLineSymbol);
            }
            this.yamlBuilder.deleteCharAt(this.yamlBuilder.length() - 1);
        }
    }

    @NotNull
    private String quoteString(@NotNull String val, @Nullable Character quoteChar, @NotNull String indentation) {
        if (quoteChar != null) {
            switch (quoteChar.charValue()) {
                case '\"': {
                    val = val.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"").replaceAll("\n", "\\n");
                    break;
                }
                case '\'': {
                    val = val.replaceAll("'", "''");
                }
            }
            val = quoteChar + val + quoteChar;
        }
        if (quoteChar == null || quoteChar.charValue() == '\'') {
            val = val.replaceAll("\n", "\n" + indentation + "\n" + indentation);
        }
        return val;
    }

    private void writeValue(@NotNull YamlValue value, @NotNull String indentation) {
        this.yamlBuilder.append(' ');
        this.yamlBuilder.append(this.quoteString(value.getValue(), value.getQuoteChar(), indentation));
        this.yamlBuilder.append(value.getComment());
    }

    private void writeArray(@NotNull YamlNode node, @NotNull String indentation) throws YamlInvalidContentException {
        List<YamlValue> values = node.getValues();
        if (values == null) {
            throw new YamlInvalidContentException("Node is marked as an array, but does not contain an array");
        }
        this.yamlBuilder.append(" [");
        String prefix = "";
        for (YamlValue value : values) {
            this.yamlBuilder.append(prefix);
            this.writeValue(value, indentation + this.tab);
            prefix = ",";
        }
        if (values.size() > 0) {
            this.yamlBuilder.append(' ');
        }
        this.yamlBuilder.append(']');
    }

    private void writeList(@NotNull YamlNode node, @NotNull String indentation) throws YamlInvalidContentException {
        String prefix = indentation + "-";
        List<YamlValue> values = node.getValues();
        if (values == null) {
            throw new YamlInvalidContentException("Node is marked as a list does not contain a list");
        }
        for (YamlValue value : values) {
            this.yamlBuilder.append(this.newLineSymbol);
            this.yamlBuilder.append(value.getPreComment());
            this.yamlBuilder.append(prefix);
            this.writeValue(value, indentation + this.tab);
        }
    }

    @Override
    public void close() {
        this.tab = null;
        this.footerComment = null;
        this.yamlBuilder = null;
        this.newLineSymbol = null;
    }
}

