/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlElement;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlValue
implements YamlElement {
    private static final Pattern MUST_BE_QUOTED = Pattern.compile("[^-.\\w]");
    private String value;
    private String comment = "";
    private String preComment = "";
    private Character quoteChar = null;

    public YamlValue(@NotNull String data) {
        this(data, null);
    }

    public YamlValue(@NotNull String data, @Nullable String comment) {
        this(data, comment, null);
    }

    public YamlValue(@NotNull String data, @Nullable String comment, @Nullable Character quoteChar) {
        if (comment != null) {
            this.comment = comment;
        }
        this.quoteChar = quoteChar;
        this.setValue(data);
    }

    public void setValue(@NotNull String value) {
        boolean needsQuote;
        this.value = value;
        if (this.quoteChar == null && (needsQuote = MUST_BE_QUOTED.matcher(value).find())) {
            this.quoteChar = value.contains("\"") && !value.contains("'") ? Character.valueOf('\'') : Character.valueOf('\"');
        }
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String getPreComment() {
        return this.preComment;
    }

    @Override
    public Character getQuoteChar() {
        return this.quoteChar;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setPreComment(String preComment) {
        this.preComment = preComment;
    }

    @Override
    public void setQuoteChar(Character quoteChar) {
        this.quoteChar = quoteChar;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlValue)) {
            return false;
        }
        YamlValue other = (YamlValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$preComment = this.getPreComment();
        String other$preComment = other.getPreComment();
        if (this$preComment == null ? other$preComment != null : !this$preComment.equals(other$preComment)) {
            return false;
        }
        Character this$quoteChar = this.getQuoteChar();
        Character other$quoteChar = other.getQuoteChar();
        return !(this$quoteChar == null ? other$quoteChar != null : !((Object)this$quoteChar).equals(other$quoteChar));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YamlValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $preComment = this.getPreComment();
        result = result * 59 + ($preComment == null ? 43 : $preComment.hashCode());
        Character $quoteChar = this.getQuoteChar();
        result = result * 59 + ($quoteChar == null ? 43 : ((Object)$quoteChar).hashCode());
        return result;
    }

    public String toString() {
        return "YamlValue(value=" + this.getValue() + ", comment=" + this.getComment() + ", preComment=" + this.getPreComment() + ", quoteChar=" + this.getQuoteChar() + ")";
    }
}

