/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlInvalidContentException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlNode;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlValue;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

class YamlReader
implements AutoCloseable {
    @Language(value="RegExp")
    private static final String QUOTE_PATTERN = "[\"'](?:(?<=\")[^\"\\\\]*(?s:\\\\.[^\"\\\\]*)*\"|(?<=')[^']*(?s:''[^']*)*')";
    @Language(value="RegExp")
    private static final String COMMENT_PATTERN = "(?<comment>\\s*#.*)?";
    @Language(value="RegExp")
    private static final String COMMENT_PATTERN_INLINE = "(?<comment>\\s+#.*)?";
    private static final Pattern KEY_PATTERN = Pattern.compile("^(?<key>[\"'](?:(?<=\")[^\"\\\\]*(?s:\\\\.[^\"\\\\]*)*\"|(?<=')[^']*(?s:''[^']*)*')|[^\\s:.'\"]+(\\.[^\\s:.'\"]+)*):");
    private static final Pattern QUOTED_VALUE_PATTERN = Pattern.compile("^(?<value>[\"'](?:(?<=\")[^\"\\\\]*(?s:\\\\.[^\"\\\\]*)*\"|(?<=')[^']*(?s:''[^']*)*'))(?<comment>\\s+#.*)?$");
    private static final Pattern VALUE_PATTERN = Pattern.compile("^(?<value>(.*?))(?<comment>\\s+#.*)?$");
    private final YamlNode root;
    private final String[] lines;
    private final Stack<Integer> indentations = new Stack();
    private final Stack<YamlNode> nodes = new Stack();
    private StringBuilder commentBuilder = new StringBuilder();
    private YamlNode lastNode;
    private int tabIndentationSize = 4;
    private int lineNr = 0;
    private boolean tabIndentationSizeSet = false;
    @NotNull
    private String footerComment = "";
    YamlIsMultiLineException mlException = new YamlIsMultiLineException();

    YamlReader(@NotNull String dataString) {
        this.lines = dataString.split("\r?\n");
        this.lastNode = this.root = new YamlNode("");
        this.indentations.push(0);
        this.nodes.push(this.root);
    }

    YamlReader(@NotNull String dataString, int tabSize) {
        this(dataString);
        this.tabIndentationSize = tabSize;
        this.tabIndentationSizeSet = true;
    }

    @NotNull
    YamlNode process() throws YamlInvalidContentException {
        String multiline = null;
        int mlStartLineNr = -1;
        for (String line : this.lines) {
            ++this.lineNr;
            if (multiline != null) {
                String trimmedLine = line.trim();
                trimmedLine = trimmedLine.length() == 0 ? "\n" : " " + trimmedLine;
                line = multiline + trimmedLine;
                multiline = null;
            }
            if (line.matches("[^\\\\]*(\\\\\\\\)*\\\\\\s*$")) {
                multiline = line.replaceAll("\\\\\\s*$", "");
                if (mlStartLineNr != -1) continue;
                mlStartLineNr = this.lineNr;
                continue;
            }
            try {
                this.processLine(line);
            }
            catch (YamlIsMultiLineException ignored) {
                if (mlStartLineNr == -1) {
                    mlStartLineNr = this.lineNr;
                }
                multiline = line;
            }
        }
        if (multiline != null) {
            throw new YamlInvalidContentException("Unexpected end of file! Quoted string value started (" + mlStartLineNr + "), but has no end!");
        }
        this.footerComment = this.commentBuilder.toString();
        return this.root;
    }

    private void processLine(@NotNull String line) throws YamlInvalidContentException, YamlIsMultiLineException {
        String trimmedLine = line.trim();
        if (line.matches("^\\s*#.*") || line.matches("^\\s*$") || trimmedLine.length() == 0) {
            this.commentBuilder.append(line);
            this.commentBuilder.append('\n');
            return;
        }
        int indentation = this.spacesTillFirstChar(line);
        while (indentation < this.indentations.peek()) {
            this.indentations.pop();
            this.nodes.pop();
        }
        if (indentation > this.indentations.peek()) {
            this.indentations.push(indentation);
            this.nodes.push(this.lastNode);
        }
        if (trimmedLine.startsWith("-")) {
            this.lastNode.addElement(this.yamlValueBuilder(trimmedLine.substring(1).trim()));
            this.lastNode.setList(true);
        } else {
            this.processNode(line, trimmedLine);
        }
    }

    private void processNode(@NotNull String line, @NotNull String trimmedLine) throws YamlInvalidContentException, YamlIsMultiLineException {
        Matcher matcher = KEY_PATTERN.matcher(trimmedLine);
        if (!matcher.find()) {
            throw new YamlInvalidContentException("The YAML content is invalid, line: " + this.lineNr);
        }
        String key = matcher.group("key");
        Character quoteChar = null;
        char qChar = key.charAt(0);
        if (qChar == '\'' || qChar == '\"') {
            quoteChar = Character.valueOf(qChar);
            key = key.substring(1, key.length() - 1);
        }
        this.lastNode = new YamlNode(key, null, this.commentBuilder.toString(), quoteChar);
        this.nodes.peek().addElement(this.lastNode);
        this.commentBuilder = new StringBuilder();
        String data = matcher.replaceFirst("").trim();
        if (data.length() > 0) {
            if (data.startsWith("[")) {
                this.lastNode.setArray(true);
                this.readArray(data);
            } else {
                this.lastNode.addElement(this.yamlValueBuilder(data));
            }
        }
    }

    private void readArray(@NotNull String data) throws YamlIsMultiLineException, YamlInvalidContentException {
        String[] values;
        if (!data.endsWith("]")) {
            throw this.mlException;
        }
        for (String value : values = data.substring(1, data.length() - 1).split(",((?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)(?=(?:[^']*'[^']*')*[^']*$))")) {
            if (value.equals("")) continue;
            this.lastNode.addElement(this.yamlValueBuilder(value.trim()));
        }
    }

    @NotNull
    private YamlValue yamlValueBuilder(@NotNull String data) throws YamlIsMultiLineException, YamlInvalidContentException {
        String comment = "";
        Character qChar = null;
        if (data.length() > 1) {
            char char1 = data.charAt(0);
            if (char1 == '\"' || char1 == '\'') {
                qChar = Character.valueOf(char1);
                Matcher matcher = QUOTED_VALUE_PATTERN.matcher(data);
                if (!matcher.matches()) {
                    throw this.mlException;
                }
                comment = matcher.group("comment");
                data = matcher.group("value");
                data = data.substring(1, data.length() - 1);
                switch (char1) {
                    case '\'': {
                        data = data.replaceAll("''", "'");
                        break;
                    }
                    case '\"': {
                        data = data.replace("\\n", "\n").replace("\\\"", "\"").replace("\\\\", "\\");
                    }
                }
            } else {
                Matcher matcher = VALUE_PATTERN.matcher(data);
                if (!matcher.matches()) {
                    throw new YamlInvalidContentException("Invalid value: " + data);
                }
                data = matcher.group("value");
                comment = matcher.group("comment");
            }
        }
        YamlValue value = new YamlValue(data, comment, qChar);
        if (this.commentBuilder.length() > 0) {
            value.setPreComment(this.commentBuilder.toString());
            this.commentBuilder = new StringBuilder();
        }
        return value;
    }

    int getTabSize() {
        return this.tabIndentationSize;
    }

    private int spacesTillFirstChar(String str) {
        int firstCharacter = 0;
        for (char character : str.toCharArray()) {
            if (character == ' ') {
                ++firstCharacter;
                continue;
            }
            if (character == '\t') {
                firstCharacter += this.tabIndentationSize;
                continue;
            }
            if (this.tabIndentationSizeSet || firstCharacter == 0) break;
            this.tabIndentationSizeSet = true;
            this.tabIndentationSize = firstCharacter;
            break;
        }
        return firstCharacter;
    }

    @Override
    public void close() {
        this.indentations.clear();
        this.nodes.clear();
    }

    @NotNull
    public String getFooterComment() {
        return this.footerComment;
    }

    private static class YamlIsMultiLineException
    extends Exception {
        private YamlIsMultiLineException() {
        }
    }
}

