/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlElement;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlInvalidContentException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlKeyNotFoundException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlValue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlNode
implements YamlElement,
Cloneable {
    private String name;
    private String comment = "";
    private boolean list = false;
    private boolean array = false;
    private Character quoteChar = null;
    private final List<YamlElement> elements = new LinkedList<YamlElement>();
    private final Map<String, YamlNode> nodeMap = new HashMap<String, YamlNode>();
    private int valueCount = 0;

    public YamlNode(String name) {
        this.name = name;
        if (name.contains(" ")) {
            this.quoteChar = Character.valueOf('\"');
        }
    }

    public YamlNode(@NotNull String name, @Nullable String data) throws YamlInvalidContentException {
        this(name);
        if (data != null && data.length() > 0) {
            this.addElement(new YamlValue(data));
        }
    }

    public YamlNode(@NotNull String name, @Nullable String data, @NotNull String comment) throws YamlInvalidContentException {
        this(name, data);
        this.comment = comment;
    }

    public YamlNode(@NotNull String name, @Nullable String data, @NotNull String comment, @Nullable Character quoteChar) throws YamlInvalidContentException {
        this(name, data, comment);
        if (this.quoteChar == null || quoteChar != null) {
            this.quoteChar = quoteChar;
        }
    }

    public YamlNode(@NotNull YamlNode node) {
        this(node.getName());
        this.setComment(node.getComment());
        this.setList(node.isList());
        this.setArray(node.isArray());
        this.setQuoteChar(node.getQuoteChar());
        this.elements.addAll(node.getElements());
        this.nodeMap.putAll(node.getNodeMap());
        this.valueCount = node.valueCount;
    }

    public void addElement(@NotNull YamlElement element) throws YamlInvalidContentException {
        if (element instanceof YamlNode) {
            if (this.valueCount > 1 || this.list || this.array) {
                throw new YamlInvalidContentException("It is not possible to add a sub key to a value list!");
            }
            this.nodeMap.put(((YamlNode)element).getName(), (YamlNode)element);
        } else {
            if (this.valueCount == 0 && this.elements.size() > 0) {
                ++this.valueCount;
                this.elements.add(0, element);
                return;
            }
            if (this.valueCount != this.elements.size()) {
                throw new YamlInvalidContentException("It is not possible to add a sub key to a value list!");
            }
            ++this.valueCount;
            if (this.valueCount > 1) {
                this.list = true;
            }
        }
        this.elements.add(element);
    }

    public void addNode(@NotNull YamlNode node) throws YamlInvalidContentException {
        if (this.valueCount > 1 || this.list || this.array) {
            throw new YamlInvalidContentException("It is not possible to add a sub key to a value list!");
        }
        this.nodeMap.put(node.getName(), node);
        float best = -1.0f;
        int i = 0;
        int bestId = -1;
        for (YamlElement element : this.elements) {
            if (element instanceof YamlNode) {
                if (((YamlNode)element).getName().startsWith(node.getName())) {
                    bestId = i;
                    break;
                }
                if (!node.getName().startsWith(((YamlNode)element).getName())) continue;
                bestId = i + 1;
                break;
            }
            ++i;
        }
        if (bestId >= 0 && bestId < this.elements.size()) {
            this.elements.add(bestId, node);
        } else {
            this.elements.add(node);
        }
    }

    public void removeElement(@NotNull YamlElement element) {
        if (element instanceof YamlNode) {
            this.nodeMap.remove(((YamlNode)element).getName());
        } else {
            --this.valueCount;
        }
        this.elements.remove(element);
    }

    public boolean hasValue() {
        return this.valueCount > 0;
    }

    public boolean isValue() {
        return this.valueCount == 1;
    }

    public boolean isValueList() {
        return this.valueCount == this.elements.size();
    }

    public YamlNode getSubNode(@NotNull String subKey) {
        return this.nodeMap.get(subKey);
    }

    public boolean contains(@NotNull String subKey) {
        return this.nodeMap.containsKey(subKey);
    }

    @Nullable
    public YamlValue getValue() {
        if (this.isValue()) {
            return (YamlValue)this.elements.get(0);
        }
        return null;
    }

    @NotNull
    public YamlValue getValueE() throws YamlKeyNotFoundException {
        if (this.isValue()) {
            return (YamlValue)this.elements.get(0);
        }
        throw new YamlKeyNotFoundException("The given key dose not contain any data");
    }

    @Nullable
    public List<String> getValuesAsStringList() {
        if (this.isValueList()) {
            ArrayList<String> values = new ArrayList<String>(this.elements.size());
            for (YamlElement element : this.elements) {
                values.add(((YamlValue)element).getValue());
            }
            return values;
        }
        return null;
    }

    @Nullable
    public List<YamlValue> getValues() {
        if (this.isValueList()) {
            ArrayList<YamlValue> values = new ArrayList<YamlValue>(this.elements.size());
            for (YamlElement element : this.elements) {
                values.add((YamlValue)element);
            }
            return values;
        }
        return null;
    }

    @NotNull
    public List<YamlValue> getValuesE() throws YamlKeyNotFoundException {
        if (this.isValueList()) {
            ArrayList<YamlValue> values = new ArrayList<YamlValue>(this.elements.size());
            for (YamlElement element : this.elements) {
                values.add((YamlValue)element);
            }
            return values;
        }
        throw new YamlKeyNotFoundException("The given key dose not contain a list of values");
    }

    private void removeAllValues() {
        this.valueCount = 0;
        this.elements.removeIf(element -> element instanceof YamlValue);
    }

    private void addNewValue(@NotNull Object value) throws YamlInvalidContentException {
        this.addElement(new YamlValue(value instanceof String ? (String)value : value.toString()));
    }

    public void set(@Nullable Object value) throws YamlInvalidContentException {
        if (value == null) {
            this.list = false;
            this.removeAllValues();
        } else {
            if (value.getClass().isArray()) {
                LinkedList<Object> list = new LinkedList<Object>();
                int len = Array.getLength(value);
                for (int i = 0; i < len; ++i) {
                    list.add(Array.get(value, i));
                }
                value = list;
                this.array = true;
            }
            if (value instanceof Iterable) {
                this.removeAllValues();
                this.list = true;
                this.elements.clear();
                for (Object val : (Iterable)value) {
                    this.addElement(new YamlValue(val instanceof String ? (String)val : val.toString()));
                }
                if (value.getClass().isArray()) {
                    this.array = true;
                }
            } else if (this.valueCount > 1) {
                this.removeAllValues();
            } else if (this.valueCount == 0) {
                this.addNewValue(value);
            } else if (this.isValue()) {
                this.getValue().setValue(value instanceof String ? (String)((Object)value) : ((Object)value).toString());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isArray() {
        return this.array;
    }

    @Override
    public Character getQuoteChar() {
        return this.quoteChar;
    }

    public List<YamlElement> getElements() {
        return this.elements;
    }

    public Map<String, YamlNode> getNodeMap() {
        return this.nodeMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    @Override
    public void setQuoteChar(Character quoteChar) {
        this.quoteChar = quoteChar;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlNode)) {
            return false;
        }
        YamlNode other = (YamlNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        if (this.isList() != other.isList()) {
            return false;
        }
        if (this.isArray() != other.isArray()) {
            return false;
        }
        Character this$quoteChar = this.getQuoteChar();
        Character other$quoteChar = other.getQuoteChar();
        if (this$quoteChar == null ? other$quoteChar != null : !((Object)this$quoteChar).equals(other$quoteChar)) {
            return false;
        }
        List<YamlElement> this$elements = this.getElements();
        List<YamlElement> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        Map<String, YamlNode> this$nodeMap = this.getNodeMap();
        Map<String, YamlNode> other$nodeMap = other.getNodeMap();
        if (this$nodeMap == null ? other$nodeMap != null : !((Object)this$nodeMap).equals(other$nodeMap)) {
            return false;
        }
        return this.valueCount == other.valueCount;
    }

    protected boolean canEqual(Object other) {
        return other instanceof YamlNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        result = result * 59 + (this.isList() ? 79 : 97);
        result = result * 59 + (this.isArray() ? 79 : 97);
        Character $quoteChar = this.getQuoteChar();
        result = result * 59 + ($quoteChar == null ? 43 : ((Object)$quoteChar).hashCode());
        List<YamlElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        Map<String, YamlNode> $nodeMap = this.getNodeMap();
        result = result * 59 + ($nodeMap == null ? 43 : ((Object)$nodeMap).hashCode());
        result = result * 59 + this.valueCount;
        return result;
    }

    public String toString() {
        return "YamlNode(name=" + this.getName() + ", comment=" + this.getComment() + ", list=" + this.isList() + ", array=" + this.isArray() + ", quoteChar=" + this.getQuoteChar() + ", elements=" + this.getElements() + ", nodeMap=" + this.getNodeMap() + ", valueCount=" + this.valueCount + ")";
    }
}

