/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlInvalidContentException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlKeyNotFoundException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface YamlGetter {
    public boolean isSet(@NotNull String var1);

    @Nullable
    public YamlValue getValue(@NotNull String var1);

    default public byte getByte(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        return Byte.parseByte(this.getString(key));
    }

    default public byte getByte(@NotNull String key, byte defaultValue) throws NumberFormatException {
        return Byte.parseByte(this.getString(key, "" + defaultValue));
    }

    @NotNull
    default public List<Byte> getByteList(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        List<String> stringValues = this.getStringList(key);
        ArrayList<Byte> values = new ArrayList<Byte>(stringValues.size());
        for (String value : stringValues) {
            values.add(Byte.parseByte(value));
        }
        return values;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Byte> getByteList(@NotNull String key, @Nullable List<Byte> defaultValue) throws NumberFormatException {
        List<String> stringValues = this.getStringList(key, null);
        if (stringValues == null) {
            return defaultValue;
        }
        ArrayList<Byte> values = new ArrayList<Byte>(stringValues.size());
        for (String value : stringValues) {
            values.add(Byte.parseByte(value));
        }
        return values;
    }

    default public short getShort(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        return Short.parseShort(this.getString(key));
    }

    default public short getShort(@NotNull String key, short defaultValue) throws NumberFormatException {
        return Short.parseShort(this.getString(key, "" + defaultValue));
    }

    @NotNull
    default public List<Short> getShortList(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        List<String> stringValues = this.getStringList(key);
        ArrayList<Short> values = new ArrayList<Short>(stringValues.size());
        for (String value : stringValues) {
            values.add(Short.parseShort(value));
        }
        return values;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Short> getShortList(@NotNull String key, @Nullable List<Short> defaultValue) throws NumberFormatException {
        List<String> stringValues = this.getStringList(key, null);
        if (stringValues == null) {
            return defaultValue;
        }
        ArrayList<Short> values = new ArrayList<Short>(stringValues.size());
        for (String value : stringValues) {
            values.add(Short.parseShort(value));
        }
        return values;
    }

    default public int getInt(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getString(key));
    }

    default public int getInt(@NotNull String key, int defaultValue) throws NumberFormatException {
        return Integer.parseInt(this.getString(key, "" + defaultValue));
    }

    @NotNull
    default public List<Integer> getIntList(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        List<String> stringValues = this.getStringList(key);
        ArrayList<Integer> values = new ArrayList<Integer>(stringValues.size());
        for (String value : stringValues) {
            values.add(Integer.parseInt(value));
        }
        return values;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Integer> getIntList(@NotNull String key, @Nullable List<Integer> defaultValue) throws NumberFormatException {
        List<String> stringValues = this.getStringList(key, null);
        if (stringValues == null) {
            return defaultValue;
        }
        ArrayList<Integer> values = new ArrayList<Integer>(stringValues.size());
        for (String value : stringValues) {
            values.add(Integer.parseInt(value));
        }
        return values;
    }

    default public long getLong(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        return Long.parseLong(this.getString(key));
    }

    default public long getLong(@NotNull String key, long defaultValue) throws NumberFormatException {
        return Long.parseLong(this.getString(key, "" + defaultValue));
    }

    @NotNull
    default public List<Long> getLongList(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        List<String> stringValues = this.getStringList(key);
        ArrayList<Long> values = new ArrayList<Long>(stringValues.size());
        for (String value : stringValues) {
            values.add(Long.parseLong(value));
        }
        return values;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Long> getLongList(@NotNull String key, @Nullable List<Long> defaultValue) throws NumberFormatException {
        List<String> stringValues = this.getStringList(key, null);
        if (stringValues == null) {
            return defaultValue;
        }
        ArrayList<Long> values = new ArrayList<Long>(stringValues.size());
        for (String value : stringValues) {
            values.add(Long.parseLong(value));
        }
        return values;
    }

    default public float getFloat(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        return Float.parseFloat(this.getString(key));
    }

    default public float getFloat(@NotNull String key, float defaultValue) throws NumberFormatException {
        return Float.parseFloat(this.getString(key, "" + defaultValue));
    }

    @NotNull
    default public List<Float> getFloatList(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        List<String> stringValues = this.getStringList(key);
        ArrayList<Float> values = new ArrayList<Float>(stringValues.size());
        for (String value : stringValues) {
            values.add(Float.valueOf(Float.parseFloat(value)));
        }
        return values;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Float> getFloatList(@NotNull String key, @Nullable List<Float> defaultValue) throws NumberFormatException {
        List<String> stringValues = this.getStringList(key, null);
        if (stringValues == null) {
            return defaultValue;
        }
        ArrayList<Float> values = new ArrayList<Float>(stringValues.size());
        for (String value : stringValues) {
            values.add(Float.valueOf(Float.parseFloat(value)));
        }
        return values;
    }

    default public double getDouble(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        return Double.parseDouble(this.getString(key));
    }

    default public double getDouble(@NotNull String key, double defaultValue) throws NumberFormatException {
        return Double.parseDouble(this.getString(key, "" + defaultValue));
    }

    @NotNull
    default public List<Double> getDoubleList(@NotNull String key) throws YamlKeyNotFoundException, NumberFormatException {
        List<String> stringValues = this.getStringList(key);
        ArrayList<Double> values = new ArrayList<Double>(stringValues.size());
        for (String value : stringValues) {
            values.add(Double.parseDouble(value));
        }
        return values;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Double> getDoubleList(@NotNull String key, @Nullable List<Double> defaultValue) throws NumberFormatException {
        List<String> stringValues = this.getStringList(key, null);
        if (stringValues == null) {
            return defaultValue;
        }
        ArrayList<Double> values = new ArrayList<Double>(stringValues.size());
        for (String value : stringValues) {
            values.add(Double.parseDouble(value));
        }
        return values;
    }

    default public boolean getBoolean(@NotNull String key) throws YamlKeyNotFoundException {
        return Boolean.parseBoolean(this.getString(key));
    }

    default public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getString(key, "" + defaultValue));
    }

    @NotNull
    default public List<Boolean> getBooleanList(@NotNull String key) throws YamlKeyNotFoundException {
        List<String> stringValues = this.getStringList(key);
        ArrayList<Boolean> values = new ArrayList<Boolean>(stringValues.size());
        for (String value : stringValues) {
            values.add(Boolean.parseBoolean(value));
        }
        return values;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Boolean> getBooleanList(@NotNull String key, @Nullable List<Boolean> defaultValue) {
        List<String> stringValues = this.getStringList(key, null);
        if (stringValues == null) {
            return defaultValue;
        }
        ArrayList<Boolean> values = new ArrayList<Boolean>(stringValues.size());
        for (String value : stringValues) {
            values.add(Boolean.parseBoolean(value));
        }
        return values;
    }

    default public char getChar(@NotNull String key) throws YamlKeyNotFoundException, YamlInvalidContentException {
        String value = this.getString(key);
        if (value.length() == 1) {
            return value.charAt(0);
        }
        throw new YamlInvalidContentException("The value you searched for could not be converted to a character");
    }

    default public char getChar(@NotNull String key, char defaultValue) throws YamlInvalidContentException {
        String value = this.getString(key, "" + defaultValue);
        if (value.length() == 1) {
            return value.charAt(0);
        }
        throw new YamlInvalidContentException("The value you searched for could not be converted to a character");
    }

    @NotNull
    public static List<Character> getCharListFromStringList(@NotNull List<String> stringValues) throws YamlInvalidContentException {
        ArrayList<Character> values = new ArrayList<Character>(stringValues.size());
        for (String value : stringValues) {
            if (value.length() == 1) {
                values.add(Character.valueOf(value.charAt(0)));
                continue;
            }
            values.clear();
            throw new YamlInvalidContentException("The value you searched for could not be converted to a character");
        }
        return values;
    }

    @NotNull
    default public List<Character> getCharList(@NotNull String key) throws YamlKeyNotFoundException, YamlInvalidContentException {
        return YamlGetter.getCharListFromStringList(this.getStringList(key));
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public List<Character> getCharList(@NotNull String key, @Nullable List<Character> defaultValue) throws YamlInvalidContentException {
        List<String> stringValues = this.getStringList(key, null);
        if (stringValues == null) {
            return defaultValue;
        }
        return YamlGetter.getCharListFromStringList(stringValues);
    }

    @NotNull
    default public String getString(@NotNull String key) throws YamlKeyNotFoundException {
        YamlValue value = this.getValue(key);
        if (value != null) {
            return value.getValue();
        }
        throw new YamlKeyNotFoundException("The key you wanted to retrieve (\"" + key + "\") could not be found in the YAML object");
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public String getString(@NotNull String key, @Nullable String defaultValue) {
        YamlValue value = this.getValue(key);
        if (value != null) {
            return value.getValue();
        }
        return defaultValue;
    }

    @NotNull
    default public List<String> getStringList(@NotNull String key) throws YamlKeyNotFoundException {
        List<String> list = this.getStringList(key, null);
        if (list != null) {
            return list;
        }
        throw new YamlKeyNotFoundException("The key you wanted to retrieve (\"" + key + "\") could not be found in the YAML object");
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public List<String> getStringList(@NotNull String var1, @Nullable List<String> var2);
}

