/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlElement;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlGetter;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlInvalidContentException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlKeyNotFoundException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlNode;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlReader;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlValue;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YAML
implements AutoCloseable,
YamlGetter {
    private static final int BOM_SIZE = 4;
    private final Map<String, YamlNode> nodeMap = new HashMap<String, YamlNode>();
    private final Map<String, YamlNode> valueNodeMap = new HashMap<String, YamlNode>();
    private String encoding = "UTF-8";
    private String footer;
    private YamlNode root = null;
    private int tabSize = 4;

    private YAML() {
    }

    public YAML(@NotNull File file) throws IOException, YamlInvalidContentException {
        this.load(file);
    }

    public YAML(@NotNull InputStream stream) throws IOException, YamlInvalidContentException {
        this.load(stream);
    }

    public YAML(@NotNull String dataString) throws YamlInvalidContentException {
        this.load(dataString);
    }

    public void load(@NotNull File file) throws IOException, YamlInvalidContentException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.load(inputStream);
        }
    }

    public void load(@NotNull InputStream stream) throws IOException, YamlInvalidContentException {
        byte[] bom = new byte[4];
        this.encoding = "UTF-8";
        try (PushbackInputStream pushbackInputStream = new PushbackInputStream(stream, 4);){
            int unread;
            int count = unread = pushbackInputStream.read(bom, 0, 4);
            if (count >= 3 && bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                this.encoding = "UTF-8";
                unread = count - 3;
            } else if (count >= 2 && bom[0] == -2 && bom[1] == -1) {
                this.encoding = "UTF-16BE";
                unread = count - 2;
            } else if (count >= 2 && bom[0] == -1 && bom[1] == -2) {
                if (count >= 4 && bom[2] == 0 && bom[3] == 0) {
                    this.encoding = "UTF-32LE";
                    unread = count - 4;
                } else {
                    this.encoding = "UTF-16LE";
                    unread = count - 2;
                }
            } else if (count >= 4 && bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                this.encoding = "UTF-32BE";
                unread = count - 4;
            }
            if (unread > 0) {
                pushbackInputStream.unread(bom, count - unread, unread);
            } else if (unread < -1) {
                pushbackInputStream.unread(bom, 0, 0);
            }
            try (Scanner scanner = new Scanner((InputStream)pushbackInputStream, this.encoding);){
                this.load(scanner.useDelimiter("\\Z").next());
            }
        }
    }

    public void load(@NotNull String dataString) throws YamlInvalidContentException {
        try (YamlReader reader = new YamlReader(dataString);){
            this.load(reader.process());
            this.footer = reader.getFooterComment();
            this.tabSize = reader.getTabSize();
        }
        catch (YamlInvalidContentException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(@NotNull YamlNode root) {
        this.clear();
        this.root = root;
        this.load("", root);
    }

    public void loadNewRoot(@NotNull YamlNode root) {
        this.clear();
        this.root = new YamlNode(root);
        this.root.setName("");
        this.load("", this.root);
    }

    private void load(@NotNull String parentKey, @NotNull YamlNode node) {
        if (parentKey.length() > 0) {
            parentKey = parentKey + '.';
        }
        parentKey = parentKey + node.getName();
        this.nodeMap.put(parentKey, node);
        if (node.hasValue() || node.isArray()) {
            this.valueNodeMap.put(parentKey, node);
        }
        if (!node.isList()) {
            for (YamlElement child : node.getElements()) {
                if (!(child instanceof YamlNode)) continue;
                this.load(parentKey, (YamlNode)child);
            }
        }
    }

    public void save(@NotNull File file) throws FileNotFoundException {
        try (FileOutputStream stream = new FileOutputStream(file);
             PrintStream out = new PrintStream((OutputStream)stream, true, this.encoding);){
            out.append(this.saveAsString());
            out.flush();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public OutputStream saveAsStream() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(stream);){
            out.writeBytes(this.saveAsString());
            out.flush();
        }
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String saveAsString() {
        try (YamlWriter writer = new YamlWriter(this.root, this.tabSize, this.footer);){
            String string = writer.process();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void clear() {
        this.root = null;
        this.nodeMap.clear();
        this.valueNodeMap.clear();
        this.footer = "";
    }

    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public boolean isSet(@NotNull String key) {
        return this.valueNodeMap.containsKey(key);
    }

    @NotNull
    public Set<String> getKeys() {
        return new HashSet<String>(this.valueNodeMap.keySet());
    }

    @NotNull
    public Collection<String> getKeysFiltered(@Language(value="RegExp") String filterRegex) {
        return this.getKeys().stream().filter(key -> key.matches(filterRegex)).collect(Collectors.toList());
    }

    @NotNull
    public Set<String> getKeys(boolean subKeys) {
        if (subKeys) {
            return this.getKeys();
        }
        HashSet<String> returnedKeys = new HashSet<String>();
        for (String key : this.getKeys()) {
            if (key.indexOf(46) >= 0) continue;
            returnedKeys.add(key);
        }
        return returnedKeys;
    }

    public Set<String> getNodeKeys() {
        return new HashSet<String>(this.nodeMap.keySet());
    }

    public Set<String> getNodeKeys(boolean subKeys) {
        if (subKeys) {
            return this.getNodeKeys();
        }
        HashSet<String> returnedKeys = new HashSet<String>();
        for (String key : this.getNodeKeys()) {
            if (key.indexOf(46) >= 0) continue;
            returnedKeys.add(key);
        }
        return returnedKeys;
    }

    @Override
    @Nullable
    public YamlValue getValue(@NotNull String key) {
        YamlNode node = this.valueNodeMap.get(key);
        if (node != null) {
            return node.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getStringList(@NotNull String key, @Nullable List<String> defaultValue) {
        List<String> list;
        YamlNode node = this.valueNodeMap.get(key);
        if (node != null && (list = node.getValuesAsStringList()) != null) {
            return list;
        }
        return defaultValue;
    }

    @NotNull
    public YAML getSection(@NotNull String key) throws YamlKeyNotFoundException {
        YamlNode node = this.nodeMap.get(key);
        if (node == null) {
            throw new YamlKeyNotFoundException("Key " + key + " not found");
        }
        YAML section = new YAML();
        section.loadNewRoot(node);
        return section;
    }

    public boolean isListE(@NotNull String key) throws YamlKeyNotFoundException {
        YamlNode node = this.nodeMap.get(key);
        if (node == null) {
            throw new YamlKeyNotFoundException("Key " + key + " not found");
        }
        return node.isList();
    }

    public boolean isList(@NotNull String key) {
        YamlNode node = this.nodeMap.get(key);
        return node != null && node.isList();
    }

    public void set(@NotNull String key, @Nullable Object value) {
        try {
            if (this.nodeMap.containsKey(key)) {
                this.nodeMap.get(key).set(value);
            } else {
                String[] keys = key.split("\\.");
                YamlNode node = this.root;
                StringBuilder keyBuilder = new StringBuilder();
                for (String sKey : keys) {
                    if (keyBuilder.length() > 0) {
                        keyBuilder.append('.');
                    }
                    keyBuilder.append(sKey);
                    YamlNode nNode = node.getSubNode(sKey);
                    if (nNode == null) {
                        nNode = new YamlNode(sKey);
                        node.addNode(nNode);
                        this.nodeMap.put(keyBuilder.toString(), nNode);
                    }
                    node = nNode;
                }
                node.set(value);
                this.valueNodeMap.put(keyBuilder.toString(), node);
            }
        }
        catch (YamlInvalidContentException e) {
            e.printStackTrace();
        }
    }
}

