/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Utils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.YamlFileUpdateMethod;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YAML;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YamlGetter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="1.0.40")
public class YamlFileManager {
    protected static final String KEY_YAML_VERSION = "Version";
    protected static final String YAML_FILE_EXT = ".yml";
    protected final Logger logger;
    protected final String inJarPrefix;
    protected final String path;
    @Deprecated
    protected final int expectedVersion;
    @Deprecated
    protected final int upgradeThreshold;
    protected final Version versionExpected;
    protected final File baseDir;
    protected boolean extracted = false;
    protected String file;
    protected YAML yaml;
    protected File yamlFile;
    @Deprecated
    protected YamlFileUpdateMethod updateMode = null;
    protected String fileDescription = "config";
    protected String fileDescriptionCapitalized = "Config";

    YamlFileManager(@NotNull Logger logger, @NotNull File baseDir, int version, int upgradeThreshold, @Nullable String path, @Nullable String file, @NotNull String inJarPrefix, @Nullable YAML oldConfig) {
        this(logger, baseDir, new Version(version), new Version(upgradeThreshold), path, file, inJarPrefix, oldConfig);
    }

    YamlFileManager(@NotNull Logger logger, @NotNull File baseDir, Version version, Version upgradeThreshold, @Nullable String path, @Nullable String file, @NotNull String inJarPrefix, @Nullable YAML oldConfig) {
        this.path = path;
        this.file = file;
        this.logger = logger;
        this.inJarPrefix = inJarPrefix;
        this.versionExpected = version;
        this.expectedVersion = version.getMajor();
        this.upgradeThreshold = upgradeThreshold.getMajor();
        File file2 = this.baseDir = path != null && !path.isEmpty() ? new File(baseDir, path) : baseDir;
        if (file != null) {
            this.yamlFile = new File(this.baseDir, file);
        }
        if (oldConfig != null) {
            this.yaml = oldConfig;
        }
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Nullable
    protected YamlFileUpdateMethod getYamlUpdateMode() {
        return this.updateMode;
    }

    public void setFileDescription(@NotNull String description) {
        this.fileDescription = description;
        this.fileDescriptionCapitalized = description.substring(0, 1).toUpperCase() + description.substring(1);
    }

    public boolean isLoaded() {
        return this.yaml != null;
    }

    @Deprecated
    public int getVersion() {
        return this.yaml.getInt(KEY_YAML_VERSION, -1);
    }

    public Version version() throws Version.InvalidVersionStringException {
        return new Version(this.yaml.getString(KEY_YAML_VERSION, "0"));
    }

    public Version getExpectedVersion() {
        return this.versionExpected;
    }

    protected void doUpgrade(@NotNull YamlFileManager oldYamlFile) {
        this.doUpgrade(oldYamlFile, new HashMap<String, String>());
    }

    protected void doUpgrade(@NotNull YamlFileManager oldYamlFile, @NotNull Map<String, String> configKeyReMappings) {
        this.doUpgrade(oldYamlFile, configKeyReMappings, new ArrayList<String>());
    }

    protected void doUpgrade(@NotNull YamlFileManager oldYamlFile, @NotNull Map<String, String> configKeyReMappings, @NotNull Collection<String> keysToKeep) {
        ArrayList<String> keysToProcess = new ArrayList<String>(this.yaml.getKeys());
        keysToProcess.addAll(keysToKeep);
        for (String key : keysToProcess) {
            String oldKey;
            if (key.equals(KEY_YAML_VERSION) || !oldYamlFile.yaml.isSet(oldKey = configKeyReMappings.getOrDefault(key, key))) continue;
            if (oldYamlFile.yaml.isList(oldKey)) {
                this.yaml.set(key, oldYamlFile.yaml.getStringList(oldKey, new LinkedList<String>()));
                continue;
            }
            this.yaml.set(key, oldYamlFile.yaml.getString(oldKey, null));
        }
    }

    protected void doUpdate() {
        this.logger.info("No " + this.getFileDescription() + " update code implemented! Just updating version!");
    }

    protected boolean newConfigCreated() {
        return false;
    }

    protected void loaded() {
        this.logger.info((Object)((Object)ConsoleColor.GREEN) + this.getFileDescriptionCapitalized() + " file successfully loaded." + (Object)((Object)ConsoleColor.RESET));
    }

    @Nullable
    public YAML getYaml() {
        return this.yaml;
    }

    @NotNull
    public YAML getYamlE() throws YamlFileNotInitializedException {
        if (this.yaml == null) {
            throw new YamlFileNotInitializedException();
        }
        return this.yaml;
    }

    @NotNull
    public YamlGetter getYamlReadOnly() throws YamlFileNotInitializedException {
        return this.getYamlE();
    }

    public void save() throws FileNotFoundException {
        this.yaml.save(this.yamlFile);
    }

    protected void load() {
        try {
            if (!this.yamlFile.exists() || this.yamlFile.length() == 0L) {
                this.extractFile();
            }
            this.yaml = new YAML(this.yamlFile);
            this.validate();
            if (this.extracted && this.newConfigCreated()) {
                this.save();
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to load " + this.getFileDescription() + " file!");
            e.printStackTrace();
        }
    }

    protected void validate() {
        if (this.getExpectedVersion().newerThan(this.version())) {
            if (this.extracted) {
                this.logger.warning((Object)((Object)ConsoleColor.YELLOW) + "The " + this.getFileDescription() + " file (" + this.file + ") is outdated in the jar!" + (Object)((Object)ConsoleColor.RESET));
            }
            switch (this.decideYamlUpdateMode()) {
                case OVERWRITE: {
                    this.extractFile();
                    this.load();
                    this.logger.info((Object)((Object)ConsoleColor.GREEN) + "Successful updated " + this.getFileDescription() + " file." + (Object)((Object)ConsoleColor.RESET));
                    break;
                }
                case UPDATE: {
                    this.update();
                    break;
                }
                case UPGRADE: {
                    this.upgrade();
                }
            }
        } else {
            if (this.getExpectedVersion().olderThan(this.version())) {
                this.logger.info(this.getFileDescriptionCapitalized() + " file version newer than expected! Expected: " + this.getExpectedVersion() + " Is: " + this.version());
            }
            this.loaded();
        }
    }

    protected void update() {
        this.logger.info(this.getFileDescriptionCapitalized() + " version: " + this.version() + " => " + this.getFileDescriptionCapitalized() + " outdated! Updating ...");
        try {
            this.doUpdate();
            this.yaml.set(KEY_YAML_VERSION, this.getExpectedVersion());
            this.save();
            this.logger.info((Object)((Object)ConsoleColor.GREEN) + "Successful updated " + this.getFileDescription() + " file." + (Object)((Object)ConsoleColor.RESET));
        }
        catch (Exception e) {
            this.logger.warning("Failed to update " + this.getFileDescription() + "!");
            e.printStackTrace();
            this.yaml = null;
        }
    }

    protected void upgrade() {
        this.logger.info(this.getFileDescriptionCapitalized() + " version: " + this.version() + " => " + this.getFileDescriptionCapitalized() + " outdated! Upgrading ...");
        try {
            Version oldVersion = this.version();
            String oldExt = ".old_v" + (oldVersion.toString().startsWith("v") || oldVersion.toString().startsWith("V") ? oldVersion.toString().substring(1) : oldVersion.toString());
            File oldFile = new File(this.yamlFile + oldExt);
            if (oldFile.exists() && !oldFile.delete()) {
                this.logger.warning("Failed to delete old " + this.getFileDescription() + " file backup!");
            }
            if (!this.yamlFile.renameTo(oldFile)) {
                this.logger.warning("Failed to rename old " + this.getFileDescription() + " file! Could not do upgrade!");
                return;
            }
            YAML oldYAML = this.yaml;
            this.load();
            if (this.isLoaded()) {
                this.doUpgrade(new YamlFileManager(this.logger, this.baseDir, oldVersion, new Version(0), this.path, this.file + oldExt, this.inJarPrefix, oldYAML));
            }
            this.yaml.set(KEY_YAML_VERSION, this.getExpectedVersion());
            this.save();
            this.logger.info((Object)((Object)ConsoleColor.GREEN) + "Successful upgraded " + this.getFileDescription() + " file." + (Object)((Object)ConsoleColor.RESET));
        }
        catch (Exception e) {
            this.logger.warning("Failed to upgrade " + this.getFileDescription() + " file.");
            e.printStackTrace();
            this.yaml = null;
        }
    }

    @NotNull
    protected YamlFileUpdateMethod decideYamlUpdateMode() {
        if (this.extracted) {
            return YamlFileUpdateMethod.UPDATE;
        }
        if (this.getYamlUpdateMode() != null) {
            return this.getYamlUpdateMode();
        }
        if (this.version().olderThan(new Version(this.upgradeThreshold))) {
            return YamlFileUpdateMethod.UPGRADE;
        }
        return YamlFileUpdateMethod.UPDATE;
    }

    protected void extractFile() {
        Utils.extractFile(this.jarClass(), this.logger, this.inJarPrefix + this.file, this.yamlFile);
        this.extracted = true;
    }

    protected Class<?> jarClass() {
        return this.getClass();
    }

    @Generated
    public String getFileDescription() {
        return this.fileDescription;
    }

    @Generated
    public String getFileDescriptionCapitalized() {
        return this.fileDescriptionCapitalized;
    }

    public static class YamlFileNotInitializedException
    extends RuntimeException {
        private YamlFileNotInitializedException() {
            super("The yaml file has not been loaded successful");
        }
    }
}

