/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    public static final String VERSION_STING_FORMAT = "[vV]?(?<version>\\d+(\\.\\d+)*)(?<tags>(-[^-\\s]+)*)";
    private static final List<String> EMPTY_TAG_LIST = new ArrayList<String>(0);
    private static final byte SAME = 0;
    private static final byte OLDER = -1;
    private static final byte NEWER = 1;
    private static final String VERSION_SPLIT_REGEX = "\\.";
    private static final String TAG_SPLIT_REGEX = "-";
    private static final String PRE_RELEASE_TAG_FORMAT = "(?<tag>\\w+)\\.?(?<number>\\d+)";
    private static final Pattern PRE_RELEASE_TAG_FORMAT_PATTERN = Pattern.compile("(?<tag>\\w+)\\.?(?<number>\\d+)");
    private static final Pattern VERSION_STING_FORMAT_PATTERN = Pattern.compile("[vV]?(?<version>\\d+(\\.\\d+)*)(?<tags>(-[^-\\s]+)*)");
    private static final String[] PRE_RELEASE_TAGS = new String[]{"alpha", "beta", "pre", "rc", "snapshot"};
    private static final Map<String, Integer> PRE_RELEASE_TAG_VALUE_RESOLUTION = new ConcurrentHashMap<String, Integer>();
    private final String rawVersion;
    private final String[] tags;
    private final int[] versionComponents;
    private final int hashCode;
    private final long timestamp;
    private final long buildNumber;
    private final boolean preRelease;

    public Version(int majorVersion) {
        this("" + majorVersion);
    }

    public Version(int majorVersion, int minorVersion) {
        this(majorVersion + "." + minorVersion);
    }

    public Version(int majorVersion, int minorVersion, int patchVersion) {
        this(majorVersion + "." + minorVersion + "." + patchVersion);
    }

    public Version(@NotNull String version) throws InvalidVersionStringException {
        this(version, false);
    }

    private static int[] getComponents(@NotNull String version, boolean notFinalVersion) {
        String[] comps = version.split(VERSION_SPLIT_REGEX);
        int size = comps.length;
        for (int i = comps.length - 1; i >= 0 && Integer.parseInt(comps[i]) == 0; --i) {
            --size;
        }
        if (size == 0) {
            return new int[]{0};
        }
        int[] versionComponents = new int[size + (notFinalVersion ? 1 : 0)];
        for (int i = 0; i < size; ++i) {
            versionComponents[i] = Integer.parseInt(comps[i]);
        }
        return versionComponents;
    }

    private static void processPreReleaseData(int[] versionComponents, @NotNull List<String> tagsList) {
        int last = 0;
        for (String str : tagsList) {
            if (last == 0) {
                last = Integer.MAX_VALUE;
            }
            int preReleaseTagNumber = 0;
            String tag = str.toLowerCase(Locale.ENGLISH);
            Matcher preMatcher = PRE_RELEASE_TAG_FORMAT_PATTERN.matcher(tag);
            if (preMatcher.matches()) {
                preReleaseTagNumber = Integer.parseInt(preMatcher.group("number"));
                tag = preMatcher.group("tag");
            }
            last = last - PRE_RELEASE_TAG_VALUE_RESOLUTION.get(tag) + preReleaseTagNumber;
        }
        versionComponents[versionComponents.length - 1] = last;
        if (last > 0) {
            for (int i = versionComponents.length - 2; i >= 0; --i) {
                if (versionComponents[i] <= 0 && i != 0) continue;
                int n = i;
                versionComponents[n] = versionComponents[n] - 1;
                break;
            }
        }
    }

    public Version(@NotNull String rawVersion, boolean ignoreTags) throws InvalidVersionStringException {
        Matcher versionMatcher = Version.validateInput(rawVersion);
        this.rawVersion = rawVersion.startsWith("v") || rawVersion.startsWith("V") ? rawVersion.substring(1) : rawVersion;
        this.tags = versionMatcher.group("tags").split(TAG_SPLIT_REGEX);
        List<String> tagsList = !ignoreTags ? Version.getAll(this.tags, PRE_RELEASE_TAGS) : EMPTY_TAG_LIST;
        boolean notAFinalVersion = !tagsList.isEmpty();
        this.versionComponents = Version.getComponents(versionMatcher.group("version"), notAFinalVersion);
        if (notAFinalVersion) {
            this.preRelease = true;
            Version.processPreReleaseData(this.versionComponents, tagsList);
        } else {
            this.preRelease = false;
        }
        this.timestamp = Version.getBuildParameter(this.tags, "(t|ts|time(stamp)?)");
        this.buildNumber = Version.getBuildParameter(this.tags, "(b|build(number)?)");
        this.hashCode = Arrays.hashCode(this.versionComponents);
    }

    private static Matcher validateInput(String version) {
        if (version == null) {
            throw new InvalidVersionStringException("The version string must not be null!");
        }
        Matcher versionMatcher = VERSION_STING_FORMAT_PATTERN.matcher(version);
        if (!versionMatcher.matches()) {
            throw new InvalidVersionStringException();
        }
        return versionMatcher;
    }

    private static long getBuildParameter(@NotNull String[] tags, @NotNull String parameter) {
        Pattern searchPattern = Pattern.compile(parameter + "[=:_]?(?<number>\\d+)", 2);
        for (String tag : tags) {
            Matcher matcher = searchPattern.matcher(tag);
            if (!matcher.matches()) continue;
            try {
                return Long.parseLong(matcher.group("number"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    @NotNull
    private static List<String> getAll(@NotNull String[] source, @NotNull String[] searchForArray) {
        ArrayList<String> result = new ArrayList<String>();
        for (String searchFor : searchForArray) {
            result.addAll(StringUtils.getAllContainingIgnoreCase(source, searchFor));
        }
        return result;
    }

    public static boolean isValidVersionString(@NotNull String version) {
        return VERSION_STING_FORMAT_PATTERN.matcher(version).matches();
    }

    private byte compareLength(int c, @NotNull Version otherVersion) {
        if (this.versionComponents.length != otherVersion.versionComponents.length) {
            boolean otherLonger = otherVersion.versionComponents.length > this.versionComponents.length;
            int[] longer = otherLonger ? otherVersion.versionComponents : this.versionComponents;
            for (int i = c; i < longer.length; ++i) {
                if (longer[i] <= 0) continue;
                return otherLonger ? (byte)-1 : 1;
            }
        }
        return 0;
    }

    private byte compareTimeStamp(long otherTimeStamp) {
        if (this.timestamp > 0L && otherTimeStamp > 0L) {
            if (this.timestamp > otherTimeStamp) {
                return 1;
            }
            if (this.timestamp < otherTimeStamp) {
                return -1;
            }
        }
        return 0;
    }

    private byte compareBuildNumber(long otherBuildNumber) {
        if (this.buildNumber > 0L && otherBuildNumber > 0L) {
            if (this.buildNumber > otherBuildNumber) {
                return 1;
            }
            if (this.buildNumber < otherBuildNumber) {
                return -1;
            }
        }
        return 0;
    }

    private byte compare(@NotNull Version otherVersion) {
        int c = Math.min(this.versionComponents.length, otherVersion.versionComponents.length);
        for (int i = 0; i < c; ++i) {
            if (otherVersion.versionComponents[i] > this.versionComponents[i]) {
                return -1;
            }
            if (otherVersion.versionComponents[i] >= this.versionComponents[i]) continue;
            return 1;
        }
        byte lengthResult = this.compareLength(c, otherVersion);
        if (lengthResult != 0) {
            return lengthResult;
        }
        byte timeStampResult = this.compareTimeStamp(otherVersion.timestamp);
        if (timeStampResult != 0) {
            return timeStampResult;
        }
        return this.compareBuildNumber(otherVersion.buildNumber);
    }

    public boolean isPreRelease() {
        return this.preRelease;
    }

    public boolean newerThan(@NotNull Version otherVersion) {
        return this.compare(otherVersion) == 1;
    }

    public boolean newerOrEqualThan(@NotNull Version otherVersion) {
        return this.compare(otherVersion) >= 0;
    }

    public boolean olderThan(@NotNull Version otherVersion) {
        return this.compare(otherVersion) == -1;
    }

    public boolean olderOrEqualThan(@NotNull Version otherVersion) {
        return this.compare(otherVersion) <= 0;
    }

    public boolean newerThan(@NotNull String otherVersion) throws InvalidVersionStringException {
        return this.compare(new Version(otherVersion)) == 1;
    }

    public boolean newerOrEqualThan(@NotNull String otherVersion) throws InvalidVersionStringException {
        return this.compare(new Version(otherVersion)) >= 0;
    }

    public boolean olderThan(@NotNull String otherVersion) throws InvalidVersionStringException {
        return this.compare(new Version(otherVersion)) == -1;
    }

    public boolean olderOrEqualThan(@NotNull String otherVersion) throws InvalidVersionStringException {
        return this.compare(new Version(otherVersion)) <= 0;
    }

    public boolean equals(String otherVersion) throws InvalidVersionStringException {
        return this.equals(new Version(otherVersion));
    }

    @NotNull
    public String toString() {
        return this.rawVersion;
    }

    @Contract(value="null -> false")
    public boolean equals(Object otherVersion) {
        return otherVersion instanceof Version && this.compare((Version)otherVersion) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(@NotNull Version o) {
        return this.compare(o);
    }

    public int getMajor() {
        return this.versionComponents.length > 0 ? this.versionComponents[0] : 0;
    }

    public int getMinor() {
        return this.versionComponents.length > 1 ? this.versionComponents[1] : 0;
    }

    public int getPatch() {
        return this.versionComponents.length > 2 ? this.versionComponents[2] : 0;
    }

    public int toInt() {
        return (this.getMajor() & 0xFF) << 22 | (this.getMinor() & 0x7FF) << 12 | this.getPatch() & 0xFF;
    }

    static {
        for (int i = 0; i < PRE_RELEASE_TAGS.length; ++i) {
            PRE_RELEASE_TAG_VALUE_RESOLUTION.put(PRE_RELEASE_TAGS[i], (PRE_RELEASE_TAGS.length + 1 - i) * 10);
        }
    }

    public static class InvalidVersionStringException
    extends IllegalArgumentException {
        private static final String DEFAULT_ERROR = "The version string must be in the format: [vV]?(?<version>\\d+(\\.\\d+)*)(?<tags>(-[^-\\s]+)*)";

        public InvalidVersionStringException() {
            this(DEFAULT_ERROR);
        }

        public InvalidVersionStringException(String string) {
            super(string);
        }
    }
}

