/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    protected Utils() {
    }

    @NotNull
    public static String byteArrayToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder hexBuilder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hexBuilder.append(String.format("%02x", b));
        }
        return hexBuilder.toString();
    }

    public static void blockThread(int pauseTime) {
        if (pauseTime > 0) {
            try {
                Thread.sleep((long)pauseTime * 1000L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> boolean arrayContains(@NotNull T[] array, @Nullable T data) {
        for (T element : array) {
            if (!element.equals(data)) continue;
            return true;
        }
        return false;
    }

    public static long streamCopy(@NotNull InputStream from, @NotNull OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean extractFile(@NotNull Class<?> pluginClass, @NotNull Logger logger, @NotNull String inJarPath, @NotNull File targetFile) {
        try {
            File parentFile;
            if (targetFile.exists() && !targetFile.delete()) {
                logger.log(Level.WARNING, "Failed to delete old file ({0}).", targetFile);
            }
            if (!(parentFile = targetFile.getParentFile()).exists() && !parentFile.mkdirs()) {
                logger.log(Level.WARNING, "Failed creating directory''s! Expected path: {0}", parentFile);
            }
            if (!targetFile.createNewFile()) {
                logger.log(Level.WARNING, "Failed create new file ({0}).", targetFile);
            }
            if (!inJarPath.startsWith("/")) {
                inJarPath = "/" + inJarPath;
            }
            try (InputStream is = pluginClass.getResourceAsStream(inJarPath);
                 FileOutputStream os = new FileOutputStream(targetFile);){
                if (is == null) {
                    logger.log(Level.SEVERE, "Failed to extract \"{0}\" because it does not exist!", inJarPath);
                    boolean bl = false;
                    return bl;
                }
                Utils.streamCopy(is, os);
                os.flush();
            }
            logger.log(Level.INFO, "File \"{0}\" extracted successfully!", inJarPath);
            return true;
        }
        catch (IOException | NullPointerException e) {
            logger.severe("Failed to extract file \"" + inJarPath + "\"! Reason: " + e.getMessage());
            return false;
        }
    }

    public static byte tryParse(@NotNull String string, byte fallbackValue) {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return fallbackValue;
        }
    }

    public static short tryParse(@NotNull String string, short fallbackValue) {
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return fallbackValue;
        }
    }

    public static int tryParse(@NotNull String string, int fallbackValue) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return fallbackValue;
        }
    }

    public static long tryParse(@NotNull String string, long fallbackValue) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return fallbackValue;
        }
    }

    public static float tryParse(@NotNull String string, float fallbackValue) {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return fallbackValue;
        }
    }

    public static double tryParse(@NotNull String string, double fallbackValue) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return fallbackValue;
        }
    }

    public static void extractFiles(@NotNull Class<?> pluginClass, @NotNull String inJarPath, @NotNull File targetDir, boolean overwrite) {
        Utils.extractFiles(pluginClass.getProtectionDomain().getCodeSource().getLocation(), inJarPath, targetDir, overwrite);
    }

    public static void extractFiles(@NotNull URL jar, @NotNull String inJarPath, @NotNull File targetDir, boolean overwrite) {
        try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
            ZipEntry e;
            while ((e = zip.getNextEntry()) != null) {
                String name = e.getName();
                if (!name.startsWith(inJarPath)) continue;
                File target = new File(targetDir, name.replace(inJarPath, ""));
                if (!target.getCanonicalPath().startsWith(targetDir.getCanonicalPath())) {
                    System.out.println("Skip file \"" + name + "\" in \"" + jar.getPath() + "\" because it is outside the target directory.");
                    continue;
                }
                if (target.exists()) {
                    if (!overwrite) continue;
                    target.delete();
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(target);){
                    Utils.streamCopy(zip, fileOutputStream);
                    fileOutputStream.flush();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static InputStream getResource(@NotNull Class<?> pluginMainClass, @NotNull String filename) {
        try {
            URL url = pluginMainClass.getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @NotNull
    public static <T extends Enum<T>> T getEnum(@NotNull String valueName, @NotNull T defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return Utils.getEnum(valueName, defaultValue, defaultValue.getClass());
    }

    @Contract(value="_,!null,_->!null")
    @Nullable
    public static <T extends Enum<T>> T getEnum(@NotNull String valueName, @Nullable T defaultValue, @NotNull Class<? extends Enum> clazz) {
        return Utils.getEnum(valueName, defaultValue, clazz, null);
    }

    @NotNull
    public static <T extends Enum<T>> T getEnum(@NotNull String valueName, @NotNull T defaultValue, @Nullable Logger logger) {
        return Utils.getEnum(valueName, defaultValue, defaultValue.getClass(), logger);
    }

    @Contract(value="_,!null,_,_->!null")
    @Nullable
    public static <T extends Enum<T>> T getEnum(@NotNull String valueName, @Nullable T defaultValue, @NotNull Class<? extends Enum> clazz, @Nullable Logger logger) {
        Enum v;
        block2: {
            valueName = valueName.toUpperCase(Locale.ENGLISH);
            v = null;
            try {
                v = Enum.valueOf(clazz, valueName);
            }
            catch (IllegalArgumentException ignored) {
                if (logger == null) break block2;
                logger.info(valueName + " is not a valid option for " + clazz.getSimpleName());
            }
        }
        return (T)(v == null ? defaultValue : v);
    }

    public static <T> void insertAt(ArrayList<T> list, T element, int index) {
        if (index < list.size()) {
            list.set(index, element);
        } else if (index == list.size()) {
            list.add(element);
        } else {
            while (index > list.size()) {
                list.add(null);
            }
            list.add(element);
        }
    }
}

