/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.IUpdater;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateMode;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.NotSuccessfullyQueriedException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.RequestTypeNotAvailableException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.UpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResponseCallback;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResult;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Utils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YAML;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Updater
implements IUpdater {
    private static final int BUFFER_SIZE = 1024;
    @NotNull
    private final File pluginsFolder;
    @NotNull
    private final File updateFolder;
    protected final UpdateProvider[] updateProviders;
    protected UpdateProvider updateProvider;
    private final boolean announceDownloadProgress;
    private final boolean downloadDependencies;
    protected final Logger logger;
    private final String targetFileName;
    private final Version localVersion;
    private boolean checkMinecraftVersion = false;
    private UpdateResult result;

    protected Updater(File pluginsFolder, boolean announceProgress, boolean downloadDependencies, Logger logger, UpdateProvider updateProvider, String localVersion, String targetFileName) {
        this(pluginsFolder, new File(pluginsFolder, "updates"), announceProgress, downloadDependencies, logger, updateProvider, localVersion, targetFileName);
    }

    protected Updater(File pluginsFolder, File updateFolder, boolean announceProgress, boolean downloadDependencies, Logger logger, UpdateProvider updateProvider, String localVersion, String targetFileName) {
        this(pluginsFolder, updateFolder, announceProgress, downloadDependencies, logger, new UpdateProvider[]{updateProvider}, localVersion, targetFileName);
    }

    protected Updater(File pluginsFolder, boolean announceProgress, boolean downloadDependencies, Logger logger, UpdateProvider[] updateProviders, String localVersion, String targetFileName) {
        this(pluginsFolder, new File(pluginsFolder, "updates"), announceProgress, downloadDependencies, logger, updateProviders, localVersion, targetFileName);
    }

    protected Updater(@NotNull File pluginsFolder, @NotNull File updateFolder, boolean announceProgress, boolean downloadDependencies, Logger logger, UpdateProvider[] updateProviders, String localVersion, String targetFileName) {
        assert (updateProviders.length > 0);
        this.pluginsFolder = pluginsFolder;
        this.updateFolder = updateFolder;
        this.updateProviders = updateProviders;
        this.updateProvider = updateProviders[0];
        this.announceDownloadProgress = announceProgress;
        this.downloadDependencies = downloadDependencies;
        this.logger = logger;
        this.localVersion = new Version(localVersion);
        this.targetFileName = targetFileName;
        File updaterConfigFile = new File(pluginsFolder, "Updater" + File.separator + "config.yml");
        if (updaterConfigFile.exists()) {
            try (YAML gravityUpdaterGlobalConfig = new YAML(updaterConfigFile);){
                if (gravityUpdaterGlobalConfig.getBoolean("disable", false)) {
                    this.result = UpdateResult.DISABLED;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void runSync(Runnable var1);

    protected abstract void runAsync(Runnable var1);

    @NotNull
    protected abstract String getAuthor();

    protected boolean versionCheck(Version remoteVersion) {
        if (remoteVersion != null) {
            if (!this.localVersion.olderThan(remoteVersion)) {
                this.result = UpdateResult.NO_UPDATE;
                return false;
            }
        } else {
            this.logger.warning("There was a problem retrieving the remote version of the plugin!");
            this.logger.warning("You should contact the plugin author (" + this.getAuthor() + ") about this!");
            this.result = UpdateResult.FAIL_NO_VERSION_FOUND;
            return false;
        }
        if (this.updateProvider.providesMinecraftVersions() && this.isCheckMinecraftVersion()) {
            return this.checkCompatibility();
        }
        return true;
    }

    protected void download(URL url, String fileName) {
        if (!this.updateFolder.exists() && !this.updateFolder.mkdirs()) {
            this.logger.warning((Object)((Object)ConsoleColor.RED) + "Failed to create folder for updates!" + (Object)((Object)ConsoleColor.RESET));
        }
        try {
            String md5Target;
            String md5Download;
            HttpURLConnection connection = this.updateProvider.connect(url);
            if (connection == null) {
                this.logger.warning("Target url redirected too often. Abort.");
                this.result = UpdateResult.FAIL_DOWNLOAD;
                return;
            }
            long fileLength = connection.getContentLengthLong();
            File downloadFile = new File(this.updateFolder.getAbsolutePath() + File.separator + fileName);
            MessageDigest hashGenerator = this.updateProvider.providesChecksum().getInstanceOrNull();
            try (FilterInputStream inputStream = hashGenerator != null ? new DigestInputStream(new BufferedInputStream(connection.getInputStream()), hashGenerator) : new BufferedInputStream(url.openStream());
                 FileOutputStream outputStream = new FileOutputStream(downloadFile);){
                int count;
                String size;
                if (this.announceDownloadProgress) {
                    this.logger.info("Start downloading update: " + this.updateProvider.getLatestVersion());
                }
                int downloaded = 0;
                int lastProgress = 1;
                float percentPerByte = 100.0f / (float)fileLength;
                byte[] buffer = new byte[1024];
                String string = size = this.announceDownloadProgress && fileLength > 0L ? StringUtils.formatByteCountHumanReadable(fileLength) : "";
                while ((count = ((InputStream)inputStream).read(buffer, 0, 1024)) != -1) {
                    int progress;
                    outputStream.write(buffer, 0, count);
                    if (!this.announceDownloadProgress || fileLength <= 0L || (progress = (int)((float)(downloaded += count) * percentPerByte)) % 10 != 0 || progress <= lastProgress) continue;
                    lastProgress = progress;
                    this.logger.info("Downloading update: " + progress + "% of " + size);
                }
                outputStream.flush();
            }
            connection.disconnect();
            if (hashGenerator != null && !(md5Download = Utils.byteArrayToHex(hashGenerator.digest()).toLowerCase(Locale.ROOT)).equals(md5Target = this.updateProvider.getLatestChecksum().toLowerCase(Locale.ROOT))) {
                this.logger.warning("The auto-updater was able to download the file, but the checksum did not match! Deleting file.");
                this.logger.warning("Checksum expected: " + md5Target + " Checksum download: " + md5Download);
                this.result = UpdateResult.FAIL_DOWNLOAD;
                if (!downloadFile.delete()) {
                    this.logger.warning((Object)((Object)ConsoleColor.RED) + "Failed to delete file:" + (Object)((Object)ConsoleColor.WHITE) + ' ' + downloadFile.getAbsolutePath() + ' ' + (Object)((Object)ConsoleColor.RESET));
                }
                return;
            }
            if (downloadFile.getName().endsWith(".zip")) {
                this.unzip(downloadFile);
            }
            if (this.result != UpdateResult.FAIL_DOWNLOAD) {
                this.result = UpdateResult.SUCCESS;
                if (this.announceDownloadProgress) {
                    this.logger.info("Finished updating.");
                }
            }
        }
        catch (RequestTypeNotAvailableException e) {
            this.logger.log(Level.WARNING, (Object)((Object)ConsoleColor.RED) + "The update provider provided invalid data about its capabilities!" + (Object)((Object)ConsoleColor.RESET), e);
        }
        catch (NotSuccessfullyQueriedException e) {
            this.logger.warning((Object)((Object)ConsoleColor.RED) + "The update provider was not queried successfully!" + (Object)((Object)ConsoleColor.RESET));
            this.result = UpdateResult.FAIL_NO_VERSION_FOUND;
        }
        catch (IOException e) {
            this.logger.warning("The auto-updater tried to download a new update, but was unsuccessful.\n\t\tReason: " + e);
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
    }

    protected void unzip(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().toLowerCase(Locale.ROOT).endsWith(".jar")) continue;
                File destinationFilePath = new File(this.updateFolder, entry.getName());
                try (BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                     BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destinationFilePath), 1024);){
                    Utils.streamCopy(bis, bos);
                    bos.flush();
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "The auto-updater tried to unzip a new update file, but was unsuccessful.", e);
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
        if (!file.delete()) {
            this.logger.info("Failed to delete " + file.getName());
        }
    }

    protected boolean isPluginFile(String name) {
        File[] files = this.pluginsFolder.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!file.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Version getRemoteVersion() {
        try {
            return this.updateProvider.getLatestVersion();
        }
        catch (NotSuccessfullyQueriedException notSuccessfullyQueriedException) {
            return null;
        }
    }

    @Override
    public void update(@Nullable UpdateResponseCallback response) {
        this.prepUpdateOrCheck(response, () -> this.doUpdate(response, 0));
    }

    protected void prepUpdateOrCheck(@Nullable UpdateResponseCallback response, @NotNull Runnable runnable) {
        if (this.isRunning()) {
            if (response != null) {
                response.onDone(UpdateResult.FAIL_UPDATE_ALREADY_IN_PROGRESS);
            }
            return;
        }
        if (this.result == UpdateResult.DISABLED) {
            return;
        }
        this.runAsync(runnable);
    }

    private void query() {
        if (this.result == UpdateResult.DISABLED) {
            return;
        }
        this.result = this.updateProvider.query();
        if (this.result == UpdateResult.SUCCESS) {
            this.result = this.versionCheck(this.getRemoteVersion()) ? UpdateResult.UPDATE_AVAILABLE : UpdateResult.NO_UPDATE;
        }
    }

    protected void downloadDependencies() throws NotSuccessfullyQueriedException, RequestTypeNotAvailableException {
        boolean failedDependency = false;
        for (UpdateProvider.UpdateFile update : this.updateProvider.getLatestDependencies()) {
            this.download(update.getDownloadURL(), update.getFileName());
            if (this.result == UpdateResult.SUCCESS) continue;
            failedDependency = true;
        }
        this.result = failedDependency ? UpdateResult.SUCCESS_DEPENDENCY_DOWNLOAD_FAILED : UpdateResult.SUCCESS;
    }

    protected void doUpdate(@Nullable UpdateResponseCallback responseCallback, int updaterId) {
        this.updateProvider = this.updateProviders[updaterId];
        this.query();
        if (this.result == UpdateResult.UPDATE_AVAILABLE) {
            try {
                if (this.updateProvider.providesDownloadURL()) {
                    this.download(this.updateProvider.getLatestFileURL(), this.updateProvider.getLatestFileName().toLowerCase(Locale.ROOT).endsWith(".zip") ? this.updateProvider.getLatestFileName() : this.targetFileName);
                    if (this.result == UpdateResult.SUCCESS && this.downloadDependencies && this.updateProvider.providesDependencies()) {
                        this.downloadDependencies();
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Critical error while performing update", e);
            }
        }
        if ((this.result.name().startsWith("FAIL") || this.result == UpdateResult.UPDATE_AVAILABLE || this.result == UpdateResult.NO_UPDATE && updaterId > 0) && updaterId + 1 < this.updateProviders.length) {
            this.doUpdate(responseCallback, updaterId + 1);
        } else if (responseCallback != null) {
            this.runSync(() -> responseCallback.onDone(this.result));
        }
    }

    public void doCheckForUpdate(@Nullable UpdateResponseCallback responseCallback, int updaterId) {
        this.updateProvider = this.updateProviders[updaterId];
        this.query();
        if (this.result.name().startsWith("FAIL") && updaterId + 1 < this.updateProviders.length) {
            this.doCheckForUpdate(responseCallback, updaterId + 1);
        } else if (responseCallback != null) {
            this.runSync(() -> responseCallback.onDone(this.result));
        }
    }

    @Override
    public void checkForUpdate(@Nullable UpdateResponseCallback response) {
        this.prepUpdateOrCheck(response, () -> this.doCheckForUpdate(response, 0));
    }

    @Override
    public void update(@NotNull UpdateMode updateMode, @Nullable UpdateResponseCallback response) {
        if (updateMode == UpdateMode.UPDATE) {
            this.update(response);
        } else if (updateMode == UpdateMode.CHECK) {
            this.checkForUpdate(response);
        }
    }

    protected boolean checkCompatibility() {
        return true;
    }

    @Generated
    public boolean isCheckMinecraftVersion() {
        return this.checkMinecraftVersion;
    }

    @Generated
    public void setCheckMinecraftVersion(boolean checkMinecraftVersion) {
        this.checkMinecraftVersion = checkMinecraftVersion;
    }
}

