/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.ChecksumType;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.BaseOnlineProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.NotSuccessfullyQueriedException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.RequestTypeNotAvailableException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.UpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResult;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonArray;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonObject;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class SpigotUpdateProvider
extends BaseOnlineProvider {
    private static final String SPIGOT_API = "https://api.spiget.org/v2/resources/";
    private final int projectID;
    private final String filename;
    private boolean downloadable = false;
    private UpdateProvider.UpdateFile lastResult = null;

    public SpigotUpdateProvider(int projectId, @NotNull Logger logger) {
        this(projectId, logger, projectId + ".jar");
    }

    public SpigotUpdateProvider(int projectId, @NotNull Logger logger, @NotNull String filename) {
        super(logger);
        this.filename = filename;
        this.projectID = projectId;
    }

    @Override
    @NotNull
    public String getName() {
        return "SpigotMC";
    }

    @Override
    @NotNull
    public UpdateResult query() {
        try {
            UpdateProvider.UpdateFile result = new UpdateProvider.UpdateFile();
            HttpURLConnection connection = this.connect(new URL(SPIGOT_API + this.projectID));
            if (connection == null) {
                return UpdateResult.FAIL_FILE_NOT_FOUND;
            }
            JsonParser parser = new JsonParser();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                JsonObject resObject = parser.parse(reader).getAsJsonObject();
                boolean bl = this.downloadable = !resObject.get("external").getAsBoolean();
                if (this.downloadable) {
                    result.setDownloadURL(new URL(SPIGOT_API + this.projectID + "/download"));
                } else {
                    result.setDownloadURL(new URL("https://spigotmc.org/" + resObject.get("file").getAsJsonObject().get("url").getAsString()));
                }
                result.setName(resObject.get("name").getAsString());
                result.setFileName(this.filename);
                JsonArray jsonGameVersions = resObject.get("testedVersions").getAsJsonArray();
                String[] gameVersions = new String[jsonGameVersions.size()];
                for (int i = 0; i < jsonGameVersions.size(); ++i) {
                    gameVersions[i] = jsonGameVersions.get(i).getAsString();
                }
                if (gameVersions.length == 0) {
                    result.setGameVersions(null);
                    result.setGameVersion(null);
                } else {
                    result.setGameVersions(gameVersions);
                    result.setGameVersion(gameVersions[gameVersions.length - 1]);
                }
            }
            connection.disconnect();
            connection = this.connect(new URL(SPIGOT_API + this.projectID + "/versions/latest"));
            if (connection == null) {
                return UpdateResult.FAIL_FILE_NOT_FOUND;
            }
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            try {
                result.setVersion(new Version(parser.parse(reader).getAsJsonObject().get("name").getAsString()));
            }
            finally {
                reader.close();
            }
            connection.disconnect();
            this.lastResult = result;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to query spigot api for updates.", e);
            return UpdateResult.FAIL_FILE_NOT_FOUND;
        }
        return UpdateResult.SUCCESS;
    }

    @Override
    @NotNull
    public String getLatestFileName() throws NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastResult.getFileName();
    }

    @Override
    @NotNull
    public String getLatestName() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastResult.getName();
    }

    @Override
    @NotNull
    public Version getLatestVersion() throws NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastResult.getVersion();
    }

    @Override
    @NotNull
    public URL getLatestFileURL() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        if (!this.downloadable) {
            throw new RequestTypeNotAvailableException("The spigot update provider only allows to download resources hosted on spigotmc.org!");
        }
        return this.lastResult.getDownloadURL();
    }

    @Override
    @NotNull
    public String getLatestMinecraftVersion() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        if (this.lastResult.getGameVersion() == null) {
            throw new RequestTypeNotAvailableException("The plugin does not provide a list of compatible minecraft versions!");
        }
        return this.lastResult.getGameVersion();
    }

    @Override
    @NotNull
    public String getLatestChecksum() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The spigot update provider does not provide a md5 checksum!");
    }

    @Override
    @NotNull
    public String getLatestChangelog() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The spigot update provider does not provide a changelog!");
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getLatestDependencies() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The spigot update provider does not provide a list of dependencies to download!");
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getUpdateHistory() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The spigot update provider does not provide an update history!");
    }

    @Override
    @NotNull
    public String[] getLatestMinecraftVersions() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        if (this.lastResult.getGameVersion() == null) {
            throw new RequestTypeNotAvailableException("The plugin does not provide a list of compatible minecraft versions!");
        }
        return this.lastResult.getGameVersions();
    }

    @Override
    public final boolean providesDownloadURL() {
        return this.downloadable;
    }

    @Override
    public boolean providesChangelog() {
        return false;
    }

    @Override
    @NotNull
    public ChecksumType providesChecksum() {
        return ChecksumType.NONE;
    }

    @Override
    public boolean providesUpdateHistory() {
        return false;
    }

    @Override
    public boolean providesDependencies() {
        return false;
    }

    @Override
    public boolean providesMinecraftVersion() {
        if (this.lastResult != null) {
            return this.lastResult.getGameVersion() != null;
        }
        return true;
    }

    @Override
    public boolean providesMinecraftVersions() {
        if (this.lastResult != null) {
            return this.lastResult.getGameVersions() != null;
        }
        return true;
    }
}

