/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.ChecksumType;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.BaseOnlineProviderWithDownload;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.NotSuccessfullyQueriedException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.RequestTypeNotAvailableException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.UpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResult;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonArray;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonObject;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JenkinsUpdateProvider
extends BaseOnlineProviderWithDownload {
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*-(?<VersionString>[vV]?(?<version>\\d+(\\.\\d+)*)(?<tags>(-[^-\\s]+)*))\\.(jar|zip)");
    private static final String API_FILTER = "tree=artifacts[relativePath,fileName],fingerprint[hash],number,timestamp,url,fullDisplayName,changeSet[items[comment]]";
    private static final String[] IGNORE_ARTIFACTS = new String[]{"javadoc", "sources"};
    private final String host;
    private final String token;
    private final String artifactSearchRegex;
    private final URL url;

    public JenkinsUpdateProvider(@NotNull String host, @NotNull String job, @NotNull Logger logger) {
        this(host, job, null, logger);
    }

    public JenkinsUpdateProvider(@NotNull String host, @NotNull String job, @NotNull Logger logger, @Nullable @Language(value="RegExp") String artifactSearchRegex) {
        this(host, job, null, logger, artifactSearchRegex);
    }

    public JenkinsUpdateProvider(@NotNull String host, @NotNull String job, @Nullable String token, @NotNull Logger logger) {
        this(host, job, token, logger, null);
    }

    public JenkinsUpdateProvider(@NotNull String host, @NotNull String job, @Nullable String token, @NotNull Logger logger, @Nullable @Language(value="RegExp") String artifactSearchRegex) {
        super(logger);
        StringBuilder urlBuilder = new StringBuilder(host.contains("://") ? "" : "https://");
        urlBuilder.append(host);
        if (!host.endsWith("/")) {
            urlBuilder.append('/');
        }
        urlBuilder.append("job/");
        urlBuilder.append(job.replace(" ", "%20"));
        urlBuilder.append("/lastSuccessfulBuild/api/json");
        urlBuilder.append('?');
        urlBuilder.append(API_FILTER);
        if (token != null) {
            urlBuilder.append("&token=");
            urlBuilder.append(token);
        }
        URL tmpUrl = null;
        try {
            tmpUrl = new URL(urlBuilder.toString());
        }
        catch (MalformedURLException e) {
            logger.severe((Object)((Object)ConsoleColor.RED) + "Failed to build jenkins api url!\nHost:" + (Object)((Object)ConsoleColor.WHITE) + ' ' + host + "    " + (Object)((Object)ConsoleColor.RED) + "Job:" + (Object)((Object)ConsoleColor.WHITE) + ' ' + job + '\n' + (Object)((Object)ConsoleColor.RED) + "Built URL:" + (Object)((Object)ConsoleColor.WHITE) + ' ' + urlBuilder + ' ' + (Object)((Object)ConsoleColor.RESET));
        }
        this.url = tmpUrl;
        this.host = host;
        this.token = token;
        this.artifactSearchRegex = artifactSearchRegex;
    }

    @Override
    @NotNull
    public String getName() {
        return "Jenkins";
    }

    private boolean filteredFile(String filename) {
        if (this.artifactSearchRegex != null) {
            return !filename.matches(this.artifactSearchRegex);
        }
        return StringUtils.containsIgnoreCase(filename, IGNORE_ARTIFACTS);
    }

    String readChangelog(JsonArray changeSetItems) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < changeSetItems.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(changeSetItems.get(i).getAsJsonObject().getAsJsonPrimitive("comment").getAsString());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public UpdateResult query() {
        if (this.url == null) {
            return UpdateResult.FAIL_FILE_NOT_FOUND;
        }
        try {
            String relativePath;
            String filename;
            int artifactId;
            JsonObject object;
            UpdateProvider.UpdateFile result;
            BufferedReader reader;
            HttpURLConnection connection;
            block17: {
                connection = this.connect(this.url);
                if (connection == null) {
                    return UpdateResult.FAIL_FILE_NOT_FOUND;
                }
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                result = new UpdateProvider.UpdateFile();
                object = JsonParser.parseReader(reader).getAsJsonObject();
                JsonArray artifacts = object.getAsJsonArray("artifacts");
                artifactId = -1;
                filename = "";
                relativePath = "";
                for (int i = 0; i < artifacts.size(); ++i) {
                    JsonObject artifact = artifacts.get(i).getAsJsonObject();
                    filename = artifact.getAsJsonPrimitive("fileName").getAsString();
                    relativePath = artifact.getAsJsonPrimitive("relativePath").getAsString();
                    if (this.filteredFile(filename)) {
                        continue;
                    }
                    artifactId = i;
                    break;
                }
                if (artifactId >= 0) break block17;
                UpdateResult i = UpdateResult.FAIL_FILE_NOT_FOUND;
                reader.close();
                return i;
            }
            try {
                try {
                    result.setFileName(filename);
                    result.setName(object.getAsJsonPrimitive("fullDisplayName").getAsString());
                    result.setDownloadURL(new URL(object.getAsJsonPrimitive("url").getAsString() + "artifact/" + relativePath));
                    result.setChecksum(object.getAsJsonArray("fingerprint").get(artifactId).getAsJsonObject().getAsJsonPrimitive("hash").getAsString());
                    result.setChangelog(this.readChangelog(object.getAsJsonObject("changeSet").getAsJsonArray("items")));
                    Matcher matcher = VERSION_PATTERN.matcher(result.getFileName());
                    if (matcher.matches()) {
                        StringBuilder versionBuilder = new StringBuilder(matcher.group("VersionString"));
                        versionBuilder.append("-T");
                        Date buildTime = new Date(object.getAsJsonPrimitive("timestamp").getAsLong());
                        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                        format.setTimeZone(TimeZone.getTimeZone("UTC"));
                        versionBuilder.append(format.format(buildTime));
                        versionBuilder.append("-b");
                        versionBuilder.append(object.getAsJsonPrimitive("number").getAsString());
                        result.setVersion(new Version(versionBuilder.toString()));
                        this.lastResult = result;
                    }
                }
                catch (Exception ignored) {
                    this.logger.warning((Object)((Object)ConsoleColor.RED) + "Failed to parse the result from the server!" + (Object)((Object)ConsoleColor.RESET));
                    UpdateResult updateResult = UpdateResult.FAIL_NO_VERSION_FOUND;
                    reader.close();
                    return updateResult;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                reader.close();
            }
            connection.disconnect();
            return UpdateResult.SUCCESS;
        }
        catch (IOException e) {
            if (!e.getMessage().contains("HTTP response code: 403")) {
                this.logErrorOffline(this.host, e.getMessage());
                return UpdateResult.FAIL_SERVER_OFFLINE;
            }
            if (this.token == null) {
                this.logger.severe((Object)((Object)ConsoleColor.RED) + "The jenkins server requires a token for the given job!" + (Object)((Object)ConsoleColor.RESET));
                this.logger.severe((Object)((Object)ConsoleColor.RED) + "Please add a token to your configuration and try again." + (Object)((Object)ConsoleColor.RESET));
                return UpdateResult.FAIL_API_KEY;
            }
            this.logger.severe((Object)((Object)ConsoleColor.RED) + "The jenkins server rejected the provided token!" + (Object)((Object)ConsoleColor.RESET));
            this.logger.severe((Object)((Object)ConsoleColor.RED) + "Please double-check your configuration to ensure it is correct." + (Object)((Object)ConsoleColor.RESET));
            return UpdateResult.FAIL_API_KEY;
        }
    }

    @Override
    @NotNull
    public String getLatestMinecraftVersion() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The jenkins API does not provide any information's about the minecraft version!");
    }

    @Override
    @NotNull
    public String getLatestChecksum() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastResult.getChecksum();
    }

    @Override
    @NotNull
    public String getLatestChangelog() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastResult.getChangelog();
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getLatestDependencies() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The jenkins API does not provide a list of dependencies to download!");
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getUpdateHistory() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The jenkins API does not provide an update history.");
    }

    @Override
    @NotNull
    public String[] getLatestMinecraftVersions() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The jenkins update provider does not provide a list of supported minecraft versions!");
    }

    @Override
    public boolean providesMinecraftVersions() {
        return false;
    }

    @Override
    public boolean providesMinecraftVersion() {
        return false;
    }

    @Override
    public boolean providesChangelog() {
        return true;
    }

    @Override
    @NotNull
    public ChecksumType providesChecksum() {
        return ChecksumType.MD5;
    }

    @Override
    public boolean providesUpdateHistory() {
        return false;
    }

    @Override
    public boolean providesDependencies() {
        return false;
    }
}

