/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.ChecksumType;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.BaseOnlineProviderWithDownload;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.NotSuccessfullyQueriedException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.RequestTypeNotAvailableException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.UpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResult;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonArray;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonObject;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubUpdateProvider
extends BaseOnlineProviderWithDownload {
    private static final Pattern IN_MD_5_SEARCH_PATTERN = Pattern.compile("(?<hash>[\\da-fA-F]{32})\\s+\\*?(?<file>.*)");
    private final URL url;
    @NotNull
    private final Pattern assetJarPattern;
    @Nullable
    private final Pattern assetMD5Pattern;
    private final String projectRepo;

    public GitHubUpdateProvider(@NotNull String githubProjectOwner, @NotNull String githubProjectRepo, @NotNull Logger logger) {
        this(githubProjectOwner, githubProjectRepo, githubProjectRepo, ".*\\.jar", ".*\\.md5", logger);
    }

    public GitHubUpdateProvider(@NotNull String githubProjectOwner, @NotNull String githubProjectRepo, @NotNull String userAgent, @NotNull @Language(value="RegExp") String jarSearchRegex, @Nullable @Language(value="RegExp") String md5SearchRegex, @NotNull Logger logger) {
        super(userAgent, logger);
        StringBuilder apiUrlBuilder = new StringBuilder("https://api.github.com/repos/");
        apiUrlBuilder.append(githubProjectOwner);
        apiUrlBuilder.append('/');
        apiUrlBuilder.append(githubProjectRepo);
        apiUrlBuilder.append("/releases/latest");
        URL url = null;
        try {
            url = new URL(apiUrlBuilder.toString());
        }
        catch (MalformedURLException e) {
            logger.warning((Object)((Object)ConsoleColor.RED) + "Failed to build github api url!\nBuild URL:" + (Object)((Object)ConsoleColor.WHITE) + ' ' + apiUrlBuilder.toString() + ' ' + (Object)((Object)ConsoleColor.RESET));
        }
        this.url = url;
        this.projectRepo = githubProjectRepo;
        this.assetJarPattern = Pattern.compile(jarSearchRegex, 2);
        this.assetMD5Pattern = md5SearchRegex != null ? Pattern.compile(md5SearchRegex, 2) : null;
    }

    @Override
    @NotNull
    public String getName() {
        return "GitHub";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public UpdateResult query() {
        if (this.url == null) {
            return UpdateResult.FAIL_FILE_NOT_FOUND;
        }
        try {
            JsonObject object;
            UpdateProvider.UpdateFile result;
            BufferedReader reader;
            HttpURLConnection connection;
            block15: {
                connection = this.connect(this.url);
                if (connection == null) {
                    return UpdateResult.FAIL_FILE_NOT_FOUND;
                }
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                result = new UpdateProvider.UpdateFile();
                result.setName(this.projectRepo);
                object = JsonParser.parseReader(reader).getAsJsonObject();
                JsonArray assets = object.getAsJsonArray("assets");
                boolean foundDl = false;
                for (int i = 0; i < assets.size(); ++i) {
                    JsonObject asset = assets.get(i).getAsJsonObject();
                    String name = asset.get("name").getAsString();
                    if (this.assetJarPattern.matcher(name).matches()) {
                        result.setFileName(name);
                        result.setDownloadURL(new URL(asset.get("browser_download_url").getAsString()));
                        foundDl = true;
                        continue;
                    }
                    if (this.assetMD5Pattern == null || !this.assetMD5Pattern.matcher(name).matches()) continue;
                    result.setChecksum(this.getMD5FromUrl(asset.get("browser_download_url").getAsString()));
                }
                if (foundDl) break block15;
                UpdateResult updateResult = UpdateResult.FAIL_FILE_NOT_FOUND;
                reader.close();
                return updateResult;
            }
            try {
                try {
                    result.setVersion(new Version(object.get("tag_name").getAsString()));
                    this.lastResult = result;
                }
                catch (Exception ignored) {
                    this.logger.warning((Object)((Object)ConsoleColor.RED) + "Failed to parse the result from the server!" + (Object)((Object)ConsoleColor.RESET));
                    UpdateResult updateResult = UpdateResult.FAIL_NO_VERSION_FOUND;
                    reader.close();
                    return updateResult;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                reader.close();
            }
            connection.disconnect();
            return UpdateResult.SUCCESS;
        }
        catch (IOException e) {
            if (e.getMessage().contains("HTTP response code: 403")) {
                this.logger.severe((Object)((Object)ConsoleColor.RED) + "api.github.com rejected the provided API key!" + (Object)((Object)ConsoleColor.RESET));
                this.logger.severe((Object)((Object)ConsoleColor.RED) + "Please double-check your configuration to ensure it is correct." + (Object)((Object)ConsoleColor.RESET));
                this.logger.log(Level.SEVERE, null, e);
                return UpdateResult.FAIL_API_KEY;
            }
            this.logErrorOffline("api.github.com", e.getMessage());
            return UpdateResult.FAIL_SERVER_OFFLINE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private String getMD5FromUrl(@NotNull String url) {
        try {
            HttpURLConnection connection = this.connect(new URL(url));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                Matcher matcher;
                do {
                    if ((line = reader.readLine()) == null) return "";
                } while (!(matcher = IN_MD_5_SEARCH_PATTERN.matcher(line)).matches() || !this.assetJarPattern.matcher(matcher.group("file")).matches());
                String string = matcher.group("hash");
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    @NotNull
    public String getLatestMinecraftVersion() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The github update provider does not provide any information's about the minecraft version!");
    }

    @Override
    @NotNull
    public String getLatestChecksum() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.assetMD5Pattern == null) {
            throw new RequestTypeNotAvailableException("The github update provider does not provide a md5 checksum!");
        }
        if (this.lastResult == null || this.lastResult.getChecksum().isEmpty()) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastResult.getChecksum();
    }

    @Override
    @NotNull
    public String getLatestChangelog() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        return "";
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getLatestDependencies() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The github update provider does not provide a list of dependencies to download!");
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getUpdateHistory() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The github update provider does not provide an update history.");
    }

    @Override
    @NotNull
    public String[] getLatestMinecraftVersions() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The github update provider does not provide a list of supported minecraft versions!");
    }

    @Override
    public boolean providesMinecraftVersions() {
        return false;
    }

    @Override
    public boolean providesMinecraftVersion() {
        return false;
    }

    @Override
    public boolean providesChangelog() {
        return false;
    }

    @Override
    @NotNull
    public ChecksumType providesChecksum() {
        return this.assetMD5Pattern != null && (this.lastResult == null || this.lastResult.getChecksum() != null && !this.lastResult.getChecksum().isEmpty()) ? ChecksumType.MD5 : ChecksumType.NONE;
    }

    @Override
    public boolean providesUpdateHistory() {
        return false;
    }

    @Override
    public boolean providesDependencies() {
        return false;
    }
}

