/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.ChecksumType;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.BaseOnlineProviderWithDownload;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.NotSuccessfullyQueriedException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.RequestTypeNotAvailableException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.UpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResult;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitUpdateProvider
extends BaseOnlineProviderWithDownload {
    private static final String HOST = "https://servermods.forgesvc.net/servermods/files?projectIds=";
    private static final Pattern VERSION_PATTERN = Pattern.compile("[vV]?(?<version>\\d+(\\.\\d+)*)(?<tags>(-[^-\\s]+)*)");
    private final int projectID;
    private final String apiKey;
    private final URL url;
    private UpdateProvider.UpdateFile[] lastHistory = null;

    public BukkitUpdateProvider(int projectID, @NotNull Logger logger) {
        this(projectID, null, logger);
    }

    public BukkitUpdateProvider(int projectID, @Nullable String apiKey, @NotNull Logger logger) {
        super(logger);
        this.projectID = projectID;
        this.apiKey = apiKey;
        URL url = null;
        try {
            url = new URL(HOST + projectID);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.url = url;
    }

    @Override
    @NotNull
    public String getName() {
        return "dev.bukkit.org";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public UpdateResult query() {
        if (this.url == null) {
            return UpdateResult.FAIL_FILE_NOT_FOUND;
        }
        try {
            block15: {
                connection = this.connect(this.url);
                if (connection == null) {
                    return UpdateResult.FAIL_FILE_NOT_FOUND;
                }
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                try {
                    devBukkitVersions = BukkitUpdateProvider.GSON.fromJson((Reader)reader, DevBukkitVersion[].class);
                    if (devBukkitVersions != null && devBukkitVersions.length != 0) break block15;
                    this.logger.warning((Object)ConsoleColor.RED + "The updater could not find any files for the project id " + this.projectID + " " + (Object)ConsoleColor.RESET);
                    var4_6 = UpdateResult.FAIL_FILE_NOT_FOUND;
                }
                catch (Throwable var3_5) {
                    try {
                        reader.close();
                        throw var3_5;
                    }
                    catch (Throwable var4_9) {
                        var3_5.addSuppressed(var4_9);
                    }
                    throw var3_5;
                }
                reader.close();
                return var4_6;
            }
            this.lastHistory = new UpdateProvider.UpdateFile[devBukkitVersions.length];
            for (i = 0; i < devBukkitVersions.length; ++i) {
                devBukkitVersion = devBukkitVersions[devBukkitVersions.length - 1];
                latestName = devBukkitVersion.name;
                url = new URL(devBukkitVersion.downloadUrl);
                matcher = BukkitUpdateProvider.VERSION_PATTERN.matcher(latestName);
                if (matcher.find()) {
                    this.lastHistory[i] = this.lastResult = new UpdateProvider.UpdateFile(url, latestName, new Version(matcher.group() + "-" + devBukkitVersion.releaseType), devBukkitVersion.fileName, devBukkitVersion.md5, "", devBukkitVersion.gameVersion);
                    continue;
                }
                if (i != devBukkitVersions.length - 1) ** GOTO lbl-1000
                var9_14 = UpdateResult.FAIL_NO_VERSION_FOUND;
                reader.close();
                return var9_14;
lbl-1000:
                // 1 sources

                {
                    this.lastHistory[i] = new UpdateProvider.UpdateFile(url, latestName, new Version("0.0"), devBukkitVersion.fileName, devBukkitVersion.md5, "", devBukkitVersion.gameVersion);
                    continue;
                }
            }
            {
                catch (MalformedURLException e) {
                    this.logger.log(Level.SEVERE, (Object)ConsoleColor.RED + "Failed to interpret the download url \"" + devBukkitVersions[devBukkitVersions.length - 1].downloadUrl + "\"!" + (Object)ConsoleColor.RESET, e);
                    var5_10 = UpdateResult.FAIL_FILE_NOT_FOUND;
                    reader.close();
                    return var5_10;
                }
            }
            reader.close();
            connection.disconnect();
            return UpdateResult.SUCCESS;
        }
        catch (IOException e) {
            if (e.getMessage().contains("HTTP response code: 403")) {
                this.logger.warning((Object)ConsoleColor.RED + "dev.bukkit.org rejected the provided API key!" + (Object)ConsoleColor.RESET);
                this.logger.warning((Object)ConsoleColor.RED + "If you have manually set an API key, please double-check your configuration to ensure it is correct." + (Object)ConsoleColor.RESET);
                this.logger.warning((Object)ConsoleColor.RED + "If not it's probably a temporary server issue and can be ignored." + (Object)ConsoleColor.RESET);
                return UpdateResult.FAIL_API_KEY;
            }
            this.logErrorOffline("dev.bukkit.org", e.getMessage());
            return UpdateResult.FAIL_SERVER_OFFLINE;
        }
    }

    @Override
    protected void setConnectionParameter(HttpURLConnection connection) {
        if (this.apiKey != null) {
            connection.addRequestProperty("X-API-Key", this.apiKey);
        }
    }

    @Override
    public boolean providesMinecraftVersion() {
        return true;
    }

    @Override
    public boolean providesMinecraftVersions() {
        return false;
    }

    @Override
    public boolean providesChangelog() {
        return false;
    }

    @Override
    @NotNull
    public ChecksumType providesChecksum() {
        return ChecksumType.MD5;
    }

    @Override
    public boolean providesUpdateHistory() {
        return true;
    }

    @Override
    public boolean providesDependencies() {
        return false;
    }

    @Override
    @NotNull
    public String getLatestMinecraftVersion() throws NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastResult.getGameVersion();
    }

    @Override
    @NotNull
    public String getLatestChecksum() throws NotSuccessfullyQueriedException {
        if (this.lastResult == null) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastResult.getChecksum();
    }

    @Override
    @NotNull
    public String getLatestChangelog() throws RequestTypeNotAvailableException {
        throw new RequestTypeNotAvailableException("The dev.bukkit.org API does not provide a changelog!");
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getLatestDependencies() throws RequestTypeNotAvailableException {
        throw new RequestTypeNotAvailableException("The dev.bukkit.org API does not provide a list of dependencies to download!");
    }

    @Override
    @NotNull
    public String[] getLatestMinecraftVersions() throws RequestTypeNotAvailableException {
        throw new RequestTypeNotAvailableException("The dev.bukkit.org API does not provide a list of supported minecraft versions!");
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getUpdateHistory() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.lastHistory == null) {
            throw new NotSuccessfullyQueriedException();
        }
        return this.lastHistory;
    }

    private static class DevBukkitVersion {
        public String name;
        public String downloadUrl;
        public String fileName;
        public String fileUrl;
        public String releaseType;
        public String gameVersion;
        public String md5;
        public String projectId;

        private DevBukkitVersion() {
        }
    }
}

