/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.ReleaseType;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.NotSuccessfullyQueriedException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.UpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.Gson;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public abstract class BaseOnlineProvider
implements UpdateProvider {
    protected static final Gson GSON = new Gson();
    private static final String PROPERTY_USER_AGENT = "User-Agent";
    private static final int TIMEOUT = 5000;
    protected final Logger logger;
    private String userAgent;

    protected BaseOnlineProvider(@NotNull Logger logger) {
        this("PCGF Plugin-Updater", logger);
    }

    protected BaseOnlineProvider(@NotNull String userAgent, @NotNull Logger logger) {
        this.logger = logger;
        this.userAgent = userAgent;
    }

    @Override
    @NotNull
    public ReleaseType getLatestReleaseType() throws NotSuccessfullyQueriedException {
        Version version = this.getLatestVersion();
        if (!version.isPreRelease()) {
            return ReleaseType.RELEASE;
        }
        String sVersion = version.toString().toLowerCase(Locale.ROOT);
        if (sVersion.contains("alpha")) {
            return ReleaseType.ALPHA;
        }
        if (sVersion.contains("beta")) {
            return ReleaseType.BETA;
        }
        if (sVersion.contains("-rc")) {
            return ReleaseType.RC;
        }
        if (sVersion.contains("snapshot")) {
            return ReleaseType.SNAPSHOT;
        }
        return ReleaseType.UNKNOWN;
    }

    protected void logErrorOffline(String host, String message) {
        this.logger.severe((Object)((Object)ConsoleColor.RED) + "The updater could not contact " + host + " to check for updates!" + (Object)((Object)ConsoleColor.RESET));
        this.logger.severe((Object)((Object)ConsoleColor.RED) + "If this is the first time you are seeing this message, the site may be experiencing temporary downtime." + (Object)((Object)ConsoleColor.RESET));
        this.logger.severe((Object)((Object)ConsoleColor.RED) + "Message: " + message + " " + (Object)((Object)ConsoleColor.RESET));
    }

    @Override
    public HttpURLConnection connect(URL url) throws IOException {
        HttpURLConnection connection = null;
        int status = 0;
        int redirects = 0;
        URL targetUrl = url;
        while (status != 200) {
            if (++redirects >= 5) {
                return null;
            }
            connection = (HttpURLConnection)targetUrl.openConnection();
            connection.setConnectTimeout(5000);
            connection.setInstanceFollowRedirects(true);
            connection.addRequestProperty(PROPERTY_USER_AGENT, this.userAgent);
            this.setConnectionParameter(connection);
            connection.setDoOutput(true);
            status = connection.getResponseCode();
            if (status == 302 || status == 301 || status == 303) {
                targetUrl = new URL(connection.getHeaderField("Location"));
                continue;
            }
            if (status == 200) continue;
            break;
        }
        return connection;
    }

    protected void setConnectionParameter(HttpURLConnection connection) {
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    @Generated
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

