/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.ChecksumType;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.ReleaseType;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.BaseOnlineProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.NotSuccessfullyQueriedException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.RequestTypeNotAvailableException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.UpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResult;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class AlwaysUpdateProvider
extends BaseOnlineProvider {
    private final URL downloadUrl;
    private final String fileName;
    private final ReleaseType releaseType;

    public AlwaysUpdateProvider(@NotNull String url) {
        this(url, "file.jar");
    }

    public AlwaysUpdateProvider(@NotNull String url, String fileName) {
        this(url, fileName, ReleaseType.RELEASE);
    }

    public AlwaysUpdateProvider(@NotNull String url, String fileName, ReleaseType releaseType) {
        super(Logger.getAnonymousLogger());
        this.releaseType = releaseType;
        this.fileName = fileName;
        URL dlURL = null;
        try {
            dlURL = new URL(url);
        }
        catch (MalformedURLException e) {
            this.logger.log(Level.SEVERE, "Invalid url " + url, e);
        }
        this.downloadUrl = dlURL;
    }

    public AlwaysUpdateProvider(@NotNull URL url) {
        this(url, "file.jar");
    }

    public AlwaysUpdateProvider(@NotNull URL url, String fileName) {
        this(url, fileName, ReleaseType.RELEASE);
    }

    public AlwaysUpdateProvider(@NotNull URL url, String fileName, ReleaseType releaseType) {
        super(Logger.getAnonymousLogger());
        this.releaseType = releaseType;
        this.fileName = fileName;
        this.downloadUrl = url;
    }

    @Override
    @NotNull
    public String getName() {
        return "static URL";
    }

    @Override
    @NotNull
    public UpdateResult query() {
        return UpdateResult.SUCCESS;
    }

    @Override
    @NotNull
    public Version getLatestVersion() throws NotSuccessfullyQueriedException {
        return new Version("2147483647.2147483647");
    }

    @Override
    @NotNull
    public URL getLatestFileURL() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        if (this.downloadUrl == null) {
            throw new RequestTypeNotAvailableException("The URL used to create the provider was not valid!");
        }
        return this.downloadUrl;
    }

    @Override
    @NotNull
    public String getLatestFileName() throws NotSuccessfullyQueriedException {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getLatestName() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("This provider does not provide the name of the latest version.");
    }

    @Override
    @NotNull
    public String getLatestMinecraftVersion() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("This provider does not provide the minecraft version of the latest version.");
    }

    @Override
    @NotNull
    public ReleaseType getLatestReleaseType() throws NotSuccessfullyQueriedException {
        return this.releaseType;
    }

    @Override
    @NotNull
    public String getLatestChecksum() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("This provider does not provide the checksum for the latest file.");
    }

    @Override
    @NotNull
    public String getLatestChangelog() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("This provider does not provide the changelog for the latest file.");
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getLatestDependencies() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("This provider does not provide dependencies for the latest file.");
    }

    @Override
    @NotNull
    public UpdateProvider.UpdateFile[] getUpdateHistory() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("This provider does not provide an update history.");
    }

    @Override
    @NotNull
    public String[] getLatestMinecraftVersions() throws RequestTypeNotAvailableException, NotSuccessfullyQueriedException {
        throw new RequestTypeNotAvailableException("The update provider does not provide a list of supported minecraft versions!");
    }

    @Override
    public boolean providesMinecraftVersions() {
        return false;
    }

    @Override
    public boolean providesDownloadURL() {
        return true;
    }

    @Override
    public boolean providesMinecraftVersion() {
        return false;
    }

    @Override
    public boolean providesChangelog() {
        return false;
    }

    @Override
    @NotNull
    public ChecksumType providesChecksum() {
        return ChecksumType.NONE;
    }

    @Override
    public boolean providesUpdateHistory() {
        return false;
    }

    @Override
    public boolean providesDependencies() {
        return false;
    }
}

