/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.IUpdateConfiguration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.IUpdater;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.ReleaseType;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateMode;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.AlwaysUpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.BukkitUpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.GitHubUpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.JenkinsUpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.NullUpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.SpigotUpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateProviders.UpdateProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResponseCallback;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.UpdateResult;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater.Updater;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Utils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.yaml.YAML;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ManagedUpdaterBase<UPDATER extends Updater, PLUGIN>
implements IUpdater {
    protected final PLUGIN plugin;
    protected final Logger logger;
    private boolean announceDownloadProgress = true;
    private boolean downloadDependencies = false;
    @Nullable
    private UPDATER updater = null;
    protected final Map<String, List<UpdateProvider>> updateChannelMap;
    protected UpdateProvider[] providers;
    protected final String defaultChannel;
    protected final String releaseType;
    protected UpdateMode autoUpdateMode = UpdateMode.UPDATE;

    protected ManagedUpdaterBase(@NotNull PLUGIN plugin, @NotNull Logger logger) {
        this(plugin, logger, null);
    }

    protected ManagedUpdaterBase(@NotNull PLUGIN plugin, @NotNull Logger logger, @Nullable String channel) {
        Map<Object, Object> updateChannelMap;
        this.plugin = plugin;
        this.logger = logger;
        InputStream stream = Utils.getResource(plugin.getClass(), "update.yml");
        String defaultChannel = "";
        String releaseType = "";
        try {
            if (stream == null) {
                throw new IllegalStateException("update.yml missing!");
            }
            YAML config = new YAML(stream);
            Map<String, UpdateProvider> providerMap = ManagedUpdaterBase.getUpdateProviders(config, logger, this.getPluginName());
            updateChannelMap = ManagedUpdaterBase.getUpdateChannels(config, logger, providerMap);
            defaultChannel = config.getString("DefaultChannel");
            releaseType = config.getString("ReleaseType", "");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to read update.yml", e);
            updateChannelMap = new HashMap();
        }
        this.defaultChannel = defaultChannel;
        this.releaseType = releaseType.toLowerCase(Locale.ENGLISH);
        this.updateChannelMap = updateChannelMap;
        this.setChannel(channel);
    }

    public void setConfig(@NotNull IUpdateConfiguration config) {
        this.setChannel(config.getUpdateChannel());
        this.autoUpdateMode = config.getUpdateMode();
    }

    public void setChannel(@Nullable String channel) {
        List providers;
        if (channel == null) {
            channel = this.defaultChannel;
        }
        channel = channel.toLowerCase(Locale.ENGLISH);
        if (this.releaseType.length() >= 1) {
            channel = channel + '.' + this.releaseType;
        }
        if ((providers = (List)this.updateChannelMap.getOrDefault(channel, new ArrayList(0))).size() == 0) {
            this.logger.warning("No update providers for channel: " + channel);
            providers.add(new NullUpdateProvider());
        }
        this.providers = providers.toArray(new UpdateProvider[0]);
    }

    @NotNull
    private static Map<String, UpdateProvider> getUpdateProviders(@NotNull YAML config, @NotNull Logger logger, @NotNull String pluginName) {
        HashMap<String, UpdateProvider> providerMap = new HashMap<String, UpdateProvider>();
        config.getKeysFiltered("UpdateProviders\\.\\w*\\.Type").forEach(typeKey -> {
            String key = typeKey.substring(0, typeKey.length() - ".Type".length());
            String type = config.getString((String)typeKey, "");
            String provider = key.substring("UpdateProviders.".length());
            try {
                UpdateProvider updateProvider = null;
                switch (type) {
                    case "Bukkit": {
                        updateProvider = new BukkitUpdateProvider(config.getInt(key + ".ProjectId"), config.getString(key + ".ApiKey", null), logger);
                        break;
                    }
                    case "Jenkins": {
                        String server = config.getString(key + ".Server");
                        String job = config.getString(key + ".Job");
                        String token = config.getString(key + ".Token", null);
                        String artifactFilter = config.getString(key + "Filter", null);
                        updateProvider = new JenkinsUpdateProvider(server, job, token, logger, artifactFilter);
                        break;
                    }
                    case "GitHub": {
                        String owner = config.getString(key + ".Owner");
                        String repo = config.getString(key + ".Repo");
                        String userAgent = config.getString(key + ".UserAgent", repo);
                        String jarSearch = config.getString(key + ".JarSearch", ".*\\.jar");
                        String md5Search = config.getString(key + ".JarSearch", ".*\\.md5");
                        updateProvider = new GitHubUpdateProvider(owner, repo, userAgent, jarSearch, md5Search, logger);
                        break;
                    }
                    case "Spigot": {
                        int project = config.getInt(key + ".ProjectId");
                        updateProvider = new SpigotUpdateProvider(project, logger, config.getString(key + ".Filename", project + ".jar"));
                        break;
                    }
                    case "Simple": {
                        String url = config.getString(key + ".URL");
                        String fileName = config.getString(key + ".Filename", "file.jar");
                        updateProvider = new AlwaysUpdateProvider(url, fileName, ReleaseType.valueOf(config.getString(key + ".ReleaseType")));
                        break;
                    }
                    default: {
                        logger.warning("Unknown updater type: " + type);
                    }
                }
                if (updateProvider != null) {
                    updateProvider.setUserAgent(pluginName + " Updater (PCGF MC-Plugin-Updater)");
                    providerMap.put(provider, updateProvider);
                }
            }
            catch (Exception e) {
                logger.warning("Unable to read config for update provider: " + type);
            }
        });
        return providerMap;
    }

    private static Map<String, List<UpdateProvider>> getUpdateChannels(@NotNull YAML config, @NotNull Logger logger, @NotNull Map<String, UpdateProvider> providerMap) {
        HashMap<String, List<UpdateProvider>> updateChannelMap = new HashMap<String, List<UpdateProvider>>();
        config.getKeysFiltered("UpdateChannels\\..*").forEach(key -> {
            String channelName = key.substring("UpdateChannels.".length());
            try {
                List<String> providers = config.getStringList((String)key);
                ArrayList<UpdateProvider> providerList = new ArrayList<UpdateProvider>(providers.size());
                for (String provider : providers) {
                    UpdateProvider updateProvider = (UpdateProvider)providerMap.get(provider);
                    if (updateProvider == null) {
                        logger.warning("Unknown update provider '" + provider + "' in channel '" + channelName + "'! Make sure it is defined!");
                        continue;
                    }
                    providerList.add(updateProvider);
                }
                updateChannelMap.put(channelName.toLowerCase(Locale.ENGLISH), providerList);
            }
            catch (Exception e) {
                logger.warning("Unable to read config for update channel: " + channelName);
            }
        });
        return updateChannelMap;
    }

    @Override
    public void update(@Nullable UpdateResponseCallback callback) {
        if (this.isRunning()) {
            if (callback != null) {
                callback.onDone(UpdateResult.FAIL_UPDATE_ALREADY_IN_PROGRESS);
            }
            return;
        }
        if (this.updater == null) {
            this.updater = this.makeUpdater(this.providers);
        }
        ((Updater)this.updater).update(callback);
    }

    @Override
    public void waitForAsyncOperation() {
        if (this.updater != null) {
            this.updater.waitForAsyncOperation();
        }
    }

    @Override
    public void checkForUpdate(@Nullable UpdateResponseCallback response) {
        if (this.isRunning()) {
            if (response != null) {
                response.onDone(UpdateResult.FAIL_UPDATE_ALREADY_IN_PROGRESS);
            }
            return;
        }
        if (this.updater == null) {
            this.updater = this.makeUpdater(this.providers);
        }
        ((Updater)this.updater).checkForUpdate(response);
    }

    @Override
    public void update(@NotNull UpdateMode updateMode, @Nullable UpdateResponseCallback response) {
        if (updateMode == UpdateMode.CHECK) {
            this.checkForUpdate(response);
        } else if (updateMode == UpdateMode.UPDATE) {
            this.update(response);
        }
    }

    @Override
    public boolean isRunning() {
        if (this.updater == null) {
            return false;
        }
        return this.updater.isRunning();
    }

    public void autoUpdate() {
        this.update(this.autoUpdateMode, null);
    }

    protected abstract UPDATER makeUpdater(@NotNull UpdateProvider[] var1);

    protected abstract String getPluginName();

    @Generated
    public boolean isAnnounceDownloadProgress() {
        return this.announceDownloadProgress;
    }

    @Generated
    public boolean isDownloadDependencies() {
        return this.downloadDependencies;
    }

    @Generated
    public void setAnnounceDownloadProgress(boolean announceDownloadProgress) {
        this.announceDownloadProgress = announceDownloadProgress;
    }

    @Generated
    public void setDownloadDependencies(boolean downloadDependencies) {
        this.downloadDependencies = downloadDependencies;
    }

    @Nullable
    @Generated
    public UPDATER getUpdater() {
        return this.updater;
    }
}

