/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Updater;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ChecksumType {
    NONE,
    MD5("MD5"),
    SHA1("SHA1"),
    SHA224("SHA-224"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    private final String algorithm;
    private final boolean supported;

    private ChecksumType() {
        this.supported = false;
        this.algorithm = null;
    }

    private ChecksumType(String algorithm) {
        this.algorithm = algorithm;
        boolean ok = false;
        try {
            MessageDigest.getInstance(algorithm);
            ok = true;
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Hashing algorithm " + algorithm + " is not available on your system.");
        }
        this.supported = ok;
    }

    public boolean isSupported() {
        return this.supported;
    }

    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public MessageDigest getInstance() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.algorithm);
    }

    @Nullable
    public MessageDigest getInstanceOrNull() {
        if (!this.supported) {
            return null;
        }
        try {
            return this.getInstance();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

