/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.UUIDCacheMap;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.Gson;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonObject;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonParser;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UUIDConverter {
    private static final Pattern API_MAX_PROFILE_BATCH_SIZE_PATTERN = Pattern.compile(".*Not more that (?<batchSize>\\d+) profile name per call is allowed.*");
    private static final String UUID_FORMAT_REGEX = "(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})";
    private static final String UUID_FORMAT_REPLACE_TO = "$1-$2-$3-$4-$5";
    private static final long MOJANG_QUERY_RETRY_TIME;
    private static final Gson GSON;
    private static final UUIDCacheMap UUID_CACHE;
    private static int BATCH_SIZE;

    public static String getNameFromUUID(@NotNull UUID uuid) {
        return UUIDConverter.getNameFromUUID(uuid.toString());
    }

    public static String getNameFromUUID(@NotNull String uuid) {
        NameChange[] names = UUIDConverter.getNamesFromUUID(uuid);
        return names[names.length - 1].name;
    }

    public static NameChange[] getNamesFromUUID(@NotNull UUID uuid) {
        return UUIDConverter.getNamesFromUUID(uuid.toString());
    }

    public static NameChange[] getNamesFromUUID(@NotNull String uuid) {
        NameChange[] names = null;
        try {
            Scanner jsonScanner = new Scanner(new URL("https://api.mojang.com/user/profiles/" + uuid.replaceAll("-", "") + "/names").openConnection().getInputStream(), "UTF-8");
            names = GSON.fromJson(jsonScanner.next(), NameChange[].class);
            jsonScanner.close();
        }
        catch (IOException e) {
            System.out.println("Looks like there is a problem with the connection with Mojang. Please retry later.");
            if (e.getMessage().contains("HTTP response code: 429")) {
                System.out.println("You have reached the request limit of the Mojang api! Please retry later!");
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println("Looks like there is no player with this uuid!\n UUID: \"" + uuid + "\"");
            e.printStackTrace();
        }
        return names;
    }

    public static String getUUIDFromName(@NotNull String name, boolean onlineMode) {
        return UUIDConverter.getUUIDFromName(name, onlineMode, false, false, null);
    }

    public static String getUUIDFromName(@NotNull String name, boolean onlineMode, @Nullable Date lastKnownDate) {
        return UUIDConverter.getUUIDFromName(name, onlineMode, false, false, lastKnownDate);
    }

    public static String getUUIDFromName(@NotNull String name, boolean onlineMode, boolean withSeparators) {
        return UUIDConverter.getUUIDFromName(name, onlineMode, withSeparators, false, null);
    }

    public static String getUUIDFromName(@NotNull String name, boolean onlineMode, boolean withSeparators, @Nullable Date lastKnownDate) {
        return UUIDConverter.getUUIDFromName(name, onlineMode, withSeparators, false, lastKnownDate);
    }

    public static String getUUIDFromName(@NotNull String name, boolean onlineMode, boolean withSeparators, boolean offlineUUIDonFail) {
        return UUIDConverter.getUUIDFromName(name, onlineMode, withSeparators, offlineUUIDonFail, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUUIDFromName(@NotNull String name, boolean onlineMode, boolean withSeparators, boolean offlineUUIDonFail, @Nullable Date lastKnownDate) {
        String uuid;
        if (onlineMode) {
            uuid = UUIDConverter.getOnlineUUID(name, lastKnownDate);
            if (uuid == null) {
                if (!offlineUUIDonFail) return null;
                System.out.println("Using offline uuid for '" + name + "'.");
                uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)).toString();
            }
        } else {
            uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)).toString();
        }
        if (withSeparators) {
            if (uuid.contains("-")) return uuid;
            return uuid.replaceAll(UUID_FORMAT_REGEX, UUID_FORMAT_REPLACE_TO);
        }
        if (!uuid.contains("-")) return uuid;
        return uuid.replaceAll("-", "");
    }

    public static UUID getUUIDFromNameAsUUID(@NotNull String name, boolean onlineMode) {
        return UUIDConverter.getUUIDFromNameAsUUID(name, onlineMode, false);
    }

    public static UUID getUUIDFromNameAsUUID(@NotNull String name, boolean onlineMode, @Nullable Date lastKnownDate) {
        return UUIDConverter.getUUIDFromNameAsUUID(name, onlineMode, false, lastKnownDate);
    }

    public static UUID getUUIDFromNameAsUUID(@NotNull String name, boolean onlineMode, boolean offlineUUIDonFail) {
        return UUIDConverter.getUUIDFromNameAsUUID(name, onlineMode, offlineUUIDonFail, null);
    }

    public static UUID getUUIDFromNameAsUUID(@NotNull String name, boolean onlineMode, boolean offlineUUIDonFail, @Nullable Date lastKnownDate) {
        UUID uuid = null;
        if (onlineMode) {
            String sUUID = UUIDConverter.getOnlineUUID(name, lastKnownDate);
            if (sUUID != null) {
                uuid = UUID.fromString(sUUID.replaceAll(UUID_FORMAT_REGEX, UUID_FORMAT_REPLACE_TO));
            } else if (offlineUUIDonFail) {
                uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
            }
        } else {
            uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
        }
        return uuid;
    }

    public static UUID getUUIDCacheOnly(@NotNull String name, boolean offlineModeFallback) {
        String uuidString = UUID_CACHE.get(name);
        if (uuidString != null) {
            return UUID.fromString(uuidString.replaceAll(UUID_FORMAT_REGEX, UUID_FORMAT_REPLACE_TO));
        }
        if (offlineModeFallback) {
            return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    private static String getOnlineUUID(@NotNull String name, @Nullable Date at) {
        if ((at == null || at.after(new Date(System.currentTimeMillis() - 2592000000L))) && UUID_CACHE.containsKey(name)) {
            return UUID_CACHE.get(name);
        }
        String uuid = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new URL("https://api.mojang.com/users/profiles/minecraft/" + name + (at != null ? "?at=" + at.getTime() / 1000L : "")).openStream(), StandardCharsets.UTF_8));){
            uuid = ((JsonObject)new JsonParser().parse(in)).get("id").getAsString();
            if (uuid != null && (at == null || at.after(new Date(System.currentTimeMillis() - 2592000000L)))) {
                UUID_CACHE.put(name, uuid);
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Failed to get uuid cause of a malformed url!\n Name: \"" + name + "\" Date: " + (at != null ? "?at=" + at.getTime() / 1000L : "null"));
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Looks like there is a problem with the connection with mojang. Please retry later.");
            if (e.getMessage().contains("HTTP response code: 429")) {
                System.out.println("You have reached the request limit of the mojang api! Please retry later!");
            }
            e.printStackTrace();
        }
        catch (Exception e) {
            if (at == null) {
                System.out.println("Unable to get UUID for: " + name + "!");
            }
            if (at.getTime() == 0L) {
                System.out.println("Unable to get UUID for: " + name + " at 0! Trying without date!");
                uuid = UUIDConverter.getOnlineUUID(name, null);
            }
            System.out.println("Unable to get UUID for: " + name + " at " + at.getTime() / 1000L + "! Trying at=0!");
            uuid = UUIDConverter.getOnlineUUID(name, new Date(0L));
        }
        return uuid;
    }

    public static Map<String, String> getUUIDsFromNames(@NotNull Collection<String> names, boolean onlineMode, boolean withSeparators) {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, UUID> entry : UUIDConverter.getUUIDsFromNamesAsUUIDs(names, onlineMode).entrySet()) {
            result.put(entry.getKey(), withSeparators ? entry.getValue().toString() : entry.getValue().toString().replaceAll("-", ""));
        }
        return result;
    }

    public static Map<String, UUID> getUUIDsFromNamesAsUUIDs(@NotNull Collection<String> names, boolean onlineMode) {
        if (onlineMode) {
            return UUIDConverter.getUUIDsFromNamesAsUUIDs(names);
        }
        TreeMap<String, UUID> result = new TreeMap<String, UUID>(String.CASE_INSENSITIVE_ORDER);
        for (String name : names) {
            result.put(name, UUIDConverter.getUUIDFromNameAsUUID(name, false));
        }
        return result;
    }

    public static Map<String, UUID> getUUIDsFromNamesAsUUIDs(@NotNull Collection<String> names) {
        ArrayList<String> batch = new ArrayList<String>(BATCH_SIZE);
        Iterator<String> players = names.iterator();
        TreeMap<String, UUID> result = new TreeMap<String, UUID>(String.CASE_INSENSITIVE_ORDER);
        int fromCache = 0;
        int fromWeb = 0;
        while (players.hasNext()) {
            boolean success;
            while (players.hasNext() && batch.size() < BATCH_SIZE) {
                String name = players.next();
                if (UUID_CACHE.containsKey(name)) {
                    result.put(name, UUID.fromString(UUID_CACHE.get(name).replaceAll(UUID_FORMAT_REGEX, UUID_FORMAT_REPLACE_TO)));
                    ++fromCache;
                    continue;
                }
                batch.add(name);
            }
            do {
                HttpURLConnection connection = null;
                try {
                    Profile[] profiles;
                    connection = (HttpURLConnection)new URL("https://api.mojang.com/profiles/minecraft").openConnection();
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "application/json; encoding=UTF-8");
                    connection.setUseCaches(false);
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    try (OutputStream out = connection.getOutputStream();){
                        out.write(GSON.toJson(batch).getBytes(StandardCharsets.UTF_8));
                    }
                    try (Profile[] in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                        profiles = GSON.fromJson((Reader)in, Profile[].class);
                    }
                    for (Profile profile : profiles) {
                        result.put(profile.name, profile.getUUID());
                        UUID_CACHE.put(profile.name, profile.getUUID().toString());
                        ++fromWeb;
                    }
                }
                catch (IOException e) {
                    try {
                        if (connection != null) {
                            int c;
                            if (connection.getResponseCode() == 429) {
                                System.out.println("Reached the request limit of the mojang api!\nConverting will be paused for 10 minutes and then continue!");
                                Thread.sleep(MOJANG_QUERY_RETRY_TIME);
                                success = false;
                                continue;
                            }
                            InputStream errorStream = connection.getErrorStream();
                            StringBuilder errorBuilder = new StringBuilder();
                            while ((c = errorStream.read()) != -1) {
                                errorBuilder.append((char)c);
                            }
                            String errorMessage = errorBuilder.toString();
                            System.out.println("Mojang responded with status code: " + connection.getResponseCode() + " Message: " + errorMessage);
                            Matcher matcher = API_MAX_PROFILE_BATCH_SIZE_PATTERN.matcher(errorMessage);
                            if (connection.getResponseCode() == 400 && matcher.matches()) {
                                BATCH_SIZE = Integer.parseInt(matcher.group("batchSize"));
                                System.out.println("Reducing batch size to " + BATCH_SIZE + " and try again ...");
                                return UUIDConverter.getUUIDsFromNamesAsUUIDs(names);
                            }
                            e.printStackTrace();
                        } else {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException | InterruptedException exception) {
                        // empty catch block
                    }
                    System.out.println("Could not convert all names to uuids because of an issue. Please check the log.");
                    return result;
                }
                batch.clear();
                success = true;
            } while (!success);
        }
        System.out.println("Converted " + (fromCache + fromWeb) + "/" + names.size() + " UUIDs (" + fromCache + " of them from the cache and " + fromWeb + " from Mojang).");
        return result;
    }

    static {
        GSON = new Gson();
        MOJANG_QUERY_RETRY_TIME = 600000L;
        UUID_CACHE = new UUIDCacheMap();
        System.out.println("Loading local uuid cache.");
        int loaded = 0;
        File uuidCache = new File("usercache.json");
        if (uuidCache.exists()) {
            try (JsonReader reader = new JsonReader(new FileReader(uuidCache));){
                CacheData[] dat = (CacheData[])new Gson().fromJson(reader, (Type)((Object)CacheData[].class));
                Date now = new Date();
                for (CacheData d : dat) {
                    if (!now.before(d.getExpiresDate())) continue;
                    ++loaded;
                    UUID_CACHE.put(d.name, d.uuid);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Loaded " + loaded + " UUIDs from local cache.");
        BATCH_SIZE = 100;
    }

    public static class NameChange {
        public String name;
        public long changedToAt;

        public Date getChangeDate() {
            return new Date(this.changedToAt);
        }
    }

    private static class Profile {
        public String id;
        public String name;

        private Profile() {
        }

        public UUID getUUID() {
            return UUID.fromString(this.id.replaceAll(UUIDConverter.UUID_FORMAT_REGEX, UUIDConverter.UUID_FORMAT_REPLACE_TO));
        }
    }

    private static class CacheData {
        public String name;
        public String uuid;
        public String expiresOn;

        private CacheData() {
        }

        public Date getExpiresDate() {
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(this.expiresOn);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return new Date();
            }
        }
    }
}

