/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtils {
    public static final Pattern PAGE_REGEX = Pattern.compile("(?<page>\\d+)(?<op>\\+\\d+|-\\d+|\\+\\+|--)?");
    public static final String ALPHABET_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String ALPHABET_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMBERS = "0123456789";
    public static final String CHAT_COLORS = "0123456789abcdef";
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ALPHANUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final char[] CHAT_COLORS_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private static final char[] ALPHABET_LOWERCASE_CHAR_ARRAY = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] ALPHABET_UPPERCASE_CHAR_ARRAY = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] NUMBERS_CHAR_ARRAY = "0123456789".toCharArray();
    private static final char[] ALPHABET_CHAR_ARRAY = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] ALPHANUMERIC_CHAR_ARRAY = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
    public static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    public static final Pattern IPv4_PATTERN = Pattern.compile("(((?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2}) ?[.,-:;_ ] ?){3}(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2}))");
    public static final Pattern URL_PATTERN = Pattern.compile("[-a-zA-Z0-9@:%_+.~#?&/=]{2,63}[.,][a-z]{2,10}\\b(/[-a-zA-Z0-9@:%_+~#?&/=]*)?");
    private static final String[] BYTE_SIZE_NAMES = new String[]{"byte", "bytes", "kiB", "MiB", "GiB", "TiB", "PiB", "EiB"};
    private static final String ENABLED_MESSAGE = (Object)((Object)ConsoleColor.GREEN) + " %s has been enabled! " + (Object)((Object)ConsoleColor.YELLOW) + " :) " + (Object)((Object)ConsoleColor.RESET);
    private static final String DISABLED_MESSAGE = (Object)((Object)ConsoleColor.RED) + " %s has been disabled. " + (Object)((Object)ConsoleColor.YELLOW) + " :( " + (Object)((Object)ConsoleColor.RESET);

    public static boolean arrayContains(@NotNull String[] strings, @Nullable String searchFor) {
        for (String s : strings) {
            if ((s == null || !s.equals(searchFor)) && (s != null || searchFor != null)) continue;
            return true;
        }
        return false;
    }

    public static boolean arrayContainsIgnoreCase(@NotNull String[] strings, @Nullable String searchFor) {
        for (String s : strings) {
            if ((s == null || !s.equalsIgnoreCase(searchFor)) && (s != null || searchFor != null)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="_, null -> false")
    public static boolean arrayContainsAnyIgnoreCase(@NotNull String[] strings, String ... searchFor) {
        if (searchFor != null && searchFor.length > 0) {
            for (String str : searchFor) {
                if (!StringUtils.arrayContainsIgnoreCase(strings, str)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="_, null -> false")
    public static boolean arrayContainsAny(@NotNull String[] strings, String ... searchFor) {
        if (searchFor != null && searchFor.length > 0) {
            for (String str : searchFor) {
                if (!StringUtils.arrayContains(strings, str)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<String> getAllContaining(@NotNull String[] source, @NotNull String searchFor) {
        ArrayList<String> result = new ArrayList<String>(source.length);
        for (String str : source) {
            if (str == null || !str.contains(searchFor)) continue;
            result.add(str);
        }
        return result;
    }

    @NotNull
    public static List<String> getAllContainingIgnoreCase(@NotNull String[] source, @NotNull String searchFor) {
        ArrayList<String> result = new ArrayList<String>(source.length);
        for (String str : source) {
            if (str == null || !StringUtils.containsIgnoreCase(str, searchFor)) continue;
            result.add(str);
        }
        return result;
    }

    public static boolean containsIgnoreCase(@NotNull String string, @NotNull String searchFor) {
        return string.toLowerCase(Locale.ROOT).contains(searchFor.toLowerCase(Locale.ROOT));
    }

    public static boolean containsIgnoreCase(@NotNull String string, String ... searchFor) {
        string = string.toLowerCase(Locale.ROOT);
        for (String s : searchFor) {
            if (!string.contains(s.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(@NotNull String string, String ... searchFor) {
        for (String s : searchFor) {
            if (!string.contains(s)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String limitLength(@NotNull String text, int maxLength) {
        if (text.length() == 0 || maxLength <= 0) {
            return "";
        }
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength);
    }

    @NotNull
    public static String escapeJsonString(@NotNull String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "\\t").replace("\n", "\\n").replace("\b", "\\b").replace("\f", "\\f");
    }

    public static int parsePageNumber(@NotNull String input) throws NumberFormatException {
        Matcher matcher = PAGE_REGEX.matcher(input);
        if (matcher.matches()) {
            int page = Integer.parseInt(matcher.group("page"));
            if (matcher.group("op") != null) {
                switch (matcher.group("op")) {
                    case "++": {
                        ++page;
                        break;
                    }
                    case "--": {
                        --page;
                        break;
                    }
                    default: {
                        page += Integer.parseInt(matcher.group("op"));
                    }
                }
            }
            if (--page < 0) {
                page = 0;
            }
            return page;
        }
        throw new NumberFormatException("Unable to parse page number! Invalid format!");
    }

    public static String formatByteCountHumanReadable(long bytes) {
        return StringUtils.formatByteCountHumanReadable(Locale.ROOT, bytes);
    }

    public static String formatByteCountHumanReadable(Locale locale, long bytes) {
        int i;
        if (bytes == 1L) {
            return "1 " + BYTE_SIZE_NAMES[0];
        }
        if (bytes < 1024L) {
            return bytes + " " + BYTE_SIZE_NAMES[1];
        }
        double doubleBytes = bytes;
        for (i = 1; doubleBytes >= 1024.0 && i < BYTE_SIZE_NAMES.length; doubleBytes /= 1024.0, ++i) {
        }
        return String.format(locale, doubleBytes >= 100.0 ? "%.1f %s" : "%.2f %s", doubleBytes, BYTE_SIZE_NAMES[i]);
    }

    public static String arrayToString(Object[] array) {
        StringBuilder builder = new StringBuilder();
        for (Object element : array) {
            builder.append(element).append(' ');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @NotNull
    public static String getErrorMessage(@NotNull Throwable e) {
        return e.getClass().getName() + ": " + e.getMessage();
    }

    public static List<String> startsWith(String[] strings, String prefix) {
        return StringUtils.startsWith(Arrays.asList(strings), prefix);
    }

    public static List<String> startsWith(Collection<String> strings, String prefix) {
        return strings.stream().filter(s -> s.startsWith(prefix)).collect(Collectors.toList());
    }

    public static List<String> startsWithIgnoreCase(String[] strings, String prefix) {
        return StringUtils.startsWithIgnoreCase(Arrays.asList(strings), prefix);
    }

    public static List<String> startsWithIgnoreCase(Collection<String> strings, String prefix) {
        return strings.stream().filter(s -> s.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    public static int indexOf(@NotNull String[] strings, @NotNull String value) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(@NotNull String[] strings, @NotNull String value) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equalsIgnoreCase(value)) continue;
            return i;
        }
        return -1;
    }

    public static Collection<Integer> indexOfAllMatching(@NotNull String[] strings, @NotNull @Language(value="RegExp") String searchRegex) {
        Pattern pattern = Pattern.compile(searchRegex);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < strings.length; ++i) {
            Matcher matcher = pattern.matcher(strings[i]);
            if (!matcher.matches()) continue;
            ids.add(i);
        }
        return ids;
    }

    @NotNull
    public static String getPluginEnabledMessage(@NotNull String pluginName) {
        return String.format(ENABLED_MESSAGE, pluginName);
    }

    @NotNull
    public static String getPluginEnabledMessage(@NotNull String pluginName, @NotNull Version version) {
        return StringUtils.getPluginEnabledMessage(pluginName + " v" + version);
    }

    @NotNull
    public static String getPluginDisabledMessage(@NotNull String pluginName) {
        return String.format(DISABLED_MESSAGE, pluginName);
    }

    @NotNull
    public static String getPluginDisabledMessage(@NotNull String pluginName, @NotNull Version version) {
        return StringUtils.getPluginDisabledMessage(pluginName + " v" + version);
    }
}

