/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.Generated;

public class ServerType {
    private static final boolean server;
    private static final boolean bukkit;
    private static final boolean bukkitCompatible;
    private static final boolean spigot;
    private static final boolean spigotCompatible;
    private static final boolean paper;
    private static final boolean paperCompatible;
    private static final boolean glowstone;
    private static final boolean glowstoneCompatible;
    private static final boolean proxy;
    private static final boolean bungeeCord;
    private static final boolean bungeeCordCompatible;
    private static final boolean waterfall;
    private static final boolean waterfallCompatible;
    private static final boolean velocity;
    private static final boolean velocityCompatible;

    private ServerType() {
    }

    @Generated
    public static boolean isServer() {
        return server;
    }

    @Generated
    public static boolean isBukkit() {
        return bukkit;
    }

    @Generated
    public static boolean isBukkitCompatible() {
        return bukkitCompatible;
    }

    @Generated
    public static boolean isSpigot() {
        return spigot;
    }

    @Generated
    public static boolean isSpigotCompatible() {
        return spigotCompatible;
    }

    @Generated
    public static boolean isPaper() {
        return paper;
    }

    @Generated
    public static boolean isPaperCompatible() {
        return paperCompatible;
    }

    @Generated
    public static boolean isGlowstone() {
        return glowstone;
    }

    @Generated
    public static boolean isGlowstoneCompatible() {
        return glowstoneCompatible;
    }

    @Generated
    public static boolean isProxy() {
        return proxy;
    }

    @Generated
    public static boolean isBungeeCord() {
        return bungeeCord;
    }

    @Generated
    public static boolean isBungeeCordCompatible() {
        return bungeeCordCompatible;
    }

    @Generated
    public static boolean isWaterfall() {
        return waterfall;
    }

    @Generated
    public static boolean isWaterfallCompatible() {
        return waterfallCompatible;
    }

    @Generated
    public static boolean isVelocity() {
        return velocity;
    }

    @Generated
    public static boolean isVelocityCompatible() {
        return velocityCompatible;
    }

    static {
        boolean bukkitComp = false;
        boolean spigotComp = false;
        boolean paperComp = false;
        boolean glowComp = false;
        boolean bungeeComp = false;
        boolean waterfallComp = false;
        boolean velocityComp = false;
        boolean isBukkit = false;
        boolean isSpigot = false;
        boolean isPaper = false;
        boolean isGlowstone = false;
        boolean isBungee = false;
        boolean isWaterfall = false;
        boolean isVelocity = false;
        Class<?> bukkitClass = Reflection.getClassSilent("org.bukkit.Bukkit");
        if (bukkitClass != null) {
            Class<?> spigotServerClass;
            bukkitComp = true;
            boolean unknown = false;
            try {
                String version = (String)Reflection.getMethod(bukkitClass, "getVersion", new Class[0]).invoke(null, new Object[0]);
                if (StringUtils.containsIgnoreCase(version, "bukkit")) {
                    isBukkit = true;
                } else if (StringUtils.containsIgnoreCase(version, "spigot")) {
                    isSpigot = true;
                    spigotComp = true;
                } else if (StringUtils.containsIgnoreCase(version, "paper")) {
                    isPaper = true;
                    spigotComp = true;
                    paperComp = true;
                } else if (StringUtils.containsIgnoreCase(version, "glowstone")) {
                    isGlowstone = true;
                    glowComp = true;
                } else {
                    unknown = true;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                unknown = true;
            }
            if (unknown && (spigotServerClass = Reflection.getClassSilent("org.bukkit.Server$Spigot")) != null) {
                spigotComp = true;
                Method methodGetPaperConfig = Reflection.getMethodSilent(spigotServerClass, "getPaperConfig", new Class[0]);
                if (methodGetPaperConfig != null) {
                    paperComp = true;
                }
            }
        } else {
            Class<?> bungeeProxyServerClass = Reflection.getClassSilent("net.md_5.bungee.api.ProxyServer");
            if (bungeeProxyServerClass != null) {
                bungeeComp = true;
                try {
                    Object bungeeInstance = Reflection.getMethod(bungeeProxyServerClass, "getInstance", new Class[0]).invoke(null, new Object[0]);
                    String proxyName = (String)Reflection.getMethod(bungeeProxyServerClass, "getName", new Class[0]).invoke(bungeeInstance, new Object[0]);
                    if ("BungeeCord".equals(proxyName)) {
                        isBungee = true;
                    } else if ("Waterfall".equals(proxyName)) {
                        isWaterfall = true;
                        waterfallComp = true;
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                Class<?> velocityServerClass = Reflection.getClassSilent("com.velocitypowered.api.proxy.ProxyServer");
                if (velocityServerClass != null) {
                    isVelocity = true;
                    velocityComp = true;
                }
            }
        }
        bukkitCompatible = bukkitComp;
        spigotCompatible = spigotComp;
        paperCompatible = paperComp;
        glowstoneCompatible = glowComp;
        server = bukkitComp;
        proxy = bungeeComp || velocityComp;
        bungeeCordCompatible = bungeeComp;
        waterfallCompatible = waterfallComp;
        velocityCompatible = velocityComp;
        bukkit = isBukkit;
        spigot = isSpigot;
        paper = isPaper;
        glowstone = isGlowstone;
        bungeeCord = isBungee;
        waterfall = isWaterfall;
        velocity = isVelocity;
    }
}

