/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reflection {
    @Nullable
    public static Class<?> getClass(@NotNull String classPath) {
        try {
            return Class.forName(classPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Class<?> getClassSilent(@NotNull String classPath) {
        try {
            return Class.forName(classPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static Class<?> getInnerClass(@NotNull Class<?> clazz, @NotNull String className) {
        try {
            Class<?>[] classes;
            for (Class<?> innerClass : classes = clazz.getClasses()) {
                if (!innerClass.getSimpleName().equals(className)) continue;
                return innerClass;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setStaticField(@NotNull Class<?> clazz, @NotNull String field, @Nullable Object value) {
        Reflection.setStaticField(Reflection.getField(clazz, field), value);
    }

    public static void setStaticField(@NotNull Field field, @Nullable Object value) {
        Reflection.setValue(field, null, value);
    }

    public static void setValue(@NotNull Field field, @Nullable Object instance, @Nullable Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setValue(@NotNull Object instance, @NotNull String fieldName, @Nullable Object value) {
        Reflection.setValue(Reflection.getField(instance.getClass(), fieldName), instance, value);
    }

    @Nullable
    public static Enum<?> getEnum(@NotNull String enumFullName) {
        String[] x = enumFullName.split("\\.(?=[^.]+$)");
        if (x.length == 2) {
            try {
                return Enum.valueOf(Class.forName(x[0]), x[1]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static Enum<?> getEnum(@NotNull Class clazz, @NotNull String enumName) {
        try {
            return Enum.valueOf(clazz, enumName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Field getField(@NotNull Class<?> clazz, @NotNull String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Field getFieldIncludeParents(@NotNull Class<?> clazz, @NotNull String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException ignored) {
            if (clazz.getSuperclass() != null) {
                return Reflection.getFieldIncludeParents(clazz.getSuperclass(), name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @NotNull
    public static Collection<Field> getFieldsIncludeParents(@NotNull Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        while ((clazz = clazz.getSuperclass()) != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... args) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(name, args);
            method.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return method;
    }

    @Nullable
    public static Method getMethodSilent(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... args) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(name, args);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    @Nullable
    public static Method getMethodIncludeParents(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... args) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(name, args);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException ignored) {
            if (clazz.getSuperclass() != null) {
                return Reflection.getMethodIncludeParents(clazz.getSuperclass(), name, new Class[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return method;
    }

    @Nullable
    public static Constructor<?> getConstructor(@NotNull Class<?> clazz, Class<?> ... args) {
        try {
            return clazz.getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean classListEqual(@NotNull Class<?>[] l1, @NotNull Class<?>[] l2) {
        if (l1.length != l2.length) {
            return false;
        }
        for (int i = 0; i < l1.length; ++i) {
            if (l1[i] == l2[i]) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static void setFinalField(@NotNull Field field, @Nullable Object instance, @Nullable Object value) throws NoSuchFieldException, IllegalAccessException {
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        modifiers.set(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(instance, value);
        modifiers.set(field, field.getModifiers() | 0x10);
        field.setAccessible(accessible);
        modifiers.setAccessible(false);
    }
}

