/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Configuration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database.DatabaseConnectionPoolBase;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.zaxxer.hikari.HikariConfig;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class SQLiteConnectionPool
extends DatabaseConnectionPoolBase {
    public SQLiteConnectionPool(Configuration config, File dataFolder) {
        super(config, dataFolder);
    }

    @Override
    protected HikariConfig getPoolConfig() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        HikariConfig poolConfig = new HikariConfig();
        poolConfig.setMaximumPoolSize(1);
        poolConfig.setJdbcUrl("jdbc:sqlite:" + this.dataFolder.getAbsolutePath() + File.separator + "backpack.db");
        poolConfig.setConnectionTestQuery("SELECT 1;");
        return poolConfig;
    }

    @Override
    @NotNull
    public String getDatabaseType() {
        return "sqlite";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

