/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Configuration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database.DatabaseConnectionPoolBase;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.zaxxer.hikari.HikariConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MySQLConnectionPool
extends DatabaseConnectionPoolBase {
    public MySQLConnectionPool(Configuration config, File dataFolder) {
        super(config, dataFolder);
    }

    @Override
    protected HikariConfig getPoolConfig() {
        HikariConfig poolConfig = new HikariConfig();
        poolConfig.setJdbcUrl("jdbc:mysql://" + this.config.getString("Database.SQL.Host", "localhost:3306") + "/" + this.config.getString("Database.SQL.Database", "minecraft") + "?allowMultiQueries=true&autoReconnect=true" + this.getSQLConnectionProperties());
        poolConfig.setUsername(this.config.getString("Database.SQL.User", "minecraft"));
        poolConfig.setPassword(this.config.getString("Database.SQL.Password", "minecraft"));
        poolConfig.setMinimumIdle(1);
        poolConfig.setMaximumPoolSize(this.config.getInt("Database.SQL.MaxConnections", 4));
        return poolConfig;
    }

    private String getSQLConnectionProperties() {
        List<String> list = this.config.getConfig().getStringList("Database.SQL.Properties", new ArrayList<String>());
        StringBuilder str = new StringBuilder();
        if (list != null) {
            for (String s : list) {
                str.append("&").append(s);
            }
        }
        return str.toString();
    }

    @Override
    @NotNull
    public String getDatabaseType() {
        return "mysql";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

