/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Configuration;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database.DatabaseConnectionPool;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database.MySQLConnectionPool;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database.SQLiteConnectionPool;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.zaxxer.hikari.HikariConfig;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DatabaseConnectionPoolBase
implements DatabaseConnectionPool,
ConnectionProvider {
    protected final Configuration config;
    protected final File dataFolder;
    private final HikariDataSource dataSource;

    public static DatabaseConnectionPoolBase startPool(Configuration configuration, Logger logger, File dataFolder) {
        DatabaseConnectionPoolBase connectionPool;
        switch (configuration.getString("Database.Type", "off").toLowerCase(Locale.ROOT)) {
            case "mysql": {
                connectionPool = new MySQLConnectionPool(configuration, dataFolder);
                break;
            }
            case "sqlite": {
                connectionPool = new SQLiteConnectionPool(configuration, dataFolder);
                break;
            }
            default: {
                return null;
            }
        }
        try {
            connectionPool.getConnection().close();
        }
        catch (Exception e) {
            logger.warning("Failed to start connection pool.");
            e.printStackTrace();
            connectionPool.close();
            return null;
        }
        return connectionPool;
    }

    public DatabaseConnectionPoolBase(Configuration config, File dataFolder) {
        this.config = config;
        this.dataFolder = dataFolder;
        HikariConfig poolConfig = this.getPoolConfig();
        poolConfig.setPoolName("PCGF_PluginLib-Connection-Pool");
        poolConfig.addDataSourceProperty("useUnicode", "true");
        poolConfig.addDataSourceProperty("characterEncoding", "utf-8");
        poolConfig.addDataSourceProperty("cachePrepStmts", "true");
        poolConfig.addDataSourceProperty("prepStmtCacheSize", "250");
        poolConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.dataSource = new HikariDataSource(poolConfig);
    }

    protected abstract HikariConfig getPoolConfig();

    public void shutdown() {
        this.dataSource.close();
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    @NotNull
    public ConnectionProvider getConnectionProvider() {
        return this;
    }
}

