/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Bungee;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Bungee.ManagedUpdater;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Calendar.BasicTimeSpanFormat;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Calendar.TimeSpan;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Config.Language;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Database.ConnectionProvider.ConnectionProvider;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Plugin.IPlugin;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Config;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.Database.DatabaseConnectionPoolBase;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.PluginLib.PluginLibrary;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Reflection;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Version;
import java.io.File;
import java.util.logging.Level;
import lombok.Generated;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginLib
extends Plugin
implements PluginLibrary,
IPlugin {
    private static PluginLibrary instance = null;
    private ManagedUpdater updater;
    private Config config;
    private Version version;
    private DatabaseConnectionPoolBase databaseConnectionPool;

    public void onEnable() {
        this.updater = new ManagedUpdater(this);
        this.version = new Version(this.getDescription().getVersion());
        this.config = new Config(this, new Version(1));
        if (!this.config.isLoaded()) {
            this.getLogger().warning((Object)((Object)ConsoleColor.RED) + "Failed to load config! Can't start up!" + (Object)((Object)ConsoleColor.RESET));
            this.config = null;
            return;
        }
        this.updater.setConfig(this.config);
        this.updater.autoUpdate();
        this.databaseConnectionPool = DatabaseConnectionPoolBase.startPool(this.config, this.getLogger(), this.getDataFolder());
        Language commonLanguage = new Language(this, new Version(2), File.separator + "lang", "common_");
        commonLanguage.load(this.config.getLanguage(), this.config.getLanguageUpdateMode());
        if (commonLanguage.isLoaded()) {
            String[] unitNames = new String[]{commonLanguage.get("Date.Units.Year"), commonLanguage.get("Date.Units.Years"), commonLanguage.get("Date.Units.Month"), commonLanguage.get("Date.Units.Months"), commonLanguage.get("Date.Units.Day"), commonLanguage.get("Date.Units.Days"), commonLanguage.get("Date.Units.Hour"), commonLanguage.get("Date.Units.Hours"), commonLanguage.get("Date.Units.Minute"), commonLanguage.get("Date.Units.Minutes"), commonLanguage.get("Date.Units.Second"), commonLanguage.get("Date.Units.Seconds")};
            try {
                Reflection.getField(BasicTimeSpanFormat.class, "unitNames").set(Reflection.getField(TimeSpan.class, "DEFAULT_TIME_SPAN_FORMAT").get(null), unitNames);
            }
            catch (IllegalAccessException e) {
                this.getLogger().log(Level.SEVERE, "Failed to set unit names for time span.", e);
            }
        }
        PluginLib.setInstance(this);
        this.getLogger().info(StringUtils.getPluginEnabledMessage(this.getDescription().getName(), this.version));
    }

    public void onDisable() {
        PluginLib.setInstance(null);
        if (this.config == null) {
            return;
        }
        this.updater.autoUpdate();
        if (this.databaseConnectionPool != null) {
            this.databaseConnectionPool.shutdown();
        }
        if (this.updater != null) {
            this.updater.waitForAsyncOperation();
        }
        this.getLogger().info(StringUtils.getPluginDisabledMessage(this.getDescription().getName(), this.version));
    }

    @Override
    @Nullable
    public ConnectionProvider getConnectionProvider() {
        return this.databaseConnectionPool;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getDescription().getName();
    }

    @Generated
    public static PluginLibrary getInstance() {
        return instance;
    }

    @Generated
    private static void setInstance(PluginLibrary instance) {
        PluginLib.instance = instance;
    }

    @Generated
    public ManagedUpdater getUpdater() {
        return this.updater;
    }

    @Override
    @Generated
    public Version getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public DatabaseConnectionPoolBase getDatabaseConnectionPool() {
        return this.databaseConnectionPool;
    }
}

