/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.ITitleMetadata;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Sender.TitleLocation;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonElement;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonObject;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonParser;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class TitleMetadata
implements ITitleMetadata {
    private int fadeIn = 5;
    private int fadeOut = 50;
    private int stay = 5;
    @NotNull
    private TitleLocation location = TitleLocation.TITLE;

    public TitleMetadata() {
    }

    public TitleMetadata(int fadeIn, int fadeOut, int stay) {
        this.fadeIn = fadeIn;
        this.fadeOut = fadeOut;
        this.stay = stay;
    }

    public TitleMetadata(int fadeIn, int fadeOut, int stay, @NotNull TitleLocation location) {
        this(fadeIn, fadeOut, stay);
        this.setLocation(location);
    }

    public TitleMetadata(boolean subtitle) {
        this.setLocation(subtitle ? TitleLocation.SUBTITLE : TitleLocation.TITLE);
    }

    public TitleMetadata(@NotNull TitleLocation location) {
        this.setLocation(location);
    }

    @Override
    public TitleMetadata parseJson(@NotNull String json) {
        try {
            JsonObject object = new JsonParser().parse(json).getAsJsonObject();
            object.entrySet().forEach(e -> {
                switch (((String)e.getKey()).toLowerCase(Locale.ROOT)) {
                    case "fadein": {
                        this.setFadeIn(((JsonElement)e.getValue()).getAsInt());
                        break;
                    }
                    case "stay": {
                        this.setStay(((JsonElement)e.getValue()).getAsInt());
                        break;
                    }
                    case "fadeout": {
                        this.setFadeOut(((JsonElement)e.getValue()).getAsInt());
                        break;
                    }
                    case "subtitle": {
                        if (!((JsonElement)e.getValue()).getAsBoolean()) break;
                        this.setSubtitle();
                        break;
                    }
                    case "location": {
                        this.setLocation(TitleLocation.valueOf(((JsonElement)e.getValue()).getAsString().toUpperCase(Locale.ROOT).replace("ACTIONBAR", "ACTION_BAR").replace("SUB_TITLE", "SUBTITLE")));
                    }
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return this;
    }

    @Override
    @Generated
    public int getFadeIn() {
        return this.fadeIn;
    }

    @Override
    @Generated
    public int getFadeOut() {
        return this.fadeOut;
    }

    @Override
    @Generated
    public int getStay() {
        return this.stay;
    }

    @Override
    @Generated
    public void setFadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
    }

    @Override
    @Generated
    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    @Override
    @Generated
    public void setStay(int stay) {
        this.stay = stay;
    }

    @Override
    @NotNull
    @Generated
    public TitleLocation getLocation() {
        return this.location;
    }

    @Override
    @Generated
    public void setLocation(@NotNull TitleLocation location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
    }
}

