/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.MessageComponentPlaceholderEngine;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Placeholder;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.StringPlaceholderEngine;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

class PlaceholderHandler {
    private final StringPlaceholderEngine legacyPlaceholderEngine;
    private final MessageComponentPlaceholderEngine messageComponentPlaceholderEngine;
    private int nextParameterIndex = 0;
    private boolean prepared = false;

    public PlaceholderHandler(Message message) {
        this.legacyPlaceholderEngine = new StringPlaceholderEngine(message.fallback);
        this.messageComponentPlaceholderEngine = new MessageComponentPlaceholderEngine(message);
    }

    public void register(Placeholder ... placeholders) {
        int patchAutoIndex = -1;
        int lastIndexRequested = -99;
        int lastIndexUsed = Math.max(this.nextParameterIndex - 1, 0);
        for (Placeholder placeholder : placeholders) {
            int parameterIndex = placeholder.getParameterIndex();
            switch (parameterIndex) {
                case -1: {
                    parameterIndex = this.nextParameterIndex;
                    break;
                }
                case -2: {
                    if (lastIndexRequested != placeholder.getParameterIndex()) {
                        parameterIndex = this.nextParameterIndex;
                        break;
                    }
                    parameterIndex = lastIndexUsed;
                    break;
                }
                case -3: {
                    if (patchAutoIndex == -1) {
                        patchAutoIndex = this.nextParameterIndex;
                    }
                    parameterIndex = patchAutoIndex;
                    break;
                }
                case -4: {
                    parameterIndex = lastIndexUsed;
                    break;
                }
                case -5: {
                    parameterIndex = Math.max(this.nextParameterIndex - 1, 0);
                }
            }
            lastIndexRequested = placeholder.getParameterIndex();
            lastIndexUsed = parameterIndex;
            if (placeholder.isRegex()) {
                this.registerPlaceholderRegex(placeholder.getName(), parameterIndex, placeholder.getProcessor());
                continue;
            }
            this.registerPlaceholder(placeholder.getName(), parameterIndex, placeholder.getProcessor());
        }
    }

    private void registerPlaceholder(@NotNull String placeholder, int parameterIndex, IPlaceholderProcessor placeholderProcessor) {
        if (parameterIndex < 0) {
            throw new IllegalArgumentException("Placeholder parameter index must be a positive number!");
        }
        this.legacyPlaceholderEngine.registerPlaceholder(placeholder, parameterIndex, placeholderProcessor);
        this.messageComponentPlaceholderEngine.registerPlaceholder(placeholder, parameterIndex, placeholderProcessor);
        this.nextParameterIndex = Math.max(this.nextParameterIndex, parameterIndex + 1);
    }

    private void registerPlaceholderRegex(@NotNull @Language(value="RegExp") String placeholder, int parameterIndex, IPlaceholderProcessor placeholderProcessor) {
        if (parameterIndex < 0) {
            throw new IllegalArgumentException("Placeholder parameter index must be a positive number!");
        }
        this.legacyPlaceholderEngine.registerPlaceholderRegex(placeholder, parameterIndex, placeholderProcessor);
        this.messageComponentPlaceholderEngine.registerPlaceholderRegex(placeholder, parameterIndex, placeholderProcessor);
        this.nextParameterIndex = Math.max(this.nextParameterIndex, parameterIndex + 1);
    }

    public String formatLegacy(Object ... parameters) {
        return this.legacyPlaceholderEngine.processPlaceholders(parameters);
    }

    public String format(Object ... parameters) {
        return this.messageComponentPlaceholderEngine.processPlaceholders(parameters);
    }

    public void prepare() {
        this.messageComponentPlaceholderEngine.prepare();
        this.prepared = true;
    }

    @Generated
    public boolean isPrepared() {
        return this.prepared;
    }
}

