/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.StringUtils;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Util.PatternPreservingStringSplitter;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringPlaceholderEngine {
    private static final PatternPreservingStringSplitter STRING_SPLITTER = new PatternPreservingStringSplitter("(?<!\\\\)\\{[\\w-]+}");
    private final String[] components;
    private final int[] componentsMap;
    private final ArrayList<Placeholder> placeholderProcessors = new ArrayList();

    public StringPlaceholderEngine(@NotNull String input) {
        ArrayList<String> split = STRING_SPLITTER.split(input);
        ArrayList<String> components = new ArrayList<String>();
        this.componentsMap = new int[split.size()];
        int componentId = 0;
        for (int i = 0; i < split.size(); ++i) {
            String val = split.get(i);
            if (val == null) continue;
            components.add(val);
            this.componentsMap[i] = componentId;
            for (int j = i + 1; j < split.size(); ++j) {
                if (!val.equals(split.get(j))) continue;
                split.set(j, null);
                this.componentsMap[j] = componentId;
            }
            ++componentId;
        }
        this.components = components.toArray(new String[0]);
    }

    public void registerPlaceholder(@NotNull String placeholder, int parameterIndex, @Nullable IPlaceholderProcessor placeholderProcessor) {
        int placeholderIndexInMap = this.placeholderProcessors.size() | Integer.MIN_VALUE;
        int id = StringUtils.indexOf(this.components, placeholder);
        boolean contains = false;
        for (int i = 0; i < this.componentsMap.length; ++i) {
            if (this.componentsMap[i] != id) continue;
            this.componentsMap[i] = placeholderIndexInMap;
            contains = true;
        }
        if (contains) {
            this.placeholderProcessors.add(new Placeholder(parameterIndex, placeholderProcessor));
        }
    }

    public void registerPlaceholderRegex(@NotNull @Language(value="RegExp") String placeholderRegex, int parameterIndex, @Nullable IPlaceholderProcessor placeholderProcessor) {
        int placeholderIndexInMap = this.placeholderProcessors.size() | Integer.MIN_VALUE;
        Collection<Integer> ids = StringUtils.indexOfAllMatching(this.components, placeholderRegex);
        boolean contains = false;
        for (int i = 0; i < this.componentsMap.length; ++i) {
            if (!ids.contains(this.componentsMap[i])) continue;
            this.componentsMap[i] = placeholderIndexInMap;
            contains = true;
        }
        if (contains) {
            this.placeholderProcessors.add(new Placeholder(parameterIndex, placeholderProcessor));
        }
    }

    public String processPlaceholders(Object ... parameters) {
        Object[] resolvedPlaceholders = new Object[this.placeholderProcessors.size()];
        for (int i = 0; i < this.placeholderProcessors.size(); ++i) {
            Placeholder placeholder = this.placeholderProcessors.get(i);
            Object parameter = placeholder.parameterIndex >= parameters.length ? null : parameters[placeholder.parameterIndex];
            resolvedPlaceholders[i] = placeholder.processor != null ? placeholder.processor.process(parameter) : parameter;
        }
        return this.buildOutputString(resolvedPlaceholders);
    }

    private String buildOutputString(Object[] resolvedPlaceholders) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int componentId : this.componentsMap) {
            if (componentId < 0) {
                int placeholderId = componentId & Integer.MAX_VALUE;
                stringBuilder.append(resolvedPlaceholders[placeholderId]);
                continue;
            }
            stringBuilder.append(this.components[componentId]);
        }
        return stringBuilder.toString();
    }

    static class Placeholder {
        int parameterIndex;
        IPlaceholderProcessor processor;

        @Generated
        public Placeholder(int parameterIndex, IPlaceholderProcessor processor) {
            this.parameterIndex = parameterIndex;
            this.processor = processor;
        }
    }
}

