/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Placeholder {
    public static final int AUTO_INCREMENT_INDIVIDUALLY = -1;
    public static final int AUTO_INCREMENT_GROUP = -2;
    public static final int AUTO_INCREMENT_PATCH = -3;
    public static final int USE_LAST = -4;
    public static final int HIGHEST_USED = -5;
    public static final int MAX_PLACEHOLDERS = 256;
    private static final Pattern PATTERN_PLACEHOLDER_NAME = Pattern.compile("\\{[\\w-]+}");
    private final String name;
    private final IPlaceholderProcessor processor;
    private final int parameterIndex;
    private final boolean regex;

    public Placeholder(@NotNull String name) {
        this(name, null);
    }

    public Placeholder(@NotNull String name, int parameterIndex) {
        this(name, null, parameterIndex);
    }

    public Placeholder(@NotNull String name, @Nullable IPlaceholderProcessor processor) {
        this(name, processor, -3);
    }

    public Placeholder(@NotNull String name, @Nullable IPlaceholderProcessor processor, boolean regex) {
        this(name, processor, -3, regex);
    }

    public Placeholder(@NotNull String name, @Nullable IPlaceholderProcessor processor, int parameterIndex) {
        this(name, processor, parameterIndex, false);
    }

    public Placeholder(@NotNull String name, @Nullable IPlaceholderProcessor processor, int parameterIndex, boolean regex) {
        if (parameterIndex < -5) {
            throw new IllegalArgumentException("Invalid parameter index (" + parameterIndex + ") for placeholder '" + name + "'");
        }
        if (regex) {
            if (!name.startsWith("\\{") || !name.endsWith("}")) {
                name = "\\{" + name + '}';
            }
        } else {
            if (!name.startsWith("{") || !name.endsWith("}")) {
                name = '{' + name + '}';
            }
            if (!PATTERN_PLACEHOLDER_NAME.matcher(name).matches()) {
                throw new IllegalArgumentException("All placeholder names musst match the pattern: " + PATTERN_PLACEHOLDER_NAME.pattern());
            }
        }
        this.name = name;
        this.processor = processor;
        this.parameterIndex = parameterIndex;
        this.regex = regex;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public IPlaceholderProcessor getProcessor() {
        return this.processor;
    }

    @Generated
    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Generated
    public boolean isRegex() {
        return this.regex;
    }
}

