/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.MessageComponentToStringPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.IFormattedPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.StringPlaceholderEngine;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Placeholder.StringPlaceholderJsonEscapeProcessor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Util.PatternPreservingStringSplitter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageComponentPlaceholderEngine {
    private StringPlaceholderEngine placeholderEngine;
    private final Message message;
    private final List<PlaceholderData> tmpPlaceholderList = new ArrayList<PlaceholderData>();

    public MessageComponentPlaceholderEngine(Message message) {
        this.message = message;
    }

    public void registerPlaceholder(@NotNull String placeholder, int placeholderIndex, @Nullable IPlaceholderProcessor placeholderProcessor) {
        this.tmpPlaceholderList.add(new PlaceholderData(false, placeholder, placeholderIndex, placeholderProcessor));
    }

    public void registerPlaceholderRegex(@NotNull @Language(value="RegExp") String placeholderRegex, int placeholderIndex, @Nullable IPlaceholderProcessor placeholderProcessor) {
        this.tmpPlaceholderList.add(new PlaceholderData(true, placeholderRegex, placeholderIndex, placeholderProcessor));
    }

    public void prepare() {
        String json = this.message.getJson();
        MessageComponent[] messageComponents = null;
        ArrayList<String> placeholdersToReplace = new ArrayList<String>();
        for (PlaceholderData placeholderData : this.tmpPlaceholderList) {
            if (!placeholderData.isFormatted()) continue;
            if (messageComponents == null) {
                messageComponents = this.message.getMessageComponents();
            }
            String placeholder = placeholderData.placeholder;
            if (!placeholderData.isRegex()) {
                placeholder = "\\" + placeholder;
            }
            PatternPreservingStringSplitter splitter = new PatternPreservingStringSplitter(placeholder);
            for (MessageComponent component : messageComponents) {
                component.split(splitter);
            }
            placeholdersToReplace.add(placeholder);
        }
        if (messageComponents != null) {
            json = MessageComponent.toJSON(messageComponents);
            for (String toReplace : placeholdersToReplace) {
                String pattern = "\\{\"text\":\"(" + toReplace + ")\"}";
                json = json.replaceAll(pattern, "$1");
            }
        }
        this.placeholderEngine = new StringPlaceholderEngine(json);
        for (PlaceholderData placeholderData : this.tmpPlaceholderList) {
            if (placeholderData.isRegex()) {
                this.placeholderEngine.registerPlaceholderRegex(placeholderData.getPlaceholder(), placeholderData.getPlaceholderIndex(), placeholderData.getPlaceholderProcessor());
                continue;
            }
            this.placeholderEngine.registerPlaceholder(placeholderData.getPlaceholder(), placeholderData.getPlaceholderIndex(), placeholderData.getPlaceholderProcessor());
        }
    }

    public String processPlaceholders(Object ... parameters) {
        if (this.placeholderEngine == null) {
            this.prepare();
        }
        return this.placeholderEngine.processPlaceholders(parameters);
    }

    private static class PlaceholderData {
        private final boolean regex;
        private final boolean formatted;
        private final String placeholder;
        private final int placeholderIndex;
        private final IPlaceholderProcessor placeholderProcessor;

        public PlaceholderData(boolean regex, @NotNull String placeholder, int placeholderIndex, @Nullable IPlaceholderProcessor placeholderProcessor) {
            this.regex = regex;
            this.placeholder = placeholder;
            this.placeholderIndex = placeholderIndex;
            if (placeholderProcessor instanceof IFormattedPlaceholderProcessor) {
                this.placeholderProcessor = new MessageComponentToStringPlaceholderProcessor((IFormattedPlaceholderProcessor)placeholderProcessor);
                this.formatted = true;
            } else {
                this.placeholderProcessor = new StringPlaceholderJsonEscapeProcessor(placeholderProcessor);
                this.formatted = false;
            }
        }

        @Generated
        public boolean isRegex() {
            return this.regex;
        }

        @Generated
        public boolean isFormatted() {
            return this.formatted;
        }

        @Generated
        public String getPlaceholder() {
            return this.placeholder;
        }

        @Generated
        public int getPlaceholderIndex() {
            return this.placeholderIndex;
        }

        @Generated
        public IPlaceholderProcessor getPlaceholderProcessor() {
            return this.placeholderProcessor;
        }
    }
}

