/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message;

import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MessageFormat {
    MAGIC('k'),
    BOLD('l'),
    STRIKETHROUGH('m'),
    UNDERLINE('n'),
    ITALIC('o'),
    RESET('r');

    public static final char FORMAT_CHAR = '\u00a7';
    public static final String ALL_CODES = "KkLlMmNnOoRr";
    private static final Pattern STRIP_FORMAT_PATTERN;
    private static final Pattern STRIP_COLOR_AND_FORMAT_PATTERN;
    private final char code;
    private final String codeString;

    private MessageFormat(char code) {
        this.code = code;
        this.codeString = new String(new char[]{'\u00a7', code});
    }

    public String toString() {
        return this.codeString;
    }

    public static boolean isFormatChar(char code) {
        return code >= 'K' && code <= 'O' || code >= 'k' && code <= 'o';
    }

    @NotNull
    public static MessageFormat getFromCode(char code) throws IllegalArgumentException {
        if (code >= 'K' && code <= 'R') {
            code = (char)(code - 65 + 97);
        }
        if (code >= 'k' && code <= 'o') {
            return MessageFormat.values()[code - 107];
        }
        if (code == 'r') {
            return RESET;
        }
        throw new IllegalArgumentException("Unknown format code '" + code + "'!");
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public String strip(@Nullable String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll(this.toString(), "");
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String stripColorAndFormat(@Nullable String input) {
        if (input == null) {
            return null;
        }
        return STRIP_COLOR_AND_FORMAT_PATTERN.matcher(input).replaceAll("");
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String stripFormat(@Nullable String input) {
        if (input == null) {
            return null;
        }
        return STRIP_FORMAT_PATTERN.matcher(input).replaceAll("");
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String translateAlternateFormatCodes(@Nullable String textToTranslate) {
        return MessageFormat.translateAlternateFormatCodes('&', textToTranslate);
    }

    @Contract(value="_,!null->!null; _,null->null")
    @Nullable
    public static String translateAlternateFormatCodes(char altColorChar, @Nullable String textToTranslate) {
        return MessageFormat.translateFormatCode(altColorChar, '\u00a7', textToTranslate);
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String translateToAlternateFormatCodes(@Nullable String textToTranslate) {
        return MessageFormat.translateToAlternateFormatCodes('&', textToTranslate);
    }

    @Contract(value="_,!null->!null; _,null->null")
    @Nullable
    public static String translateToAlternateFormatCodes(char altColorChar, @Nullable String textToTranslate) {
        return MessageFormat.translateFormatCode('\u00a7', altColorChar, textToTranslate);
    }

    @Contract(value="_,_,!null->!null; _,_,null->null")
    @Nullable
    private static String translateFormatCode(char from, char to, @Nullable String textToTranslate) {
        if (textToTranslate == null || textToTranslate.length() < 2) {
            return textToTranslate;
        }
        char[] chars = textToTranslate.toCharArray();
        int i = 0;
        while (i + 1 < chars.length) {
            if (chars[i] == from && ALL_CODES.indexOf(chars[i + 1]) > -1) {
                chars[i] = to;
                chars[i + 1] = Character.toLowerCase(chars[i + 1]);
            }
            ++i;
        }
        return new String(chars);
    }

    @Generated
    public char getCode() {
        return this.code;
    }

    static {
        STRIP_FORMAT_PATTERN = Pattern.compile("(?i)\u00a7[K-OR]");
        STRIP_COLOR_AND_FORMAT_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    }
}

