/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.Message;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageClickEvent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageFormat;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message.MessageHoverEvent;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Util.PatternPreservingStringSplitter;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.Gson;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.GsonBuilder;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonArray;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonElement;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonObject;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonParser;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonPrimitive;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonSerializationContext;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageComponent
implements Serializable {
    protected MessageClickEvent clickEvent = null;
    protected MessageHoverEvent hoverEvent = null;
    protected String text;
    protected String insertion;
    protected MessageColor color;
    protected Boolean bold;
    protected Boolean italic;
    protected Boolean underlined;
    protected Boolean strikethrough;
    protected Boolean obfuscated;
    protected List<MessageComponent> extra = null;
    @Nullable
    protected String font = null;
    protected Object selector;
    protected Object score;
    protected Object translate;
    protected List<Object> with;
    protected static final transient Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(List.class, new ListAdapter()).registerTypeAdapter((Type)((Object)MessageColor.class), new MessageColor.MessageColorSerializer()).disableHtmlEscaping().create();
    protected static final transient MessageComponent MESSAGE_COMPONENT_INSTANCE = new MessageComponent();

    public String toString() {
        return GSON.toJson(this);
    }

    public MessageComponent() {
    }

    public MessageComponent(String text, MessageFormat ... formats) {
        this.setText(text);
        if (formats != null) {
            this.setFormats(formats);
        }
    }

    public MessageComponent(String text, @Nullable MessageColor color, MessageFormat ... formats) {
        this.setText(text);
        if (color != null) {
            this.setColor(color);
        }
        if (formats != null) {
            this.setFormats(formats);
        }
    }

    public String getClassicMessage() {
        StringBuilder stringBuilder = new StringBuilder(this.getClassicFormats());
        if (this.text != null) {
            stringBuilder.append(this.text);
        }
        if (this.extra != null) {
            for (MessageComponent e : this.extra) {
                stringBuilder.append(e.getClassicMessage());
            }
        }
        stringBuilder.append(MessageColor.RESET);
        return stringBuilder.toString();
    }

    @NotNull
    public static String getClassicMessage(Collection<? extends MessageComponent> messageList) {
        if (messageList == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        String classFormat = "";
        for (MessageComponent messageComponent : messageList) {
            if (first) {
                classFormat = messageComponent.getClassicFormats();
                first = false;
            } else {
                builder.append(classFormat);
            }
            builder.append(messageComponent.getClassicMessage());
        }
        return builder.toString();
    }

    public String getClassicFormats() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isBold()) {
            stringBuilder.append((Object)MessageFormat.BOLD);
        }
        if (this.isItalic()) {
            stringBuilder.append((Object)MessageFormat.ITALIC);
        }
        if (this.isObfuscated()) {
            stringBuilder.append((Object)MessageFormat.MAGIC);
        }
        if (this.isUnderlined()) {
            stringBuilder.append((Object)MessageFormat.UNDERLINE);
        }
        if (this.isStrikethrough()) {
            stringBuilder.append((Object)MessageFormat.STRIKETHROUGH);
        }
        if (this.color != null) {
            stringBuilder.append(this.getColor().toString().toLowerCase(Locale.ROOT));
        }
        return stringBuilder.toString();
    }

    public MessageClickEvent getClickEvent() {
        return this.clickEvent;
    }

    public MessageComponent setClickEvent(MessageClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    public MessageHoverEvent getHoverEvent() {
        return this.hoverEvent;
    }

    public MessageComponent setHoverEvent(MessageHoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public MessageComponent setText(String text) {
        this.text = text;
        return this;
    }

    public MessageColor getColor() {
        return this.color;
    }

    public String getColorString() {
        return this.getColor().name().toLowerCase(Locale.ROOT);
    }

    public MessageComponent setColor(@NotNull String color) {
        MessageColor c = MessageColor.getColor(color);
        if (c == null) {
            throw new IllegalArgumentException(color + " not a valid color!");
        }
        return this.setColor(c);
    }

    public MessageComponent setColor(MessageColor color) throws IllegalArgumentException {
        this.color = color == MessageColor.RESET ? null : color;
        return this;
    }

    public String getInsertion() {
        return this.insertion;
    }

    public MessageComponent setInsertion(String insertionText) {
        this.insertion = insertionText.length() > 100 ? insertionText.substring(0, 100) : insertionText;
        return this;
    }

    public boolean isBold() {
        return this.bold != null && this.bold != false;
    }

    public MessageComponent setBold() {
        return this.setBold(true);
    }

    public MessageComponent setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public boolean isItalic() {
        return this.italic != null && this.italic != false;
    }

    public MessageComponent setItalic() {
        return this.setItalic(true);
    }

    public MessageComponent setItalic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public boolean isUnderlined() {
        return this.underlined != null && this.underlined != false;
    }

    public MessageComponent setUnderlined() {
        return this.setUnderlined(true);
    }

    public MessageComponent setUnderlined(boolean underlined) {
        this.underlined = underlined;
        return this;
    }

    public boolean isStrikethrough() {
        return this.strikethrough != null && this.strikethrough != false;
    }

    public MessageComponent setStrikethrough() {
        return this.setStrikethrough(true);
    }

    public MessageComponent setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
        return this;
    }

    public boolean isObfuscated() {
        return this.obfuscated != null && this.obfuscated != false;
    }

    public MessageComponent setObfuscated() {
        return this.setObfuscated(true);
    }

    public MessageComponent setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
        return this;
    }

    public List<? extends MessageComponent> getExtras() {
        return this.extra;
    }

    public MessageComponent setExtras(List<MessageComponent> extras) {
        this.extra = extras;
        return this;
    }

    public MessageComponent addExtra(MessageComponent ... extras) {
        if (extras != null) {
            for (MessageComponent extra : extras) {
                if (extra == null) continue;
                if (this.extra == null) {
                    this.extra = new ArrayList<MessageComponent>();
                }
                this.extra.add(extra);
            }
        }
        return this;
    }

    public MessageComponent setFormats(MessageFormat ... formats) {
        if (formats != null) {
            block8: for (MessageFormat format : formats) {
                switch (format) {
                    case ITALIC: {
                        this.setItalic();
                        continue block8;
                    }
                    case BOLD: {
                        this.setBold();
                        continue block8;
                    }
                    case UNDERLINE: {
                        this.setUnderlined();
                        continue block8;
                    }
                    case STRIKETHROUGH: {
                        this.setStrikethrough();
                        continue block8;
                    }
                    case MAGIC: {
                        this.setObfuscated();
                        continue block8;
                    }
                    case RESET: {
                        this.strikethrough = this.obfuscated = Boolean.valueOf(false);
                        this.underlined = this.obfuscated;
                        this.bold = this.obfuscated;
                        this.italic = this.obfuscated;
                    }
                }
            }
        }
        return this;
    }

    public MessageComponent setFormats(Collection<MessageFormat> formats) {
        formats.forEach(xva$0 -> this.setFormats((MessageFormat)((Object)xva$0)));
        return this;
    }

    public MessageComponent setFont(@Nullable String font) {
        this.font = font;
        return this;
    }

    public MessageComponent text(String text) {
        return this.setText(text);
    }

    public MessageComponent color(String color) {
        return this.setColor(color);
    }

    public MessageComponent color(MessageColor color) throws IllegalArgumentException {
        return this.setColor(color);
    }

    public MessageComponent format(MessageFormat ... formats) throws IllegalArgumentException {
        return this.setFormats(formats);
    }

    public MessageComponent format(Collection<MessageFormat> formats) throws IllegalArgumentException {
        return this.setFormats(formats);
    }

    public MessageComponent font(@Nullable String font) {
        return this.setFont(font);
    }

    public MessageComponent bold() {
        return this.setBold();
    }

    public MessageComponent italic() {
        return this.setItalic();
    }

    public MessageComponent underlined() {
        return this.setUnderlined();
    }

    public MessageComponent obfuscated() {
        return this.setObfuscated();
    }

    public MessageComponent strikethrough() {
        return this.setStrikethrough();
    }

    public MessageComponent onClick(MessageClickEvent.ClickEventAction action, String value) {
        return this.setClickEvent(new MessageClickEvent(action, value));
    }

    public MessageComponent file(String path) {
        return this.onClick(MessageClickEvent.ClickEventAction.OPEN_FILE, path);
    }

    public MessageComponent link(String url) {
        return this.onClick(MessageClickEvent.ClickEventAction.OPEN_URL, url);
    }

    public MessageComponent suggest(String command) {
        return this.onClick(MessageClickEvent.ClickEventAction.SUGGEST_COMMAND, command);
    }

    public MessageComponent command(String command) {
        return this.onClick(MessageClickEvent.ClickEventAction.RUN_COMMAND, command);
    }

    public MessageComponent insert(String insert) {
        return this.setInsertion(insert);
    }

    public MessageComponent onHover(@NotNull MessageHoverEvent.HoverEventAction action, @Nullable String value) {
        if (value == null) {
            return this;
        }
        return this.setHoverEvent(new MessageHoverEvent(action, value));
    }

    public MessageComponent onHover(MessageHoverEvent.HoverEventAction action, Collection<? extends MessageComponent> value) {
        return this.setHoverEvent(new MessageHoverEvent(action, value));
    }

    public MessageComponent achievementTooltip(String name) {
        return this.onHover(MessageHoverEvent.HoverEventAction.SHOW_ACHIEVEMENT, "achievement." + name);
    }

    public MessageComponent statisticTooltip(String name) {
        return this.onHover(MessageHoverEvent.HoverEventAction.SHOW_ACHIEVEMENT, "stat." + name);
    }

    public MessageComponent itemTooltip(String itemJSON) {
        return this.onHover(MessageHoverEvent.HoverEventAction.SHOW_ITEM, itemJSON);
    }

    public MessageComponent tooltip(String ... lines) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                builder.append('\n');
            }
            builder.append(lines[i]);
        }
        return this.onHover(MessageHoverEvent.HoverEventAction.SHOW_TEXT, builder.toString());
    }

    public MessageComponent formattedTooltip(MessageComponent ... text) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder();
        for (MessageComponent t : text) {
            if (t.getClickEvent() != null) {
                throw new IllegalArgumentException("The tooltip text cannot have click data.");
            }
            if (t.getHoverEvent() != null) {
                throw new IllegalArgumentException("The tooltip text cannot have a tooltip.");
            }
            builder.append(t.toString());
        }
        return this.onHover(MessageHoverEvent.HoverEventAction.SHOW_TEXT, builder.toString());
    }

    public MessageComponent getNewLineComponent() {
        return new MessageComponent("\n", new MessageFormat[0]);
    }

    public static MessageComponent makeNewLineComponent() {
        return new MessageComponent("\n", new MessageFormat[0]);
    }

    public MessageComponent formattedTooltip(Message ... lines) throws IllegalArgumentException {
        if (lines.length < 1) {
            return this.setHoverEvent(null);
        }
        ArrayList<MessageComponent> components = new ArrayList<MessageComponent>();
        for (int i = 0; i < lines.length; ++i) {
            for (MessageComponent component : lines[i].getMessageComponents()) {
                if (component.getClickEvent() != null) {
                    throw new IllegalArgumentException("The tooltip text cannot have click data.");
                }
                if (component.getHoverEvent() != null) {
                    throw new IllegalArgumentException("The tooltip text cannot have a tooltip.");
                }
                if (i > 0) {
                    components.add(this.getNewLineComponent());
                }
                components.add(component);
            }
        }
        return this.onHover(MessageHoverEvent.HoverEventAction.SHOW_TEXT, components);
    }

    public MessageComponent extra(MessageComponent ... extras) {
        return this.addExtra(extras);
    }

    public boolean isEmpty() {
        return !(this.text != null && !this.text.isEmpty() || this.extra != null && !this.extra.isEmpty() || this.color != null || this.font != null && !this.font.isEmpty() || this.insertion != null && !this.insertion.isEmpty() || this.isBold() || this.isItalic() || this.isUnderlined() || this.isStrikethrough() || this.isObfuscated() || this.with != null && !this.with.isEmpty() || this.score != null || this.translate != null || this.selector != null);
    }

    public MessageComponent split(@NotNull @Language(value="RegExp") String pattern) {
        return this.split(new PatternPreservingStringSplitter(pattern));
    }

    public MessageComponent split(@NotNull PatternPreservingStringSplitter splitter) {
        ArrayList components;
        if (this.extra != null) {
            for (MessageComponent component : this.extra) {
                component.split(splitter);
            }
        }
        ArrayList<Object> arrayList = components = this.text != null && !this.text.isEmpty() ? splitter.split(this.text) : new ArrayList(0);
        if (components.size() > 1) {
            if (splitter.getPlaceholderPattern().matcher((CharSequence)components.get(0)).matches()) {
                this.text = "";
            } else {
                this.text = (String)components.get(0);
                components.remove(0);
            }
            ArrayList<MessageComponent> newMessageComponents = new ArrayList<MessageComponent>();
            for (String component : components) {
                if (component.isEmpty()) continue;
                newMessageComponents.add(new MessageComponent(component, new MessageFormat[0]));
            }
            if (!newMessageComponents.isEmpty()) {
                if (this.extra != null) {
                    this.extra.addAll(0, newMessageComponents);
                } else {
                    this.extra = newMessageComponents;
                }
            }
        }
        return this;
    }

    public static String toJSON(MessageComponent ... components) {
        String json = GSON.toJson(components);
        if (json.startsWith("[{},")) {
            json = "[\"\"," + json.substring(4);
        }
        return json;
    }

    protected List<MessageComponent> fromJsonWorker(String jsonString) {
        return this.fromJsonArrayWorker(JsonParser.parseString(jsonString).getAsJsonArray());
    }

    protected List<MessageComponent> fromJsonArrayWorker(JsonArray componentArray) {
        ArrayList<MessageComponent> components = new ArrayList<MessageComponent>();
        for (JsonElement component : componentArray) {
            if (component instanceof JsonPrimitive) {
                try {
                    MessageComponent messageComponent = new MessageComponent();
                    messageComponent.setText(component.getAsString());
                    components.add(messageComponent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (component instanceof JsonObject) {
                components.add(GSON.fromJson(component, MessageComponent.class));
                continue;
            }
            if (!(component instanceof JsonArray)) continue;
            components.addAll(this.fromJsonArrayWorker((JsonArray)component));
        }
        return components;
    }

    public static List<MessageComponent> fromJson(String jsonString) {
        return MESSAGE_COMPONENT_INSTANCE.fromJsonWorker(jsonString);
    }

    public static List<MessageComponent> fromJsonArray(JsonArray componentArray) {
        return MESSAGE_COMPONENT_INSTANCE.fromJsonArrayWorker(componentArray);
    }

    @Nullable
    @Generated
    public String getFont() {
        return this.font;
    }

    private static class ListAdapter
    implements JsonSerializer<List<?>> {
        private ListAdapter() {
        }

        @Override
        public JsonElement serialize(List<?> src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null || src.isEmpty()) {
                return null;
            }
            JsonArray array = new JsonArray();
            for (Object child : src) {
                JsonElement element = context.serialize(child);
                array.add(element);
            }
            return array;
        }
    }
}

