/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMasterStandalone.libs.at.pcgamingfreaks.Message;

import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonDeserializationContext;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonDeserializer;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonElement;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonParseException;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonPrimitive;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonSerializationContext;
import at.pcgamingfreaks.MarriageMasterStandalone.libs.com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageColor {
    private static final Map<String, MessageColor> BY_NAME = new HashMap<String, MessageColor>();
    private static final MessageColor[] COLORS = new MessageColor[17];
    public static final char COLOR_CHAR = '\u00a7';
    public static final String COLOR_CODES = "0123456789AaBbCcDdEeFfRrXx";
    public static final String ALL_CODES = "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx";
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-F]");
    private static final Pattern STRIP_COLOR_AND_FORMAT_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public static final MessageColor BLACK = new MessageColor('0', "black", "000000");
    public static final MessageColor DARK_BLUE = new MessageColor('1', "dark_blue", "0000AA");
    public static final MessageColor DARK_GREEN = new MessageColor('2', "dark_green", "00AA00");
    public static final MessageColor DARK_AQUA = new MessageColor('3', "dark_aqua", "00AAAA");
    public static final MessageColor DARK_RED = new MessageColor('4', "dark_red", "AA0000");
    public static final MessageColor DARK_PURPLE = new MessageColor('5', "dark_purple", "AA00AA");
    public static final MessageColor GOLD = new MessageColor('6', "gold", "FFAA00");
    public static final MessageColor GRAY = new MessageColor('7', "gray", "AAAAAA");
    public static final MessageColor DARK_GRAY = new MessageColor('8', "dark_gray", "555555");
    public static final MessageColor BLUE = new MessageColor('9', "blue", "5555FF");
    public static final MessageColor GREEN = new MessageColor('a', "green", "55FF55");
    public static final MessageColor AQUA = new MessageColor('b', "aqua", "55FFFF");
    public static final MessageColor RED = new MessageColor('c', "red", "FF5555");
    public static final MessageColor LIGHT_PURPLE = new MessageColor('d', "light_purple", "FF55FF");
    public static final MessageColor YELLOW = new MessageColor('e', "yellow", "FFFF55");
    public static final MessageColor WHITE = new MessageColor('f', "white", "FFFFFF");
    public static final MessageColor RESET = new MessageColor('r', null, null);
    private final char code;
    private final String toString;
    private final String rgbColor;
    private final String name;
    private final String nameUpper;
    private final int rgb;
    private final MessageColor fallbackColor;

    private MessageColor(char code, String name, String rgbColor) {
        this.code = code;
        this.name = name;
        this.toString = new String(new char[]{'\u00a7', code});
        this.fallbackColor = this;
        MessageColor.COLORS[this.ordinal()] = this;
        if (name == null) {
            this.rgbColor = null;
            this.rgb = -1;
            this.nameUpper = "RESET";
        } else {
            this.rgbColor = '#' + rgbColor;
            this.rgb = Integer.parseInt(rgbColor, 16);
            this.nameUpper = name.toUpperCase(Locale.ENGLISH);
            BY_NAME.put(name, this);
            BY_NAME.put(this.nameUpper, this);
            if (name.contains("_")) {
                name = name.replaceAll("_", "");
                BY_NAME.put(name, this);
                BY_NAME.put(name.toUpperCase(Locale.ENGLISH), this);
            }
        }
    }

    private MessageColor(String rgbColor) {
        this.code = (char)120;
        StringBuilder builder = new StringBuilder().append('\u00a7').append(this.code);
        for (char code : rgbColor.toCharArray()) {
            builder.append('\u00a7').append(code);
        }
        this.toString = builder.toString();
        this.rgbColor = '#' + rgbColor;
        this.name = null;
        this.nameUpper = "RGB";
        this.rgb = Integer.parseInt(rgbColor, 16);
        this.fallbackColor = MessageColor.getNearestColor(this.rgb);
    }

    public String toString() {
        return this.toString;
    }

    public int hashCode() {
        return 371 + Objects.hashCode(this.toString());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.toString.equals(other.toString());
    }

    @NotNull
    public static List<String> getNamesStartingWith(@NotNull String startsWith) {
        String starts = startsWith.toLowerCase(Locale.ENGLISH);
        return BY_NAME.keySet().stream().filter(name -> name.startsWith(starts)).collect(Collectors.toList());
    }

    public static boolean isColorChar(char code) {
        return code >= '0' && code <= '9' || code >= 'A' && code <= 'F' || code >= 'a' && code <= 'f';
    }

    @NotNull
    public static MessageColor getFromCode(char code) throws IllegalArgumentException {
        if (code >= '0' && code <= '9') {
            return MessageColor.values()[code - 48];
        }
        if (code >= 'A' && code <= 'R') {
            code = (char)(code - 65 + 97);
        }
        if (code >= 'a' && code <= 'f') {
            return MessageColor.values()[code - 97 + 10];
        }
        if (code == 'r') {
            return RESET;
        }
        throw new IllegalArgumentException("Unknown format code '" + code + "'!");
    }

    @Nullable
    public static MessageColor getColor(@NotNull String color) {
        if (color.length() == 0) {
            return null;
        }
        if (color.charAt(0) == '&' || color.charAt(0) == '\u00a7') {
            color = color.substring(1);
        }
        if (color.length() == 0) {
            return null;
        }
        if (color.length() == 1) {
            try {
                return MessageColor.getFromCode(color.charAt(0));
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
        if (color.length() == 2) {
            try {
                return MessageColor.values()[Integer.parseInt(color)];
            }
            catch (IndexOutOfBoundsException | NumberFormatException ignored) {
                return null;
            }
        }
        color = color.toUpperCase(Locale.ENGLISH);
        try {
            return MessageColor.valueOf(color);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static MessageColor getDefaultColor(@NotNull String rgbColor) {
        if (rgbColor.length() == 7 && rgbColor.charAt(0) == '#') {
            rgbColor = rgbColor.substring(1);
        }
        return MessageColor.getNearestColor(Integer.parseInt(rgbColor, 16));
    }

    private static MessageColor getNearestColor(int rgb) {
        int nearest = Integer.MAX_VALUE;
        MessageColor nearestColor = null;
        for (int i = 0; i < 16; ++i) {
            MessageColor c = MessageColor.values()[i];
            int r = (c.rgb >> 16) - (rgb >> 16);
            int g = (c.rgb >> 8 & 0xFF) - (rgb >> 8 & 0xFF);
            int b = (c.rgb & 0xFF) - (rgb & 0xFF);
            int dist = r * r + g * g + b * b;
            if (dist >= nearest) continue;
            nearest = dist;
            nearestColor = c;
        }
        return nearestColor;
    }

    public static MessageColor valueOf(@NotNull String name) {
        if (name.equals("RESET")) {
            return RESET;
        }
        if (name.length() == 7 && name.charAt(0) == '#') {
            return new MessageColor(name.substring(1));
        }
        MessageColor color = BY_NAME.get(name);
        if (color == null) {
            throw new IllegalArgumentException(name + " is not a MessageColor!");
        }
        return color;
    }

    public static MessageColor[] values() {
        return COLORS;
    }

    public int ordinal() {
        if (this.code == 'x') {
            return Integer.MAX_VALUE;
        }
        if (this.code >= '0' && this.code <= '9') {
            return this.code - 48;
        }
        if (this.code >= 'a' && this.code <= 'f') {
            return this.code - 97 + 10;
        }
        return 16;
    }

    @NotNull
    public String name() {
        return this.nameUpper;
    }

    public boolean isRGB() {
        return this != this.fallbackColor;
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public String strip(@Nullable String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll(this.toString(), "");
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String stripColorAndFormat(@Nullable String input) {
        if (input == null) {
            return null;
        }
        return STRIP_COLOR_AND_FORMAT_PATTERN.matcher(input).replaceAll("");
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String stripColor(@Nullable String input) {
        if (input == null) {
            return null;
        }
        return STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String translateAlternateColorCodes(@Nullable String textToTranslate) {
        return MessageColor.translateAlternateColorCodes('&', textToTranslate);
    }

    @Contract(value="_,!null->!null; _,null->null")
    @Nullable
    public static String translateAlternateColorCodes(char altColorChar, @Nullable String textToTranslate) {
        return MessageColor.translateColorCode(altColorChar, '\u00a7', textToTranslate, COLOR_CODES);
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String translateToAlternateColorCodes(@Nullable String textToTranslate) {
        return MessageColor.translateToAlternateColorCodes('&', textToTranslate);
    }

    @Contract(value="_,!null->!null; _,null->null")
    @Nullable
    public static String translateToAlternateColorCodes(char altColorChar, @Nullable String textToTranslate) {
        return MessageColor.translateColorCode('\u00a7', altColorChar, textToTranslate, COLOR_CODES);
    }

    @Contract(value="!null->!null; null->null")
    @Nullable
    public static String translateAlternateColorAndFormatCodes(@Nullable String textToTranslate) {
        return MessageColor.translateColorCode('&', '\u00a7', textToTranslate, ALL_CODES);
    }

    @Contract(value="_,_,!null,_->!null; _,_,null,_->null")
    @Nullable
    private static String translateColorCode(char from, char to, @Nullable String textToTranslate, @NotNull String charSet) {
        if (textToTranslate == null || textToTranslate.length() < 2) {
            return textToTranslate;
        }
        char[] chars = textToTranslate.toCharArray();
        int i = 0;
        while (i + 1 < chars.length) {
            if (chars[i] == from && charSet.indexOf(chars[i + 1]) > -1) {
                chars[i] = to;
                chars[i + 1] = Character.toLowerCase(chars[i + 1]);
            }
            ++i;
        }
        return new String(chars);
    }

    @Generated
    public char getCode() {
        return this.code;
    }

    @Generated
    public String getRgbColor() {
        return this.rgbColor;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public MessageColor getFallbackColor() {
        return this.fallbackColor;
    }

    public static class MessageColorSerializer
    implements JsonSerializer<MessageColor>,
    JsonDeserializer<MessageColor> {
        @Override
        public JsonElement serialize(MessageColor src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.getName() != null) {
                return new JsonPrimitive(src.getName());
            }
            if (src.getRgbColor() != null) {
                return new JsonPrimitive(src.getRgbColor());
            }
            return null;
        }

        @Override
        public MessageColor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return MessageColor.valueOf(json.getAsString());
        }
    }
}

